
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Using insertBefore on a DocumentFragment node attempt to insert a child nodes before
 *  other permissible nodes and verify the contents/name of each inserted node.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-952280727">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-952280727</a>
*/
public final class nodeinsertbefore11 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodeinsertbefore11(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      DocumentFragment docFrag;
      Element elem;
      ProcessingInstruction pi;
      Comment comment;
      Text txt;
      CDATASection cdata;
      EntityReference eRef;
      Node inserted;
      String insertedVal;
      Node appendedChild;
      doc = (Document) load("hc_staff", true);
      docFrag = doc.createDocumentFragment();
      elem = doc.createElementNS("http://www.w3.org/1999/xhtml", "body");
      pi = doc.createProcessingInstruction("PITarget", "PIData");
      comment = doc.createComment("Comment");
      txt = doc.createTextNode("Text");
      cdata = doc.createCDATASection("CDATA");
      eRef = doc.createEntityReference("alpha");
      appendedChild = docFrag.appendChild(elem);
      appendedChild = docFrag.appendChild(pi);
      appendedChild = docFrag.appendChild(comment);
      appendedChild = docFrag.appendChild(txt);
      appendedChild = docFrag.appendChild(cdata);
      appendedChild = docFrag.appendChild(eRef);
      inserted = docFrag.insertBefore(comment, pi);
      insertedVal = ((CharacterData) /*Node */inserted).getData();
      assertEquals("nodeinsertbefore11_Comment", "Comment", insertedVal);
      inserted = docFrag.insertBefore(txt, comment);
      insertedVal = ((CharacterData) /*Node */inserted).getData();
      assertEquals("nodeinsertbefore11_Text", "Text", insertedVal);
      inserted = docFrag.insertBefore(cdata, txt);
      insertedVal = ((CharacterData) /*Node */inserted).getData();
      assertEquals("nodeinsertbefore11_CDATA", "CDATA", insertedVal);
      inserted = docFrag.insertBefore(eRef, cdata);
      insertedVal = inserted.getNodeName();
      assertEquals("nodeinsertbefore11_Ent1", "alpha", insertedVal);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodeinsertbefore11";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodeinsertbefore11.class, args);
   }
}

