<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:doc="http://nwalsh.com/xsl/documentation/1.0" xmlns:src="http://nwalsh.com/xmlns/litprog/fragment" exclude-result-prefixes="src" version="1.0">

<!-- This file is generated from param.xweb; do not edit this file! -->
<!-- ********************************************************************
     $Id: param.xweb,v 1.24 2006/04/26 04:38:28 xmldoc Exp $
     ********************************************************************

     This file is part of the XSL DocBook Stylesheet distribution.
     See ../README or http://nwalsh.com/docbook/xsl/ for copyright
     and other information.

     ******************************************************************** -->

<doc:refentry><refmeta>
<refentrytitle>man.hyphenate</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.hyphenate</refname>
<refpurpose>Enable hyphenation?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If non-zero, hyphenation is enabled.</para>

<note>
<para>The default value for this parameter is zero because groff is
not particularly smart about how it does hyphenation; it can end up
hyphenating a lot of things that you don't want hyphenated. To
mitigate that, the default behavior of the stylesheets is to suppress
hyphenation of computer inlines, filenames, and URLs. (You can
override the default behavior by setting non-zero values for the
<parameter>man.hyphenate.urls</parameter>,
<parameter>man.hyphenate.filenames</parameter>, and
<parameter>man.hyphenate.computer.inlines</parameter> parameters.) But
the best way is still to just globally disable hyphenation, as the
stylesheets do by default.</para>

<para>The only good reason to enabled hyphenation is if you have also
enabled justification (which is disabled by default). The reason is
that justified text can look very bad unless you also hyphenate it; to
quote the <quote>Hypenation</quote> node from the groff info page:

<blockquote>
  <para><emphasis>Since the odds are not great for finding a set of
  words, for every output line, which fit nicely on a line without
  inserting excessive amounts of space between words, 'gtroff'
  hyphenates words so that it can justify lines without inserting too
  much space between words.</emphasis></para>
</blockquote>

So, if you set a non-zero value for the
<parameter>man.justify</parameter> parameter (to enable
justification), then you should probably also set a non-zero value for
<parameter>man.hyphenate</parameter> (to enable hyphenation).</para>
</note>


</refsect1>
</doc:refentry>
<xsl:param name="man.hyphenate">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.hyphenate.urls</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.hyphenate.urls</refname>
<refpurpose>Hyphenate URLs?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If zero (the default), hyphenation is suppressed for output of
the <tag>ulink</tag> <tag class="attribute">url</tag> attribute.</para>

<note>
  <para>If hyphenation is already turned off globally (that is, if
  <parameter>man.hyphenate</parameter> is zero, setting
  <parameter>man.hyphenate.urls</parameter> is not necessary.</para>
</note>

<para>If <parameter>man.hyphenate.urls</parameter> is non-zero, URLs
will not be treated specially and are subject to hyphenation just like
other words.</para>

<note>
  <para>If you are thinking about setting a non-zero value for
  <parameter>man.hyphenate.urls</parameter> in order to make long
  URLs break across lines, you'd probably be better off
  experimenting with setting the
  <parameter>man.break.after.slash</parameter> parameter first. That
  will cause long URLs to be broken after slashes.</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="man.hyphenate.urls">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.hyphenate.filenames</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.hyphenate.filenames</refname>
<refpurpose>Hyphenate filenames?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If zero (the default), hyphenation is suppressed for
<tag>filename</tag> output.</para>

<note>
  <para>If hyphenation is already turned off globally (that is, if
  <parameter>man.hyphenate</parameter> is zero, setting
  <parameter>man.hyphenate.filenames</parameter> is not
  necessary.</para>
</note>

<para>If <parameter>man.hyphenate.filenames</parameter> is non-zero,
filenames will not be treated specially and are subject to hyphenation
just like other words.</para>

<note>
  <para>If you are thinking about setting a non-zero value for
  <parameter>man.hyphenate.filenames</parameter> in order to make long
  filenames/pathnames break across lines, you'd probably be better off
  experimenting with setting the
  <parameter>man.break.after.slash</parameter> parameter first. That
  will cause long pathnames to be broken after slashes.</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="man.hyphenate.filenames">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.hyphenate.computer.inlines</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.hyphenate.computer.inlines</refname>
<refpurpose>Hyphenate computer inlines?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If zero (the default), hyphenation is suppressed for
<quote>computer inlines</quote> such as environment variables,
constants, etc. This parameter current affects output of the following
elements:
<simplelist type="inline">
  
  <member><tag>classname</tag></member>
  <member><tag>constant</tag></member>
  <member><tag>envar</tag></member>
  <member><tag>errorcode</tag></member>
  <member><tag>option</tag></member>
  <member><tag>replaceable</tag></member>
  <member><tag>userinput</tag></member>
  <member><tag>type</tag></member>
  <member><tag>varname</tag></member>
</simplelist>
</para>

<note>
  <para>If hyphenation is already turned off globally (that is, if
  <parameter>man.hyphenate</parameter> is zero, setting the
  <parameter>man.hyphenate.computer.inlines</parameter> is not
  necessary.</para>
</note>

<para>If <parameter>man.hyphenate.computer.inlines</parameter> is
non-zero, computer inlines will not be treated specially and will be
hyphenated like other words when needed.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.hyphenate.computer.inlines">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.justify</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.justify</refname>
<refpurpose>Justify text to both right and left margins?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If non-zero, text is justified to both the right and left
margins (or, in roff terminology, "adjusted and filled" to both the
right and left margins). If zero (the default), text is adjusted to
the left margin only -- producing what is traditionally called
"ragged-right" text.</para>

<note>
<para>The default value for this parameter is zero because justified
text looks good only when it is also hyphenated. Without hyphenation,
excessive amounts of space often end up getting between words, in
order to "pad" lines out to align on the right margin.</para>

<para>The problem is that groff is not particularly smart about how it
does hyphenation; it can end up hyphenating a lot of things that you
don't want hyphenated. So, disabling both justification and
hyphenation ensures that hyphens won't get inserted where you don't
want to them, and you don't end up with lines containing excessive
amounts of space between words.</para>

<para>However, if do you decide to set a non-zero value for the
<parameter>man.justify</parameter> parameter (to enable
justification), then you should probably also set a non-zero value for
<parameter>man.hyphenate</parameter> (to enable hyphenation).</para>

<para>Yes, these default settings run counter to how most existing man
pages are formatted. But there are some notable exceptions, such as
the <literal>perl</literal> man pages.</para>
</note>
</refsect1>
</doc:refentry>
<xsl:param name="man.justify">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.break.after.slash</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.break.after.slash</refname>
<refpurpose>Enable line-breaking after slashes?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If non-zero, line-breaking after slashes is enabled. This is
mainly useful for causing long URLs or pathnames/filenames to be
broken up or "wrapped" across lines (though it also has the side
effect of sometimes causing relatively short URLs and pathnames to be
broken up across lines too).</para>

<para>If zero (the default), line-breaking after slashes is
disabled. In that case, strings containing slashes (for example, URLs
or filenames) are not broken across lines, even if they exceed the
maximum column widith.</para>

<warning>
  <para>If you set a non-zero value for this parameter, check your
  man-page output carefuly afterwards, in order to make sure that the
  setting has not introduced an excessive amount of breaking-up of URLs
  or pathnames. If your content contains mostly short URLs or
  pathnames, setting a non-zero value for
  <parameter>man.break.after.slash</parameter> will probably result in
  in a significant number of relatively short URLs and pathnames being
  broken across lines, which is probably not what you want.</para>
</warning>

</refsect1>
</doc:refentry>
<xsl:param name="man.break.after.slash">0</xsl:param>

<doc:refentry><refnamediv>
<refname>man.indent.width</refname>
<refpurpose>Specifies width used for adjusted indents</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>
<para>The <parameter>man.indent.width</parameter> parameter specifies
the width used for adjusted indents. The value of
<parameter>man.indent.width</parameter> is used for indenting of
lists, verbatims, headings, and elsewhere, depending on whether the
values of certain <literal>man.indent.*</literal> boolean parameters
are non-zero.</para>

<para>The value of <parameter>man.indent.width</parameter> should
include a valid roff measurement unit (for example,
<literal>n</literal> or <literal>u</literal>). The default value of
<literal>3n</literal> specifies a 3-en width; when viewed on a
console, that amounts to the width of three characters. For details
about roff measurment units, see the <literal>Measurements</literal>
node in the groff info page.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.indent.width">3n</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.indent.refsect</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.indent.refsect</refname>
<refpurpose>Adjust indentation of refsect* and refsection?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.indent.refsect</parameter> is
non-zero, the width of the left margin for
<sgmltag>refsect1</sgmltag>, <sgmltag>refsect2</sgmltag> and
<sgmltag>refsect3</sgmltag> contents and titles (and first-level,
second-level, and third-level nested
<sgmltag>refsection</sgmltag>instances) is adjusted by the value of
the <parameter>man.indent.width</parameter> parameter. With
<parameter>man.indent.width</parameter> set to its default value of
<literal>3n</literal>, the main results are that:

<itemizedlist>
  <listitem>
    <para>contents of <sgmltag>refsect1</sgmltag> are output with a
    left margin of three characters instead the roff default of seven
    or eight characters</para>
  </listitem>
  <listitem>
    <para>contents of <sgmltag>refsect2</sgmltag> are displayed in
    console output with a left margin of six characters instead the of
    the roff default of seven characters</para>
  </listitem>
  <listitem>
    <para> the contents of <sgmltag>refsect3</sgmltag> and nested
    <sgmltag>refsection</sgmltag> instances are adjusted
    accordingly.</para>
  </listitem>
</itemizedlist>

If instead the value of <parameter>man.indent.refsect</parameter> is
zero, no margin adjustment is done for <literal>refsect*</literal>
output.</para>

<tip>
  <para>If your content is primarly comprised of
  <sgmltag>refsect1</sgmltag> and <sgmltag>refsect2</sgmltag> content
  (or the <sgmltag>refsection</sgmltag> equivalent) – with few or
  no <sgmltag>refsect3</sgmltag> or lower nested sections , you may be
  able to “conserve” space in your output by setting
  <parameter>man.indent.refsect</parameter> to a non-zero value. Doing
  so will “squeeze” the left margin in such as way as to provide an
  additional four characters of “room” per line in
  <sgmltag>refsect1</sgmltag> output. That extra room may be useful
  if, for example, you have many verbatim sections with long lines in
  them.</para>
</tip>

</refsect1>
</doc:refentry>
<xsl:param name="man.indent.refsect" select="0"/>

<doc:refentry><refmeta>
<refentrytitle>man.indent.blurbs</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.indent.blurbs</refname>
<refpurpose>Adjust indentation of blurbs?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.indent.blurbs</parameter> is
non-zero, the width of the left margin for
<sgmltag>authorblurb</sgmltag>, <sgmltag>personblurb</sgmltag>, and
<sgmltag>contrib</sgmltag> output is set to the value of the
<parameter>man.indent.width</parameter> parameter
(<literal>3n</literal> by default). If instead the value of
<parameter>man.indent.blurbs</parameter> is zero, the built-in roff
default width (<literal>7.2n</literal>) is used.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.indent.blurbs" select="1"/>

<doc:refentry><refmeta>
<refentrytitle>man.indent.lists</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.indent.lists</refname>
<refpurpose>Adjust indentation of lists?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.indent.lists</parameter> is
non-zero, the width of the left margin for list items in
<sgmltag>itemizedlist</sgmltag>,
<sgmltag>orderedlist</sgmltag>,
<sgmltag>variablelist</sgmltag> output (and output of some other
lists) is set to the value of the
<parameter>man.indent.width</parameter> parameter
(<literal>3n</literal> by default). If instead the value of
<parameter>man.indent.lists</parameter> is zero, the built-in roff
default width (<literal>7.2n</literal>) is used.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.indent.lists" select="1"/>

<doc:refentry><refmeta>
<refentrytitle>man.indent.verbatims</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.indent.verbatims</refname>
<refpurpose>Adjust indentation of verbatims?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.indent.verbatims</parameter> is
non-zero, the width of the left margin for output of verbatim
environments (<sgmltag>programlisting</sgmltag>,
<sgmltag>screen</sgmltag>, and so on) is set to the value of the
<parameter>man.indent.width</parameter> parameter
(<literal>3n</literal> by default). If instead the value of
<parameter>man.indent.verbatims</parameter> is zero, the built-in roff
default width (<literal>7.2n</literal>) is used.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.indent.verbatims" select="1"/>

<doc:refentry><refmeta>
<refentrytitle>man.font.funcprototype</refentrytitle>

</refmeta><refnamediv>
<refname>man.font.funcprototype</refname>
<refpurpose>Specifies font for funcprototype output</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.font.funcprototype</parameter> parameter
specifies the font for <sgmltag>funcprototype</sgmltag> output. It
should be a valid roff font name, such as <literal>BI</literal> or
<literal>B</literal>.</para>

</refsect1>
</doc:refentry>
  <xsl:param name="man.font.funcprototype">BI</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.font.funcsynopsisinfo</refentrytitle>

</refmeta><refnamediv>
<refname>man.font.funcsynopsisinfo</refname>
<refpurpose>Specifies font for funcsynopsisinfo output</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.font.funcsynopsisinfo</parameter> parameter
specifies the font for <sgmltag>funcsynopsisinfo</sgmltag> output. It
should be a valid roff font name, such as <literal>B</literal> or
<literal>I</literal>.</para>

</refsect1>
</doc:refentry>
  <xsl:param name="man.font.funcsynopsisinfo">B</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.font.table.headings</refentrytitle>

</refmeta><refnamediv>
<refname>man.font.table.headings</refname>
<refpurpose>Specifies font for table headings</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.font.table.headings</parameter> parameter
specifies the font for <sgmltag>table</sgmltag> headings. It should be
a valid roff font, such as <literal>B</literal> or
<literal>I</literal>.</para>

</refsect1>
</doc:refentry>
  <xsl:param name="man.font.table.headings">B</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.font.table.title</refentrytitle>

</refmeta><refnamediv>
<refname>man.font.table.title</refname>
<refpurpose>Specifies font for table headings</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.font.table.title</parameter> parameter
specifies the font for <sgmltag>table</sgmltag> titles. It should be
a valid roff font, such as <literal>B</literal> or
<literal>I</literal>.</para>

</refsect1>
</doc:refentry>
  <xsl:param name="man.font.table.title">B</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.links.are.numbered</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.links.are.numbered</refname>
<refpurpose>Number links?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.links.are.numbered</parameter> is
non-zero (the default), then for each non-empty<footnote>
<para>A <quote>non-empty</quote> link is one that looks like
this:<literallayout class="monospaced">  &lt;ulink url="http://docbook.sf.net/snapshot/xsl/doc/manpages/"&gt;manpages&lt;/ulink&gt;</literallayout>
an <quote>empty link</quote> is on that looks like this:<literallayout class="monospaced">  &lt;ulink url="http://docbook.sf.net/snapshot/xsl/doc/manpages/"/&gt;</literallayout>
</para></footnote> link:

<itemizedlist>
  <listitem>
    <para>a number (in square brackets) is displayed inline before the
    rendered contents of the link</para>
  </listitem>
  <listitem>
    <para>the URL for the link is included in a numbered list of links
    that is generated at the end of each man page; the number for each
    links corresponds to the inline number for the link with which it is
    associated</para>
  </listitem>
</itemizedlist>
The default heading for the list of links is
<literal>REFERENCES</literal>. To output a different heading, set a value
for the <parameter>man.links.section.heading</parameter>
parameter.</para>

<note>
  <para>The link list is also displayed (but without numbers) if the
  value of <parameter>man.links.list.enabled</parameter> is
  non-zero.</para>
</note>


<para>If the value of <parameter>man.links.are.numbered</parameter> is
zero, numbering of links is suppressed; only the link contents are
displayed inline.
<important>
  <para>If you are thinking about disabling link numbering by setting
  the value of <parameter>man.links.are.numbered</parameter> to zero,
  before you do so, first take some time to carefully
  consider the information needs and experiences of your users. The
  square-bracketed numbers displayed inline before links may seem
  obstrusive and aesthetically unpleasing<footnote><para>You might
  think that it would be better to just display URLs for non-empty
  links inline, after their content, rather than displaying
  square-bracketed numbers all over the place. But it's not better. In
  fact, it's not even practical, because many (most) URLs for links
  are too long to be displayed inline. They end up overflowing the
  right margin. You can set a non-zero value for
  <parameter>man.break.after.slash</parameter> parameter to deal with
  that, but it could be argued that what you end up with is at least
  as ugly, and definitely more obstrusive, then having short
  square-bracketed numbers displayed inline.</para></footnote>,
   
  but in a text-only output format, the numbered-links/link-listing
  mechanism is the only practical way of associating inline text with
  URLs.</para>

  <para>Also, users of <quote>text based</quote> browsers such as
  <command>lynx</command> will already be accustomed to seeing inline
  numbers for links. And various "man to html" applications, such as
  the widely used <command><ulink url="http://users.actrix.gen.nz/michael/vhman2html.html">man2html</ulink></command> (<literal>VH-Man2html</literal>)
  application, can automatically turn URLs into "real" HTML hyperlinks
  in output. So leaving <parameter>man.links.are.numbered</parameter>
  at its default (non-zero) value ensures that no link information is
  lost in your man-page output. It just gets
  <quote>rearranged</quote>.</para>
</important>
</para>
<para>The handling of empty links is not affected by this
parameter. Empty links are handled simply by displaying their URLs
inline. Empty links are never auto-numbered.</para>
<note>
  <para>Currently, this parameter only affects output for
  <tag>ulink</tag>s.</para>
</note>

<para>If you disable link numbering, you should probably also set
<parameter>man.links.are.underlined</parameter> to zero (to disable
link underlining).</para>
</refsect1>
</doc:refentry>
<xsl:param name="man.links.are.numbered">1</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.links.are.underlined</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.links.are.underlined</refname>
<refpurpose>Underline links?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.links.are.underlined</parameter>
is non-zero (the default), then the contents of links are rendered
with an underline.</para>

<para>If the value of <parameter>man.links.are.underlined</parameter>
is zero, links are displayed without any underlining.</para>

<note>
  <para>Currently, this parameter only affects output for
  <tag>ulink</tag>s.</para>
</note>

<para>If you set <parameter>man.links.are.numbered</parameter> and/or
<parameter>man.links.list.enabled</parameter> to zero (disabled), then
you should probably also set
<parameter>man.links.are.underlined</parameter> to zero. But if
<parameter>man.links.are.numbered</parameter> is non-zero (enabled),
you should probably set a non-zero value for
<parameter>man.links.are.underlined</parameter> also<footnote><para>If the main purpose of underlining of links in most output
formats it to indicate that the underlined text is
<quote>clickable</quote>, given that links rendered in man pages are
not <quote>real</quote> hyperlinks that users can click on, it might
seem like there is never a good reason to have link contents
underlined in man output.</para> <para>In fact, if you suppress the
display of inline link references (by setting
<parameter>man.links.are.numbered</parameter> to zero), there is no
good reason to have links underlined. However, if
<parameter>man.links.are.numbered</parameter> is non-zero, having
links underlined may (arguably) serve a purpose: It provides
<quote>context</quote> information about exactly what part of the text
is being <quote>annotated</quote> by the link. Depending on how you
use mark up your content, that context information may or may not have
value.</para></footnote>.</para>
</refsect1>
</doc:refentry>
<xsl:param name="man.links.are.underlined">1</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.links.list.enabled</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.links.list.enabled</refname>
<refpurpose>Display list of links at end of man page?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.links.list.enabled</parameter> is
non-zero (the default), then a list of links is added to the end of
the output man page.</para>

<para>If the value of <parameter>man.links.list.enabled</parameter> is
zero, the list is suppressed -- unless link numbering is enabled (that
is, if <parameter>man.links.are.numbered</parameter> is non-zero), in
which case, that setting overrides the
<parameter>man.links.list.enabled</parameter> setting, and the link
list is still displayed. The reason is that link numbering only makes
sense if a (numbered) list of links is also generated.</para>

<note>
  <para>Various <quote>man to html</quote> applications, such as the
  widely used <command><ulink url="http://users.actrix.gen.nz/michael/vhman2html.html">man2html</ulink></command> (<literal>VH-Man2html</literal>)
  application, can automatically turn URLs into <quote>real</quote>
  HTML hyperlinks in output. So leaving
  <parameter>man.links.list.enabled</parameter> at its default
  (non-zero) value ensures that no link URLs are lost in your man-page
  output. They just get <quote>rearranged</quote>. So if you are
  thinking about disabling link listing by setting the value of
  <parameter>man.links.list.enabled</parameter> to zero, before you do
  so, first take some time to carefully consider the information needs
  and experiences of your users. The URLs are useful information even
  if they aren't <quote>real</quote> (clickable) hyperlinks.</para>
</note>

<para>To <quote>turn off</quote> numbering of links in the list, set
<parameter>man.links.are.numbered</parameter> to zero. The list will
still be displayed; it will just be displayed without the
numbers<footnote><para>It can still <quote>make sense</quote> to have
the list of links displayed even if you have link numbering turned
off. In that case, your list of links basically becomes a <quote>list
of references</quote> without any association with specific text in
your document. This is probably the best option if you find the inline
link numbering obtrusive. Your users will still have access to the
URLs and link contents, without being annoyed by the presence of
inline link numbering.</para></footnote>
</para>

<para>The default heading for the section in which the list appears is
<literal>REFERENCES</literal>. To change that, set a non-empty value
for the <parameter>man.links.list.heading</parameter>
parameter.</para>

<para>Along with the URL for each link, the link list includes the contents
of the link. The list thus includes only non-empty<footnote>

<para>A <quote>non-empty</quote> link is one that looks like
this:<literallayout class="monospaced">  &lt;ulink url="http://docbook.sf.net/snapshot/xsl/doc/manpages/"&gt;manpages&lt;/ulink&gt;</literallayout>
an <quote>empty link</quote> is on that looks like this:<literallayout class="monospaced">  &lt;ulink url="http://docbook.sf.net/snapshot/xsl/doc/manpages/"/&gt;</literallayout>
</para></footnote> links.

Empty links are never included, and never numbered. They are simply
displayed inline, without any numbering.</para>

<para>In addition, if there are multiple instances of links in a
<tag>refentry</tag> that have the same URL, the URL is listed only
once. The contents listed for that link are the contents of the first
link which has that URL.</para>

<note>
  <para>Currently, this parameter only affects output for
  <tag>ulink</tag>s.</para>
</note>

<para>If you disable link listing, you should probably also set
<parameter>man.links.are.underlined</parameter> to zero (to disable
link underlining).</para>
</refsect1>
</doc:refentry>
<xsl:param name="man.links.list.enabled">1</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.links.list.heading</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.links.list.heading</refname>
<refpurpose>Specifies an alternate name for links list</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of the
<parameter>man.links.are.numbered</parameter> parameter and/or the
<parameter>man.links.list.enabled</parameter> parameter is non-zero
(the defaults for both are non-zero), a numbered list of URLs is
generated near the end of each man page. The default section heading
for the list of links is the equivalent of the English word
<literal>REFERENCES</literal> in the current locale. To cause an
alternate heading to be displayed, set a non-empty value for the
<parameter>man.links.list.heading</parameter> parameter -- for
example, <literal>LINKS</literal>.</para>
</refsect1>
</doc:refentry>
<xsl:param name="man.links.list.heading" select="''"/>

<doc:refentry><refmeta>
<refentrytitle>man.segtitle.suppress</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.segtitle.suppress</refname>
<refpurpose>Suppress display of segtitle contents?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.segtitle.suppress</parameter> is
non-zero, then display of <sgmltag>segtitle</sgmltag> contents is
suppressed in output.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.segtitle.suppress" select="0"/>

<doc:refentry><refmeta>
<refentrytitle>variablelist.term.separator</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>variablelist.term.separator</refname>
<refpurpose>Text to separate <tag>term</tag>s within a multi-term
<tag>varlistentry</tag></refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>When a <tag>varlistentry</tag> contains multiple <tag>term</tag>
elements, the string specified in the value of the
<parameter>variablelist.term.separator</parameter> parameter is placed
after each <tag>term</tag> except the last.</para>

<note>
  <para>To generate a line break between multiple <tag>term</tag>s in
  a <tag>varlistentry</tag>, set a non-zero value for the
  <parameter>variablelist.term.break.after</parameter> parameter. If
  you do so, you may also want to set the value of the
  <parameter>variablelist.term.separator</parameter> parameter to an
  empty string (to suppress rendering of the default comma and space
  after each <tag>term</tag>).</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="variablelist.term.separator">, </xsl:param>

<doc:refentry><refmeta>
<refentrytitle>variablelist.term.break.after</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>variablelist.term.break.after</refname>
<refpurpose>Generate line break after each <tag>term</tag> within a
multi-term <tag>varlistentry</tag>?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>Set a non-zero value for the
<parameter>variablelist.term.break.after</parameter> parameter to
generate a line break between <tag>term</tag>s in a
multi-term <tag>varlistentry</tag>.</para>

<note>
<para>If you set a non-zero value for
<parameter>variablelist.term.break.after</parameter>, you may also
want to set the value of the
<parameter>variablelist.term.separator</parameter> parameter to an
empty string (to suppress rendering of the default comma and space
after each <tag>term</tag>).</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="variablelist.term.break.after">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.charmap.enabled</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.charmap.enabled</refname>
<refpurpose>Apply character map before final output?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of the <parameter>man.charmap.enabled</parameter>
parameter is non-zero, a "character map" is used to substitute certain
Unicode symbols and special characters with appropriate roff/groff
equivalents, just before writing each man-page file to the
filesystem. If instead the value of
<parameter>man.charmap.enabled</parameter> is zero, Unicode characters
are passed through "as is".</para>

<refsect2>
<title>Details</title>
<para>For converting certain Unicode symbols and special characters in
UTF-8 or UTF-16 encoded XML source to appropriate groff/roff
equivalents in man-page output, the DocBook XSL Stylesheets
distribution includes a <ulink url="http://docbook.sourceforge.net/snapshot/xsl/manpages/charmap.groff.xsl">roff character map</ulink> that is compliant with the <ulink url="http://www.w3.org/TR/xslt20/#character-maps">XSLT character
map</ulink> format as detailed in the XSLT 2.0 specification. The map
contains more than 800 character mappings and can be considered the
standard roff character map for the distribution.</para>

<para>You can use the <parameter>man.charmap.uri</parameter>
parameter to specify a URI for the location for an alternate roff
character map to use in place of the standard roff character map
provided in the distribution.</para>

<para>You can also use a subset of a character map. For details, see
the <parameter>man.charmap.use.subset</parameter> and
<parameter>man.charmap.subset.profile</parameter> parameters.</para>

</refsect2>
</refsect1>
</doc:refentry>
<xsl:param name="man.charmap.enabled" select="1"/>

<doc:refentry><refmeta>
<refentrytitle>man.charmap.uri</refentrytitle>
<refmiscinfo role="type">uri</refmiscinfo>
</refmeta><refnamediv>
<refname>man.charmap.uri</refname>
<refpurpose>URI for custom roff character map</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>For converting certain Unicode symbols and special characters in
UTF-8 or UTF-16 encoded XML source to appropriate groff/roff
equivalents in man-page output, the DocBook XSL Stylesheets
distribution includes an <ulink url="http://www.w3.org/TR/xslt20/#character-maps">XSLT character
map</ulink>. That character map can be considered the standard roff
character map for the distribution.</para>

<para>If the value of the <parameter>man.charmap.uri</parameter>
parameter is non-empty, that value is used as the URI for the location
for an alternate roff character map to use in place of the standard
roff character map provided in the distribution.</para>

<warning>
<para>Do not set a value for <parameter>man.charmap.uri</parameter>
unless you have a custom roff character map that differs from the
standard one provided in the distribution.</para>
</warning>
</refsect1>
</doc:refentry>
<xsl:param name="man.charmap.uri" select="''"/>

<doc:refentry><refmeta>
<refentrytitle>man.charmap.use.subset</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.charmap.use.subset</refname>
<refpurpose>Use subset of character map instead of full map?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of the
<parameter>man.charmap.use.subset</parameter> parameter is non-zero,
a subset of the roff character map is used instead of the full roff
character map. The profile of the subset used is specified by the
<parameter>man.charmap.subset.profile</parameter> parameter.</para>

<note>
  <para>You may want to experiment with setting a non-zero value of
  <parameter>man.charmap.use.subset</parameter>, so that the full
  character map is used. Depending on which XSLT engine you run,
  setting a non-zero value for
  <parameter>man.charmap.use.subset</parameter> may significantly
  increase the time needed to process your documents. Or it may
  not. For example, if you set it and run it with xsltproc, it seems
  to dramatically increase processing time; on the other hand, if you
  set it and run it with Saxon, it does not seem to increase
  processing time nearly as much.</para>

  <para>If processing time is not a important concern and/or you can
  tolerate the increase in processing time imposed by using the full
  character map, set <parameter>man.charmap.use.subset</parameter> to
  zero.</para>
</note>

<refsect2>
<title>Details</title>
<para>For converting certain Unicode symbols and special characters in
UTF-8 or UTF-16 encoded XML source to appropriate groff/roff
equivalents in man-page output, the DocBook XSL Stylesheets
distribution includes a <ulink url="http://docbook.sourceforge.net/snapshot/xsl/manpages/charmap.groff.xsl">roff character map</ulink> that is compliant with the <ulink url="http://www.w3.org/TR/xslt20/#character-maps">XSLT character
map</ulink> format as detailed in the XSLT 2.0 specification. The map
contains more than 800 character mappings and can be considered the
standard roff character map for the distribution.</para>

<note>
<para>You can use the <parameter>man.charmap.uri</parameter>
parameter to specify a URI for the location for an alternate roff
character map to use in place of the standard roff character map
provided in the distribution.</para>
</note>

<para>Because it is not terrifically efficient to use the standard
800-character character map in full -- and for most (or all) users,
never necessary to use it in full -- the DocBook XSL Stylesheets
support a mechanism for using, within any given character map, a
subset of character mappings instead of the full set. You can use the
<parameter>man.charmap.subset.profile</parameter> parameter to tune
the profile of that subset to use.</para>

</refsect2>
</refsect1>
</doc:refentry>
<xsl:param name="man.charmap.use.subset" select="1"/>

<doc:refentry><refmeta>
<refentrytitle>man.charmap.subset.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.charmap.subset.profile</refname>
<refpurpose>Profile of character map subset</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of the
<parameter>man.charmap.use.subset</parameter> parameter is non-zero,
The character-map subset specified by the
<parameter>man.charmap.subset.profile</parameter> parameter is used
instead of the full roff character map.</para>

<para>The value of <parameter>man.charmap.subset.profile</parameter>
is a string representating an XPath expression that matches attribute
names and values for <tag namespace="http://docbook.sf.net/xmlns/unichar/1.0">output-character</tag> elements in the character map.</para>

<para>The attributes supported in the <ulink url="http://docbook.sourceforge.net/snapshot/xsl/manpages/charmap.groff.xsl">standard roff character map included in the distribution</ulink> are:
<variablelist>
  <varlistentry>
    <term>character</term>
    <listitem>
      <simpara>a raw Unicode character or numeric Unicode
      character-entity value (either in decimal or hex); all
      characters have this attribute</simpara>
    </listitem>
  </varlistentry>
  <varlistentry>
    <term>name</term>
    <listitem>
      <simpara>a standard full/long ISO/Unicode character name (e.g.,
      "OHM SIGN"); all characters have this attribute</simpara>
    </listitem>
  </varlistentry>
  <varlistentry>
    <term>block</term>
    <listitem>
      <simpara>a standard Unicode "block" name (e.g., "General
      Punctuation"); all characters have this attribute. For the full
      list of Unicode block names supported in the standard roff
      character map, see <xref linkend="BlocksAndClasses"/>.</simpara>
    </listitem>
  </varlistentry>
  <varlistentry>
    <term>class</term>
    <listitem>
      <simpara>a class of characters (e.g., "spaces"). Not all
      characters have this attribute; currently, it is used only with
      certain characters within the "C1 Controls And Latin-1
      Supplement" and "General Punctuation" blocks. For details, see
      <xref linkend="BlocksAndClasses"/>.</simpara>
    </listitem>
  </varlistentry>
  <varlistentry>
    <term>entity</term>
    <listitem>
      <simpara>an ISO entity name (e.g., "ohm"); not all characters
      have this attribute, because not all characters have ISO entity
      names; for example, of the 800 or so characters in the standard
      roff character map included in the distribution, only around 300
      have ISO entity names.
      </simpara>
    </listitem>
  </varlistentry>
  <varlistentry>
    <term>string</term>
    <listitem>
      <simpara>a string representating an roff/groff escape-code (with
      "@esc@" used in place of the backslash), or a simple ASCII
      string; all characters in the roff character map have this
      attribute</simpara>
    </listitem>
  </varlistentry>
</variablelist>
</para>
<para>The value of <parameter>man.charmap.subset.profile</parameter>
is evaluated as an XPath expression at run-time to select a portion of
the roff character map to use. You can tune the subset used by adding
or removing parts. For example, if you need to use a wide range of
mathematical operators in a document, and you want to have them
converted into roff markup properly, you might add the following:

<literallayout class="monospaced">  @*[local-name() = 'block'] ='MathematicalOperators' </literallayout>

That will cause a additional set of around 67 additional "math"
characters to be converted into roff markup. </para>

<note>
<para>Depending on which XSLT engine you use, either the EXSLT
<function>dyn:evaluate</function> extension function (for xsltproc or
Xalan) or <function>saxon:evaluate</function> extensio function (for
Saxon) are used to dynamically evaluate the value of
<parameter>man.charmap.subset.profile</parameter> at run-time. If you
don't use xsltproc, Saxon, Xalan -- or some other XSLT engine that
supports <function>dyn:evaluate</function> -- you must either set the
value of the <parameter>man.charmap.use.subset</parameter> parameter
to zero and process your documents using the full character map
instead, or set the value of the
<parameter>man.charmap.enabled</parameter> parameter to zero instead
(so that character-map processing is disabled completely.</para>
</note>

<para>An alternative to using
<parameter>man.charmap.subset.profile</parameter> is to create your
own custom character map, and set the value of
<parameter>man.charmap.uri</parameter> to the URI/filename for
that. If you use a custom character map, you will probably want to
include in it just the characters you want to use, and so you will
most likely also want to set the value of
<parameter>man.charmap.use.subset</parameter> to zero.</para>
<para>You can create a
custom character map by making a copy of the <ulink url="http://docbook.sourceforge.net/snapshot/xsl/manpages/charmap.groff.xsl">standard roff character map</ulink> provided in the distribution, and
then adding to, changing, and/or deleting from that.</para>

<caution>
<para>If you author your DocBook XML source in UTF-8 or UTF-16
encoding and aren't sure what OSes or environments your man-page
output might end up being viewed on, and not sure what version of
nroff/groff those environments might have, you should be careful about
what Unicode symbols and special characters you use in your source and
what parts you add to the value of
<parameter>man.charmap.subset.profile</parameter>.</para>
<para>Many of the escape codes used are specific to groff and using
them may not provide the expected output on an OS or environment that
uses nroff instead of groff.</para>
<para>On the other hand, if you intend for your man-page output to be
viewed only on modern systems (for example, GNU/Linux systems, FreeBSD
systems, or Cygwin environments) that have a good, up-to-date groff,
then you can safely include a wide range of Unicode symbols and
special characters in your UTF-8 or UTF-16 encoded DocBook XML source
and add any of the supported Unicode block names to the value of
<parameter>man.charmap.subset.profile</parameter>.</para>
</caution>


<para>For other details, see the documentation for the
<parameter>man.charmap.use.subset</parameter> parameter.</para>

<refsect2 id="BlocksAndClasses">
  <title>Supported Unicode block names and "class" values</title>

  <para>Below is the full list of Unicode block names and "class"
  values supported in the standard roff stylesheet provided in the
  distribution, along with a description of which codepoints from the
  Unicode range corresponding to that block name or block/class
  combination are supported.</para>

  <itemizedlist>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=C1%20Controls%20and%20Latin-1%20Supplement%20(Latin-1%20Supplement)">C1 Controls And Latin-1 Supplement (Latin-1 Supplement)</ulink> (x00a0 to x00ff)
      <itemizedlist>
        <title>class values</title>
        <listitem>
          <para>symbols</para>
        </listitem>
        <listitem>
          <para>letters</para>
        </listitem>
      </itemizedlist></para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Latin%20Extended-A">Latin Extended-A</ulink> (x0100 to x017f, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Spacing%20Modifier%20Letters">Spacing Modifier Letters</ulink> (x02b0 to x02ee, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Greek%20and%20Coptic">Greek and Coptic</ulink> (x0370 to x03ff, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=General%20Punctuation">General Punctuation</ulink> (x2000 to x206f, partial)
      <itemizedlist>
        <title>class values</title>
        <listitem>
          <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;start=8192&amp;end=8203">spaces</ulink></para>
        </listitem>
        <listitem>
          <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;start=8208&amp;end=8213">dashes</ulink></para>
        </listitem>
        <listitem>
          <para>quotes</para>
        </listitem>
        <listitem>
          <para>daggers</para>
        </listitem>
        <listitem>
          <para>bullets</para>
        </listitem>
        <listitem>
          <para>leaders</para>
        </listitem>
        <listitem>
          <para>primes</para>
        </listitem>
      </itemizedlist>
      </para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Superscripts%20and%20Subscripts">Superscripts and Subscripts</ulink> (x2070 to x209f)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Currency%20Symbols">Currency Symbols</ulink> (x20a0 to x20b1)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Letterlike%20Symbols">Letterlike Symbols</ulink> (x2100 to x214b)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Number%20Forms">Number Forms</ulink> (x2150 to x218f)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Arrows">Arrows</ulink> (x2190 to x21ff, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Mathematical%20Operators">Mathematical Operators</ulink> (x2200 to x22ff, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Control%20Pictures">Control Pictures</ulink> (x2400 to x243f)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Enclosed%20Alphanumerics">Enclosed Alphanumerics</ulink> (x2460 to x24ff)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Geometric%20Shapes">Geometric Shapes</ulink> (x25a0 to x25f7, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Miscellaneous%20Symbols">Miscellaneous Symbols</ulink> (x2600 to x26ff, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Dingbats">Dingbats</ulink> (x2700 to x27be, partial)</para>
    </listitem>
    <listitem>
      <para><ulink url="http://zvon.org/other/charSearch/PHP/search.php?searchType=103&amp;id=Alphabetic%20Presentation%20Forms">Alphabetic Presentation Forms</ulink> (xfb00 to xfb04 only)</para>
    </listitem>
  </itemizedlist>
</refsect2>
</refsect1>
</doc:refentry>
<xsl:param name="man.charmap.subset.profile">
@*[local-name() = 'block'] = 'Miscellaneous Technical' or
(@*[local-name() = 'block'] = 'C1 Controls And Latin-1 Supplement (Latin-1 Supplement)' and
 @*[local-name() = 'class'] = 'symbols'
) or
(@*[local-name() = 'block'] = 'General Punctuation' and
 (@*[local-name() = 'class'] = 'spaces' or
  @*[local-name() = 'class'] = 'dashes' or
  @*[local-name() = 'class'] = 'quotes' or
  @*[local-name() = 'class'] = 'bullets'
 )
) or
@*[local-name() = 'name'] = 'HORIZONTAL ELLIPSIS' or
@*[local-name() = 'name'] = 'WORD JOINER' or
@*[local-name() = 'name'] = 'SERVICE MARK' or
@*[local-name() = 'name'] = 'TRADE MARK SIGN' or
@*[local-name() = 'name'] = 'ZERO WIDTH NO-BREAK SPACE'
</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.string.subst.map</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.string.subst.map</refname>
<refpurpose>Specifies a set of string substitutions</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.string.subst.map</parameter> parameter
contains <link linkend="map">a map</link> that specifies a set of
string substitutions to perform over the entire roff source for each
man page, either just before generating final man-page output (that
is, before writing man-page files to disk) or, if the value of the
<parameter>man.charmap.enabled</parameter> parameter is non-zero,
before applying the roff character map.</para>

<para>You can use <parameter>man.string.subst.map</parameter> as a
"lightweight" character map to perform "essential" substitutions --
that is, substitutions that are <emphasis>always</emphasis> performed,
even if the value of the <parameter>man.charmap.enabled</parameter>
parameter is zero. For example, you can use it to replace quotation
marks or other special characters that are generated by the DocBook
XSL stylesheets for a particular locale setting (as opposed to those
characters that are actually in source XML documents), or to replace
any special characters that may be automatically generated by a
particular customization of the DocBook XSL stylesheets.</para>

<warning>
  <para>Do you not change value of the
  <parameter>man.string.subst.map</parameter> parameter unless
  you are sure what you are doing. If you remove any of the default
  mappings, you are likely to end up with broken output. And be very
  careful about adding anything to it. Because it is used for doing
  string substitution over the entire roff source of each man page, it
  causes target strings to be replaced in roff requests and escapes,
  not just in the visible contents.</para>

  <para>In particular, do not attempt to add a mapping for the
  dot/period character. Doing so will break your output. For an
  explanation, see <xref linkend="Dots"/>.</para>

</warning>

<refsect2 id="map">
  <title>Contents of the substitution map</title>
  <para>The string-substitution map contains one or more <tag namespace="http://docbook.sf.net/xmlns/string.subst/1.0">substitution</tag> elements, each of which has two attributes:
  <variablelist>
    <varlistentry>
      <term>oldstring</term>
      <listitem>
        <simpara>string to replace</simpara>
      </listitem>
    </varlistentry>
    <varlistentry>
      <term>newstring</term>
      <listitem>
        <simpara>string with which to replace <tag class="attribute">oldstring</tag></simpara>
      </listitem>
    </varlistentry>
  </variablelist>
  It may also include XML comments (that is, delimited with
  "<literal>&lt;!--</literal>" and "<literal>--&gt;</literal>").
  </para>
</refsect2>

<refsect2 id="Dots">
  <title>About adding backslashes before dots</title>
  <para>The stylesheets do not add backslashes before
  periods/dots. One reason is that, because string substitution is
  performed over the entire roff source of each man page, it would be
  complicated to replace dots in visible contents without also causing
  them to be replaced in roff requests and escapes; for example,
  without causing, say, the <literal>.TH</literal> roff macro to be
  replaced with <literal>\.TH</literal>. Additionally, backslashes in
  front of periods/dots are needed only in the very rare case where a
  period is the very first character in a line, without any space in
  front of it. A better way to deal with that rare case is to add a
  zero-width space in front of the offending dot(s) in your
  source.</para>
</refsect2>

</refsect1>
</doc:refentry>
<xsl:param name="man.string.subst.map">
  <substitution oldstring="\" newstring="\\"/>
  <!-- * now, we need to restore single-backslashes in all roff -->
  <!-- * requests (because the substitution above doubled them) -->
  <substitution oldstring="\\fB" newstring="\fB"/>
  <substitution oldstring="\\fI" newstring="\fI"/>
  <substitution oldstring="\\fR" newstring="\fR"/>
  <substitution oldstring="\\n" newstring="\n"/>
  <!-- * requests in .SH sectsions output from Refsect1-level source -->
  <!-- * end up getting capitalized... -->
  <substitution oldstring="\\FB" newstring="\fB"/>
  <substitution oldstring="\\FI" newstring="\fI"/>
  <substitution oldstring="\\FR" newstring="\fR"/>
  <substitution oldstring="\\%" newstring="\%"/>
  <substitution oldstring="\\&amp;" newstring="\&amp;"/>
  <substitution oldstring=".\\&#34;" newstring=".\&#34;"/>
  <!-- * although the groff docs do not make it clear, it appears that -->
  <!-- * the only way to get a non-breaking hyphen in roff is to put a -->
  <!-- * backslash in front of it; and, unfortunately, groff is not smart -->
  <!-- * about where it breaks things (for example, it'll break an -->
  <!-- * argument for a command across a line, if that argument contains -->
  <!-- * a dash/hyphen); so, we must globally change all hyphens to "\-" -->
  <substitution oldstring="-" newstring="\-"/>
  <!-- * now, we need to restore single-hypens in all roff requests -->
  <!-- * (because the substitution above added backslashes before them) -->
  <substitution oldstring=".sp \-" newstring=".sp -"/>
  <substitution oldstring=".it 1 an\-trap" newstring=".it 1 an-trap"/>
  <substitution oldstring=".nr an\-no\-space\-flag 1" newstring=".nr an-no-space-flag 1"/>
  <substitution oldstring=".nr an\-break\-flag 1" newstring=".nr an-break-flag 1"/>
  <substitution oldstring=".ll \-" newstring=".ll -"/>
  <!-- * squeeze multiple newlines before a roff request  -->
  <substitution oldstring="&#xA;&#xA;." newstring="&#xA;."/>
  <!-- * remove any .sp occurences that directly follow a .PP  -->
  <substitution oldstring=".PP&#xA;.sp" newstring=".PP"/>
  <!-- * squeeze multiple newlines after start of no-fill (verbatim) env. -->
  <substitution oldstring=".nf&#xA;&#xA;" newstring=".nf&#xA;"/>
  <!-- * squeeze multiple newlines after REstoring margin -->
  <substitution oldstring=".RE&#xA;&#xA;" newstring=".RE&#xA;"/>
  <!-- * an apostrophe at the beginning of a line gets interpreted as a -->
  <!-- * roff request (groff(7) says it is "the non-breaking control -->
  <!-- * character"); so we must add backslash before any apostrophe -->
  <!-- * found at the start of a line -->
  <substitution oldstring="&#xA;'" newstring="&#xA;\'"/>
  <!-- * -->
  <!-- * non-breaking space -->
  <!-- * -->
  <!-- * A no-break space can be written two ways in roff; the difference, -->
  <!-- * according to the "Page Motions" node in the groff info page, ixsl: -->
  <!-- * -->
  <!-- *   "\ " = -->
  <!-- *   An unbreakable and unpaddable (i.e. not expanded during filling) -->
  <!-- *   space. -->
  <!-- * -->
  <!-- *   "\~" = -->
  <!-- *   An unbreakable space that stretches like a normal -->
  <!-- *   inter-word space when a line is adjusted."  -->
  <!-- * -->
  <!-- * Unfortunately, roff seems to do some weird things with long -->
  <!-- * lines that only have words separated by "\~" spaces, so it's -->
  <!-- * safer just to stick with the "\ " space -->
  <substitution oldstring=" " newstring="\ "/>
  <!-- * x2008 is a "punctuation space"; we must replace it here because, -->
  <!-- * for certain reasons, the stylesheets add it before and after -->
  <!-- * every Parameter in Funcprototype output -->
  <substitution oldstring=" " newstring=" "/>
  <substitution oldstring="⌂" newstring="&#x9;"/>
  <!-- * -->
  <!-- * Now deal with some other characters that are added by the -->
  <!-- * stylesheets during processing. -->
  <!-- * -->
  <!-- * bullet -->
  <substitution oldstring="•" newstring="\(bu"/>
  <!-- * left double quote -->
  <substitution oldstring="“" newstring="\(lq"/>
  <!-- * right double quote -->
  <substitution oldstring="”" newstring="\(rq"/>
  <!-- * left single quote -->
  <substitution oldstring="‘" newstring="\(oq"/>
  <!-- * right single quote -->
  <substitution oldstring="’" newstring="\(cq"/>
  <!-- * copyright sign -->
  <substitution oldstring="©" newstring="\(co"/>
  <!-- * registered sign -->
  <substitution oldstring="®" newstring="\(rg"/>
  <!-- * servicemark... -->
  <!-- * There is no groff equivalent for it. -->
  <substitution oldstring="℠" newstring="(SM)"/>
  <!-- * trademark... -->
  <!-- * We don't do "\(tm" because for console output, -->
  <!-- * groff just renders that as "tm"; that is: -->
  <!-- * -->
  <!-- *   Product&#x2122; -> Producttm -->
  <!-- * -->
  <!-- * So we just make it to "(TM)" instead; thus: -->
  <!-- * -->
  <!-- *   Product&#x2122; -> Product(TM) -->
  <substitution oldstring="™" newstring="(TM)"/>
</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.meta.get.quietly</refentrytitle>

</refmeta><refnamediv>
<refname>refentry.meta.get.quietly</refname>
<refpurpose>Suppress notes and warnings when gathering refentry metadata?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If zero (the default), notes and warnings about “missing” markup
are generated during gathering of refentry metadata. If non-zero, the
metadata is gathered “quietly” -- that is, the notes and warnings are
suppressed.</para>

<tip>
  <para>If you are processing a large amount of <tag>refentry</tag>
  content, you may be able to speed up processing significantly by
  setting a non-zero value for
  <parameter>refentry.meta.get.quietly</parameter>.</para>
</tip>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.meta.get.quietly" select="0"/>

<doc:refentry><refmeta>
<refentrytitle>refentry.date.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.date.profile</refname>
<refpurpose>Specifies profile for refentry "date" data</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The value of <parameter>refentry.date.profile</parameter> is a
string representing an XPath expression. It is evaluated at run-time
and used only if <parameter>refentry.date.profile.enabled</parameter>
is non-zero. Otherwise, the <tag>refentry</tag> metadata-gathering
logic "hard coded" into the stylesheets is used.</para>

<para> The <literal>man(7)</literal> man page describes this content
as "the date of the last revision". In man pages, it is the content
that is usually displayed in the center footer.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.date.profile">
  (($info[//date])[last()]/date)[1]|
  (($info[//pubdate])[last()]/pubdate)[1]
</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.date.profile.enabled</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.date.profile.enabled</refname>
<refpurpose>Enable refentry "date" profiling?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of
<parameter>refentry.date.profile.enabled</parameter> is non-zero, then
during <tag>refentry</tag> metadata gathering, the info profile
specified by the customizable
<parameter>refentry.date.profile</parameter> parameter is used.</para>

<para>If instead the value of
<parameter>refentry.date.profile.enabled</parameter> is zero (the
default), then "hard coded" logic within the DocBook XSL stylesheets
is used for gathering <tag>refentry</tag> "date" data.</para>

<para>If you find that the default <tag>refentry</tag>
metadata-gathering behavior is causing incorrect "date" data to show
up in your output, then consider setting a non-zero value for
<parameter>refentry.date.profile.enabled</parameter> and adjusting the
value of <parameter>refentry.date.profile</parameter> to cause correct
data to be gathered. </para>

<para>Note that the terms "source" and "date" have special meanings in
this context. For details, see the documentation for the
<parameter>refentry.date.profile</parameter> parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.date.profile.enabled">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.manual.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.manual.profile</refname>
<refpurpose>Specifies profile for refentry "manual" data</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The value of <parameter>refentry.manual.profile</parameter> is
a string representing an XPath expression. It is evaluated at
run-time and used only if
<parameter>refentry.manual.profile.enabled</parameter> is
non-zero. Otherwise, the <tag>refentry</tag> metadata-gathering logic
"hard coded" into the stylesheets is used.</para>

<para>In man pages, this content is usually displayed in the middle of
the header of the page. The <literal>man(7)</literal> man page
describes this as "the title of the manual (e.g., <citetitle>Linux
Programmer's Manual</citetitle>)". Here are some examples from
existing man pages:
<itemizedlist>
  <listitem>
    <para><citetitle>dpkg utilities</citetitle>
    (<command>dpkg-name</command>)</para>
  </listitem>
  <listitem>
    <para><citetitle>User Contributed Perl Documentation</citetitle>
    (<command>GET</command>)</para>
  </listitem>
  <listitem>
    <para><citetitle>GNU Development Tools</citetitle>
    (<command>ld</command>)</para>
  </listitem>
  <listitem>
    <para><citetitle>Emperor Norton Utilities</citetitle>
    (<command>ddate</command>)</para>
  </listitem>
  <listitem>
    <para><citetitle>Debian GNU/Linux manual</citetitle>
    (<command>faked</command>)</para>
  </listitem>
  <listitem>
    <para><citetitle>GIMP Manual Pages</citetitle>
    (<command>gimp</command>)</para>
  </listitem>
  <listitem>
    <para><citetitle>KDOC Documentation System</citetitle>
    (<command>qt2kdoc</command>)</para>
  </listitem>
</itemizedlist>
</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.manual.profile">
  (($info[//title])[last()]/title)[1]|
  ../title/node()
</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.manual.profile.enabled</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.manual.profile.enabled</refname>
<refpurpose>Enable refentry "manual" profiling?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of
<parameter>refentry.manual.profile.enabled</parameter> is
non-zero, then during <tag>refentry</tag> metadata gathering, the info
profile specified by the customizable
<parameter>refentry.manual.profile</parameter> parameter is
used.</para>

<para>If instead the value of
<parameter>refentry.manual.profile.enabled</parameter> is zero (the
default), then "hard coded" logic within the DocBook XSL stylesheets
is used for gathering <tag>refentry</tag> "manual" data.</para>

<para>If you find that the default <tag>refentry</tag>
metadata-gathering behavior is causing incorrect "manual" data to show
up in your output, then consider setting a non-zero value for
<parameter>refentry.manual.profile.enabled</parameter> and adjusting
the value of <parameter>refentry.manual.profile</parameter> to cause
correct data to be gathered. </para>

<para>Note that the term "manual" has a special meanings in this
context. For details, see the documentation for the
<parameter>refentry.manual.profile</parameter> parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.manual.profile.enabled">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.source.name.suppress</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.source.name.suppress</refname>
<refpurpose>Suppress "name" part of refentry "source" contents?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of
<parameter>refentry.source.name.suppress</parameter> is non-zero, then
during <tag>refentry</tag> metadata gathering, no "source name" data
is added to the <tag>refentry</tag> "source" contents. Instead (unless
<parameter>refentry.version.suppress</parameter> is also non-zero),
only "version" data is added to the "source" contents.</para>

<para>If you find that the <tag>refentry</tag> metadata gathering
mechanism is causing unwanted "source name" data to show up in your
output -- for example, in the footer (or possibly header) of a man
page -- then you might consider setting a non-zero value for
<parameter>refentry.source.name.suppress</parameter>.</para>

<para>Note that the terms "source", "source name", and "version" have
special meanings in this context. For details, see the documentation
for the <parameter>refentry.source.name.profile</parameter>
parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.source.name.suppress">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.source.name.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.source.name.profile</refname>
<refpurpose>Specifies profile for refentry "source name" data</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The value of <parameter>refentry.source.name.profile</parameter>
is a string representing an XPath expression. It is evaluated at
run-time and used only if
<parameter>refentry.source.name.profile.enabled</parameter> is
non-zero. Otherwise, the <tag>refentry</tag> metadata-gathering logic
"hard coded" into the stylesheets is used.</para>

<para>A "source name" is one part of a (potentially) two-part
<replaceable>Name</replaceable> <replaceable>Version</replaceable>
"source" field. In man pages, it is usually displayed in the left
footer of the page. It typically indicates the software system or
product that the item documented in the man page belongs to. The
<literal>man(7)</literal> man page describes it as "the source of
the command", and provides the following examples:
<itemizedlist>
  <listitem>
    <para>For binaries, use something like: GNU, NET-2, SLS
    Distribution, MCC Distribution.</para>
  </listitem>
  <listitem>
    <para>For system calls, use the version of the kernel that you
    are currently looking at: Linux 0.99.11.</para>
  </listitem>
  <listitem>
    <para>For library calls, use the source of the function: GNU, BSD
    4.3, Linux DLL 4.4.1.</para>
  </listitem>
</itemizedlist>
</para>

<para>In practice, there are many pages that simply have a Version
number in the "source" field. So, it looks like what we have is a
two-part field,
<replaceable>Name</replaceable> <replaceable>Version</replaceable>,
where:
<variablelist>
  <varlistentry>
    <term>Name</term>
    <listitem>
      <para>product name (e.g., BSD) or org. name (e.g., GNU)</para>
    </listitem>
  </varlistentry>
  <varlistentry>
    <term>Version</term>
    <listitem>
      <para>version number</para>
    </listitem>
  </varlistentry>
</variablelist>
Each part is optional. If the <replaceable>Name</replaceable> is a
product name, then the <replaceable>Version</replaceable> is probably
the version of the product. Or there may be no
<replaceable>Name</replaceable>, in which case, if there is a
<replaceable>Version</replaceable>, it is probably the version
of the item itself, not the product it is part of. Or, if the
<replaceable>Name</replaceable> is an organization name, then there
probably will be no <replaceable>Version</replaceable>.</para>
</refsect1>
</doc:refentry>
<xsl:param name="refentry.source.name.profile">
  (($info[//productname])[last()]/productname)[1]|
  (($info[//corpname])[last()]/corpname)[1]|
  (($info[//corpcredit])[last()]/corpcredit)[1]|
  (($info[//corpauthor])[last()]/corpauthor)[1]|
  (($info[//orgname])[last()]/orgname)[1]|
  (($info[//publishername])[last()]/publishername)[1]
</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.source.name.profile.enabled</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.source.name.profile.enabled</refname>
<refpurpose>Enable refentry "source name" profiling?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of
<parameter>refentry.source.name.profile.enabled</parameter> is
non-zero, then during <tag>refentry</tag> metadata gathering, the info
profile specified by the customizable
<parameter>refentry.source.name.profile</parameter> parameter is
used.</para>

<para>If instead the value of
<parameter>refentry.source.name.profile.enabled</parameter> is zero (the
default), then "hard coded" logic within the DocBook XSL stylesheets
is used for gathering <tag>refentry</tag> "source name" data.</para>

<para>If you find that the default <tag>refentry</tag>
metadata-gathering behavior is causing incorrect "source name" data to
show up in your output, then consider setting a non-zero value for
<parameter>refentry.source.name.profile.enabled</parameter> and
adjusting the value of
<parameter>refentry.source.name.profile</parameter> to cause correct
data to be gathered. </para>

<para>Note that the terms "source" and "source name" have special
meanings in this context. For details, see the documentation for the
<parameter>refentry.source.name.profile</parameter> parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.source.name.profile.enabled">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.version.suppress</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.version.suppress</refname>
<refpurpose>Suppress "version" part of refentry "source" contents?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>refentry.version.suppress</parameter>
is non-zero, then during <tag>refentry</tag> metadata gathering, no
"version" data is added to the <tag>refentry</tag> "source"
contents. Instead (unless
<parameter>refentry.source.name.suppress</parameter> is also
non-zero), only "source name" data is added to the "source"
contents.</para>

<para>If you find that the <tag>refentry</tag> metadata gathering
mechanism is causing unwanted "version" data to show up in your output
-- for example, in the footer (or possibly header) of a man page --
then you might consider setting a non-zero value for
<parameter>refentry.version.suppress</parameter>.</para>

<para>Note that the terms "source", "source name", and "version" have
special meanings in this context. For details, see the documentation
for the <parameter>refentry.source.name.profile</parameter>
parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.version.suppress">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.version.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.version.profile</refname>
<refpurpose>Specifies profile for refentry "version" data</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The value of <parameter>refentry.version.profile</parameter> is
a string representing an XPath expression. It is evaluated at
run-time and used only if
<parameter>refentry.version.profile.enabled</parameter> is
non-zero. Otherwise, the <tag>refentry</tag> metadata-gathering logic
"hard coded" into the stylesheets is used.</para>

<para>A "source.name" is one part of a (potentially) two-part
<replaceable>Name</replaceable> <replaceable>Version</replaceable>
"source" field. For more details, see the documentation for the
<parameter>refentry.source.name.profile</parameter> parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.version.profile">
  (($info[//productnumber])[last()]/productnumber)[1]|
  (($info[//edition])[last()]/edition)[1]|
  (($info[//releaseinfo])[last()]/releaseinfo)[1]
</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.version.profile.enabled</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.version.profile.enabled</refname>
<refpurpose>Enable refentry "version" profiling?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of
<parameter>refentry.version.profile.enabled</parameter> is
non-zero, then during <tag>refentry</tag> metadata gathering, the info
profile specified by the customizable
<parameter>refentry.version.profile</parameter> parameter is
used.</para>

<para>If instead the value of
<parameter>refentry.version.profile.enabled</parameter> is zero (the
default), then "hard coded" logic within the DocBook XSL stylesheets
is used for gathering <tag>refentry</tag> "version" data.</para>

<para>If you find that the default <tag>refentry</tag>
metadata-gathering behavior is causing incorrect "version" data to show
up in your output, then consider setting a non-zero value for
<parameter>refentry.version.profile.enabled</parameter> and adjusting
the value of <parameter>refentry.version.profile</parameter> to cause
correct data to be gathered. </para>

<para>Note that the terms "source" and "version" have special
meanings in this context. For details, see the documentation for the
<parameter>refentry.version.profile</parameter> parameter.</para>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.version.profile.enabled">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.manual.fallback.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.manual.fallback.profile</refname>
<refpurpose>Specifies profile of "fallback" for refentry "manual" data</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The value of
<parameter>refentry.manual.fallback.profile</parameter> is a string
representing an XPath expression. It is evaluated at run-time and
used only if no "manual" data can be found by other means (that is,
either using the <tag>refentry</tag> metadata-gathering logic "hard
coded" in the stylesheets, or the value of
<parameter>refentry.manual.profile</parameter>, if it is
enabled).</para>

<important>
<para>Depending on which XSLT engine you run, either the EXSLT
<function>dyn:evaluate</function> extension function (for xsltproc or
Xalan) or <function>saxon:evaluate</function> extension function (for
Saxon) are used to dynamically evaluate the value of
<parameter>refentry.manual.fallback.profile</parameter> at
run-time. If you don't use xsltproc, Saxon, Xalan -- or some other
XSLT engine that supports <function>dyn:evaluate</function> -- you
must manually disable fallback processing by setting an empty value
for the <parameter>refentry.manual.fallback.profile</parameter>
parameter.</para>
</important>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.manual.fallback.profile">
refmeta/refmiscinfo[1]/node()</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>refentry.source.fallback.profile</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>refentry.source.fallback.profile</refname>
<refpurpose>Specifies profile of "fallback" for refentry "source" data</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The value of
<parameter>refentry.source.fallback.profile</parameter> is a string
representing an XPath expression. It is evaluated at run-time and used
only if no "source" data can be found by other means (that is, either
using the <tag>refentry</tag> metadata-gathering logic "hard coded" in
the stylesheets, or the value of the
<parameter>refentry.source.name.profile</parameter> and
<parameter>refentry.version.profile</parameter> parameters, if those
are enabled).</para>

<important>
<para>Depending on which XSLT engine you run, either the EXSLT
<function>dyn:evaluate</function> extension function (for xsltproc or
Xalan) or <function>saxon:evaluate</function> extension function (for
Saxon) are used to dynamically evaluate the value of
<parameter>refentry.source.fallback.profile</parameter> at
run-time. If you don't use xsltproc, Saxon, Xalan -- or some other
XSLT engine that supports <function>dyn:evaluate</function> -- you
must manually disable fallback processing by setting an empty value
for the <parameter>refentry.source.fallback.profile</parameter>
parameter.</para>
</important>

</refsect1>
</doc:refentry>
<xsl:param name="refentry.source.fallback.profile">
refmeta/refmiscinfo[1]/node()</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.th.extra1.suppress</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.th.extra1.suppress</refname>
<refpurpose>Suppress extra1 part of header/footer?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.th.extra1.suppress</parameter> is
non-zero, then the <literal>extra1</literal> part of the
<literal>.TH</literal> title line header/footer is suppressed.</para>

<para>The content of the <literal>extra1</literal> field is almost
always displayed in the center footer of the page and is, universally,
a date.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.th.extra1.suppress">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.th.extra2.suppress</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.th.extra2.suppress</refname>
<refpurpose>Suppress extra2 part of header/footer?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.th.extra2.suppress</parameter> is
non-zero, then the <literal>extra2</literal> part of the
<literal>.TH</literal> title line header/footer is suppressed.</para>

<para>The content of the <literal>extra2</literal> field is usually
displayed in the left footer of the page and is typically "source"
data, often in the form
<replaceable>Name</replaceable> <replaceable>Version</replaceable>;
for example, "GTK+ 1.2" (from the <literal>gtk-options(7)</literal>
man page).</para>

<note>
  <para>You can use the
  <parameter>refentry.source.name.suppress</parameter> and
  <parameter>refentry.version.suppress</parameter> parameters to
  independently suppress the <replaceable>Name</replaceable> and
  <replaceable>Version</replaceable> parts of the
  <literal>extra2</literal> field.</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="man.th.extra2.suppress">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.th.extra3.suppress</refentrytitle>
<refmiscinfo role="type">boolean</refmiscinfo>
</refmeta><refnamediv>
<refname>man.th.extra3.suppress</refname>
<refpurpose>Suppress extra3 part of header/footer?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <parameter>man.th.extra3.suppress</parameter> is
non-zero, then the <literal>extra3</literal> part of the
<literal>.TH</literal> title line header/footer is
suppressed.</para>

<para>The content of the <literal>extra3</literal> field is usually
displayed in the middle header of the page and is typically a "manual
name"; for example, "GTK+ User's Manual" (from the
<literal>gtk-options(7)</literal> man page).</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.th.extra3.suppress">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.th.title.max.length</refentrytitle>
<refmiscinfo role="type">integer</refmiscinfo>
</refmeta><refnamediv>
<refname>man.th.title.max.length</refname>
<refpurpose>Maximum length of title in header/footer</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>Specifies the maximum permitted length of the title part of the
man-page <literal>.TH</literal> title line header/footer. If the title
exceeds the maxiumum specified, it is truncated down to the maximum
permitted length.</para>

<refsect2>
  <title>Details</title>

<para>Every man page generated using the DocBook stylesheets has a
title line, specified using the <literal>TH</literal> roff
macro. Within that title line, there is always, at a minimum, a title,
followed by a section value (representing a man "section" -- usually
just a number).</para>

<para>The title and section are displayed, together, in the visible
header of each page. Where in the header they are displayed depends on
OS the man page is viewed on, and on what version of nroff/groff/man
is used for viewing the page. But, at a minimum and across all
systems, the title and section are displayed on the right-hand column
of the header. On many systems -- those with a modern groff, including
Linux systems -- they are displayed twice: both in the left and right
columns of the header.</para>

<para>So if the length of the title exceeds a certain percentage of
the column width in which the page is viewed, the left and right
titles can end up overlapping, making them unreadable, or breaking to
another line, which doesn't look particularly good.</para>

<para>So the stylesheets provide the
<parameter>man.th.title.max.length</parameter> parameter as a means
for truncating titles that exceed the maximum length that can be
viewing properly in a page header.</para>

<para>The default value is reasonable but somewhat arbitrary. If you
have pages with long titles, you may want to experiment with changing
the value in order to achieve the correct aesthetic results.</para>
</refsect2>

</refsect1>
</doc:refentry>
<xsl:param name="man.th.title.max.length">20</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.th.extra2.max.length</refentrytitle>
<refmiscinfo role="type">integer</refmiscinfo>
</refmeta><refnamediv>
<refname>man.th.extra2.max.length</refname>
<refpurpose>Maximum length of extra2 in header/footer</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>Specifies the maximum permitted length of the
<literal>extra2</literal> part of the man-page part of the
<literal>.TH</literal> title line header/footer. If the
<literal>extra2</literal> content exceeds the maxiumum specified, it
is truncated down to the maximum permitted length.</para>

<para>The content of the <literal>extra2</literal> field is usually
displayed in the left footer of the page and is typically "source"
data indicating the software system or product that the item
documented in the man page belongs to, often in the form
<replaceable>Name</replaceable> <replaceable>Version</replaceable>;
for example, "GTK+ 1.2" (from the <literal>gtk-options(7)</literal>
man page).</para>

<para>The default value for this parameter is reasonable but somewhat
arbitrary. If you are processing pages with long "source" information,
you may want to experiment with changing the value in order to achieve
the correct aesthetic results.</para>
</refsect1>
</doc:refentry>
<xsl:param name="man.th.extra2.max.length">30</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.th.extra3.max.length</refentrytitle>
<refmiscinfo role="type">integer</refmiscinfo>
</refmeta><refnamediv>
<refname>man.th.extra3.max.length</refname>
<refpurpose>Maximum length of extra3 in header/footer</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>Specifies the maximum permitted length of the
<literal>extra3</literal> part of the man-page <literal>.TH</literal>
title line header/footer. If the <literal>extra3</literal> content
exceeds the maxiumum specified, it is truncated down to the maximum
permitted length.</para>

<para>The content of the <literal>extra3</literal> field is usually
displayed in the middle header of the page and is typically a "manual
name"; for example, "GTK+ User's Manual" (from the
<literal>gtk-options(7)</literal> man page).</para>

<para>The default value for this parameter is reasonable but somewhat
arbitrary. If you are processing pages with long "manual names" -- or
especially if you are processing pages that have both long "title"
parts (command/function, etc. names) <emphasis>and</emphasis> long
manual names -- you may want to experiment with changing the value in
order to achieve the correct aesthetic results.</para>
</refsect1>
</doc:refentry>
<xsl:param name="man.th.extra3.max.length">30</xsl:param>

<doc:refentry><refmeta>
    <refentrytitle>man.output.manifest.enabled</refentrytitle>
    <refmiscinfo role="type">boolean</refmiscinfo>
  </refmeta><refnamediv>
    <refname>man.output.manifest.enabled</refname>
    <refpurpose>Generate a manifest file?</refpurpose>
  </refnamediv><refsynopsisdiv>
    
  </refsynopsisdiv><refsect1><title>Description</title>

    <para>If non-zero, a list of filenames for man pages generated by
    the stylesheet transformation is written to the file named by the
    <parameter>man.output.manifest.filename</parameter> parameter.</para>

  </refsect1>
</doc:refentry>
<xsl:param name="man.output.manifest.enabled" select="0"/>

<doc:refentry><refmeta>
    <refentrytitle>man.output.manifest.filename</refentrytitle>
    <refmiscinfo role="type">string</refmiscinfo>
  </refmeta><refnamediv>
    <refname>man.output.manifest.filename</refname>
    <refpurpose>Name of manifest file</refpurpose>
  </refnamediv><refsynopsisdiv>
    
  </refsynopsisdiv><refsect1><title>Description</title>

    <para>The <parameter>man.output.manifest.filename</parameter> parameter
    specifies the name of the file to which the manpages manifest file
    is written (if the value of the
    <parameter>man.output.manifest.enabled</parameter> parameter is
    non-zero).</para>

  </refsect1>
</doc:refentry>
<xsl:param name="man.output.manifest.filename">MAN.MANIFEST</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.output.in.separate.dir</refentrytitle>

</refmeta><refnamediv>
<refname>man.output.in.separate.dir</refname>
<refpurpose>Output man-page files in separate output directory?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of <literal>man.output.in.separate.dir</literal>
parameter is non-zero, man-page files are output in a separate
directory, specified by the <parameter>man.output.base.dir</parameter>
parameter; otherwise, if the value of
<literal>man.output.in.separate.dir</literal> is zero, man-page files
are not output in a separate directory.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.output.in.separate.dir" select="0"/>

<doc:refentry><refmeta>
<refentrytitle>man.output.base.dir</refentrytitle>

</refmeta><refnamediv>
<refname>man.output.base.dir</refname>
<refpurpose>Specifies separate output directory</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.output.base.dir</parameter> parameter
specifies the base directory into which man-page files are output. The
<parameter>man.output.subdirs.enabled</parameter> parameter controls
whether the files are output in subdirectories within the base
directory.</para>

<note>
  <para>The values of the <parameter>man.output.base.dir</parameter>
  and <parameter>man.output.subdirs.enabled</parameter> parameters are
  used only if the value of
  <parameter>man.output.in.separate.dir</parameter> parameter is
  non-zero. If the value of the
  <parameter>man.output.in.separate.dir</parameter> is zero, man-page
  files are not output in a separate directory.</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="man.output.base.dir">man/</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.output.subdirs.enabled</refentrytitle>

</refmeta><refnamediv>
<refname>man.output.subdirs.enabled</refname>
<refpurpose>Output man-page files in subdirectories within base output directory?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>The <parameter>man.output.subdirs.enabled</parameter> parameter
controls whether man-pages files are output in subdirectories within
the base directory specified by the directory specified by the
<parameter>man.output.base.dir</parameter> parameter.</para>

<note>
  <para>The values of the <parameter>man.output.base.dir</parameter>
  and <parameter>man.output.subdirs.enabled</parameter> parameters are
  used only if the value of
  <parameter>man.output.in.separate.dir</parameter> parameter is
  non-zero. If the value of the
  <parameter>man.output.in.separate.dir</parameter> is zero, man-page
  files are not output in a separate directory.</para>
</note>

</refsect1>
</doc:refentry>
<xsl:param name="man.output.subdirs.enabled" select="1"/>

<doc:refentry><refmeta>
<refentrytitle>man.output.quietly</refentrytitle>

</refmeta><refnamediv>
<refname>man.output.quietly</refname>
<refpurpose>Suppress filename messages emitted when generating output?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If zero (the default), for each man-page file created, a message
with the name of the file is emitted. If non-zero, the files are
output "quietly" -- that is, the filename messages are
suppressed.</para>

<tip>
  <para>If you are processing a large amount of <tag>refentry</tag>
  content, you may be able to speed up processing significantly by
  setting a non-zero value for
  <parameter>man.output.quietly</parameter>.</para>
</tip>

</refsect1>
</doc:refentry>
<xsl:param name="man.output.quietly" select="0"/>

<doc:refentry><refmeta>
<refentrytitle>man.output.encoding</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.output.encoding</refname>
<refpurpose>Encoding used for man-page output</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>This parameter specifies the encoding to use for files generated
by the manpages stylesheet. Not all processors support specification
of this parameter.</para>

<important>
  <para>If the value of the <parameter>man.charmap.enabled</parameter>
  parameter is non-zero (the default), keeping the
  <parameter>man.output.encoding</parameter> parameter at its default
  value (<literal>UTF-8</literal>) or setting it to
  <literal>UTF-16</literal> <emphasis role="bold">does not cause your
  man pages to be output in raw UTF-8 or UTF-16</emphasis> -- because
  any Unicode characters for which matches are found in the enabled
  character map will be replaced with roff escape sequences before the
  final man-page files are generated.</para>

  <para>So if you want to generate "real" UTF-8 man pages, without any
  character substitution being performed on your content, you need to
  set <parameter>man.charmap.enabled</parameter> to zero (which will
  completely disable character-map processing). </para>

  <para>You may also need to set
  <parameter>man.charmap.enabled</parameter> to zero if you want to
  output man pages in an encoding other than <literal>UTF-8</literal>
  or <literal>UTF-16</literal>. Character-map processing is based on
  Unicode character values and may not work with other output
  encodings.</para>
</important>

</refsect1>
</doc:refentry>
<xsl:param name="man.output.encoding" select="'UTF-8'"/>

<doc:refentry><refmeta>
<refentrytitle>man.table.footnotes.divider</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.table.footnotes.divider</refname>
<refpurpose>Specifies divider string that appears before table footnotes</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>In each table that contains footenotes, the string specified by
the <parameter>man.table.footnotes.divider</parameter> parameter is
output before the list of footnotes for the table.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.table.footnotes.divider">----</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.subheading.divider.enabled</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.subheading.divider.enabled</refname>
<refpurpose>Add divider comment to roff source before/after subheadings?</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of the
<parameter>man.subheading.divider.enabled</parameter> parameter is
non-zero, the contents of the
<parameter>man.subheading.divider</parameter> parameter are used to
add a "divider" before and after subheadings in the roff
output. <emphasis role="bold">The divider is not visisble in the
rendered man page</emphasis>; it is added as a comment, in the source,
simply for the purpose of increasing reability of the source.</para>

<para>If <parameter>man.subheading.divider.enabled</parameter> is zero
(the default), the subheading divider is suppressed.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.subheading.divider.enabled">0</xsl:param>

<doc:refentry><refmeta>
<refentrytitle>man.subheading.divider</refentrytitle>
<refmiscinfo role="type">string</refmiscinfo>
</refmeta><refnamediv>
<refname>man.subheading.divider</refname>
<refpurpose>Specifies string to use as divider comment before/after subheadings</refpurpose>
</refnamediv><refsynopsisdiv>

</refsynopsisdiv><refsect1><title>Description</title>

<para>If the value of the
<parameter>man.subheading.divider.enabled</parameter> parameter is
non-zero, the contents of the
<parameter>man.subheading.divider</parameter> parameter are used to
add a "divider" before and after subheadings in the roff
output. <emphasis role="bold">The divider is not visisble in the
rendered man page</emphasis>; it is added as a comment, in the source,
simply for the purpose of increasing reability of the source.</para>

<para>If <parameter>man.subheading.divider.enabled</parameter> is zero
(the default), the subheading divider is suppressed.</para>

</refsect1>
</doc:refentry>
<xsl:param name="man.subheading.divider">========================================================================</xsl:param>
</xsl:stylesheet>