/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.ruta.ide.formatter;

import org.eclipse.dltk.ui.CodeFormatterConstants;

public class RutaFormatterConstants {

  public static final String FORMATTER_TAB_CHAR = CodeFormatterConstants.FORMATTER_TAB_CHAR;

  public static final String FORMATTER_TAB_SIZE = CodeFormatterConstants.FORMATTER_TAB_SIZE;

  public static final String FORMATTER_INDENTATION_SIZE = CodeFormatterConstants.FORMATTER_INDENTATION_SIZE;

  public static final String FORMATTER_PROFILES = "formatter.profiles"; //$NON-NLS-1$

  public static final String FORMATTER_ACTIVE_PROFILE = "formatter.profiles.active"; //$NON-NLS-1$

  public static final String INDENT_BLOCK = "indent.block";

  public static final String INDENT_STRUCTURE = "indent.structure";

  // TODO implement smarter format options, first just indentation...
  public static final String LINES_BEFORE_LONG_DECLARATIONS = "lines.before.long.declarations";

  public static final String MAX_LINE_LENGTH = "wrapping.max.line.length";

  // public static final String LINES_FILE_AFTER_GLOBAL =
  // "line.file.global.after";
  // public static final String LINES_FILE_BEFORE_FIRST_ =
  // "line.file.block.between";
  // public static final String LINES_FILE_BETWEEN_BLOCK =
  // "line.file.block.between";
  // public static final String LINES_FILE_BETWEEN_BLOCK =
  // "line.file.block.between";
  // public static final String LINES_FILE_BETWEEN_BLOCK =
  // "line.file.block.between";
  // public static final String LINES_FILE_BETWEEN_BLOCK =
  // "line.file.block.between";
  // public static final String LINES_FILE_BETWEEN_BLOCK =
  // "line.file.block.between";

  public static final String LINES_PRESERVE = "lines.preserve";
}
