/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerFactory;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerParameter;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrabalFactory
implements TextRulerLearnerFactory {
    @Override
    public Map<String, Object> getAlgorithmParameterStandardValues() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("algorithmIterations", 3);
        values.put("maxNumberOfBasicRules", 80);
        values.put("maxNumberOfRules", 150);
        values.put("maxNumberOfIterations", 2);
        values.put("maxErrorRate", 0.4);
        values.put("enableFeatures", false);
        return values;
    }

    @Override
    public TextRulerLearner createAlgorithm(String inputFolderPath, String additionalFolderPath, String preprocessorRutaFile, String tempFolderPath, String[] fullSlotTypeNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        return new TrabalLearner(inputFolderPath, additionalFolderPath, preprocessorRutaFile, tempFolderPath, fullSlotTypeNames, filterSet, skip, delegate);
    }

    @Override
    public TextRulerLearnerParameter[] getAlgorithmParameters() {
        TextRulerLearnerParameter[] result = new TextRulerLearnerParameter[]{new TextRulerLearnerParameter("algorithmIterations", "Number of times, the algorithm iterates.", TextRulerLearnerParameter.MLAlgorithmParamType.ML_INT_PARAM), new TextRulerLearnerParameter("maxNumberOfBasicRules", "Number of basic rules to be created for one example.", TextRulerLearnerParameter.MLAlgorithmParamType.ML_INT_PARAM), new TextRulerLearnerParameter("maxNumberOfRules", "Number of optimized rules to be created for one example.", TextRulerLearnerParameter.MLAlgorithmParamType.ML_INT_PARAM), new TextRulerLearnerParameter("maxNumberOfIterations", "Maximum number of iterations, when optimizing rules.", TextRulerLearnerParameter.MLAlgorithmParamType.ML_INT_PARAM), new TextRulerLearnerParameter("maxErrorRate", "Maximum allowed error rate.", TextRulerLearnerParameter.MLAlgorithmParamType.ML_DOUBLE_PARAM), new TextRulerLearnerParameter("enableFeatures", "Correct features in rules and conditions.", TextRulerLearnerParameter.MLAlgorithmParamType.ML_BOOL_PARAM)};
        return result;
    }
}

