/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonToken;
import org.apache.uima.ruta.ide.formatter.RutaFormatter;
import org.apache.uima.ruta.ide.parser.ast.ComposedRuleElement;
import org.apache.uima.ruta.ide.parser.ast.RutaAbstractDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaBinaryArithmeticExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaBlock;
import org.apache.uima.ruta.ide.parser.ast.RutaBooleanNumberExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaDeclarationsStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaDeclareDeclarationsStatement;
import org.apache.uima.ruta.ide.parser.ast.RutaExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaFeatureDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaListExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaLogAction;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaQuantifierLiteralExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaRule;
import org.apache.uima.ruta.ide.parser.ast.RutaRuleElement;
import org.apache.uima.ruta.ide.parser.ast.RutaStringExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaStructureAction;
import org.apache.uima.ruta.ide.parser.ast.RutaTypeDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.formatter.FormatterDocument;
import org.eclipse.dltk.formatter.IFormatterIndentGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaFormattedPrinter
extends ASTVisitor {
    private FormatterDocument document;
    private String lineDelimiter;
    private static final String SEMI = ";";
    private static final String CONCAT = " + ";
    private static final String COMMA = ",";
    private static final int NL_DECLS_COUNT = 2;
    private static final String CURLY_OPEN = "{";
    private static final String CURLY_CLOSE = "}";
    private static final String BRACK_OPEN = "[";
    private static final String BRACK_CLOSE = "]";
    private static final String THEN = "->";
    private static final String PAR_OPEN = "(";
    private static final String PAR_CLOSE = ")";
    private static final String EQUALS = " = ";
    private IFormatterIndentGenerator indentGenerator;
    private StringBuilder output;
    private List<CommonToken> comments;
    private Iterator<CommonToken> iterator;
    private CommonToken currentComment;
    private int indentLevel = 0;
    private int lines_before_long_declarations;
    private int maxLineLength;
    private boolean inBlockDeclaration = false;
    private Map<Integer, Object> lastStatements = new HashMap<Integer, Object>();
    private int commentLineSince = 0;
    private int inLargeRule = 0;
    private boolean retainLB = true;

    public RutaFormattedPrinter(FormatterDocument document, String lineDelimiter, IFormatterIndentGenerator indentGenerator, List<CommonToken> comments, RutaFormatter tmf) {
        this.document = document;
        this.lineDelimiter = lineDelimiter;
        this.indentGenerator = indentGenerator;
        this.output = new StringBuilder();
        this.lines_before_long_declarations = tmf.getInt("lines.before.long.declarations");
        this.maxLineLength = tmf.getInt("wrapping.max.line.length");
        this.comments = comments == null ? new ArrayList() : comments;
        this.iterator = this.comments.iterator();
        this.currentComment = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    public String getOutput() {
        this.appendLeftComments();
        return this.output.toString();
    }

    public boolean visit(Statement s) throws Exception {
        this.appendComments((ASTNode)s);
        this.fillNewLines(s);
        if (s instanceof RutaDeclarationsStatement) {
            RutaDeclareDeclarationsStatement dds;
            ASTNode p;
            RutaDeclarationsStatement decls = (RutaDeclarationsStatement)s;
            this.appendIntoNewLine(this.document.get(decls.getTypeTokenStart(), decls.getTypeTokenEnd()) + " ");
            if (s instanceof RutaDeclareDeclarationsStatement && (p = (dds = (RutaDeclareDeclarationsStatement)s).getParent()) != null) {
                this.append(p);
                this.append(" ");
            }
            List<RutaAbstractDeclaration> declarations = decls.getDeclarations();
            this.traverseAstNodes(declarations);
            if (decls.getInitExpr() != null) {
                this.append(EQUALS);
                decls.getInitExpr().traverse((ASTVisitor)this);
            }
            this.appendStatementEnd();
            return false;
        }
        if (s instanceof RutaRule) {
            if (!this.inBlockDeclaration) {
                this.appendNewLine();
            }
            if (s.sourceEnd() - s.sourceStart() > 2 * this.maxLineLength) {
                this.inLargeRule = 1;
                ++this.indentLevel;
            }
            RutaRule rule = (RutaRule)s;
            List<Expression> expressions = rule.getExpressions();
            this.traverseAstNodes(expressions, "");
            if (!this.inBlockDeclaration) {
                this.appendStatementEnd();
            }
            if (this.inLargeRule > 0) {
                --this.indentLevel;
                this.inLargeRule = 0;
            }
            return false;
        }
        if (s instanceof RutaTypeDeclaration) {
            this.append((ASTNode)s);
            List<RutaFeatureDeclaration> features = ((RutaTypeDeclaration)s).getFeatures();
            if (features != null && !features.isEmpty()) {
                this.append(PAR_OPEN);
                for (RutaFeatureDeclaration each : features) {
                    this.append(each.getType());
                    this.append(" ");
                    this.append(each.getName());
                    if (features.indexOf((Object)each) >= features.size() - 1) continue;
                    this.append(", ");
                }
                this.append(PAR_CLOSE);
            }
            return false;
        }
        if (s instanceof Declaration && !(s instanceof RutaPackageDeclaration)) {
            this.append((ASTNode)s);
            return false;
        }
        if (s instanceof RutaPackageDeclaration) {
            this.append((ASTNode)s);
            this.appendStatementEnd();
            return false;
        }
        this.appendIntoNewLine((ASTNode)s);
        this.appendStatementEnd();
        return false;
    }

    private void fillNewLines(Object s) {
        Object last = this.lastStatements.get(this.indentLevel);
        if (last != null && this.retainLB) {
            int start = 0;
            int end = 0;
            if (s instanceof Statement) {
                end = ((ASTNode)s).sourceStart();
            } else if (s instanceof CommonToken) {
                end = ((CommonToken)s).getStartIndex();
            }
            if (last instanceof Statement) {
                start = ((ASTNode)last).sourceEnd() + 1;
            } else if (last instanceof CommonToken) {
                start = ((CommonToken)last).getStopIndex();
            }
            if (start < end) {
                String string = this.document.get(start, end);
                String replaceAll = string.replaceAll(this.lineDelimiter, "");
                double d = (string.length() - replaceAll.length()) / this.lineDelimiter.length() - this.commentLineSince;
                if (s instanceof CommonToken && this.commentLineSince == 0) {
                    d += 1.0;
                }
                int i = 1;
                while ((double)i < d) {
                    this.appendNewLine();
                    ++i;
                }
                if (d < 2.0 && s instanceof RutaDeclarationsStatement && !(last instanceof Declaration)) {
                    this.appendNewLine();
                }
                this.commentLineSince = 0;
            }
        } else if (this.inBlockDeclaration || s instanceof CommonToken) {
            this.appendNewLine();
        }
        this.lastStatements.put(this.indentLevel, s);
    }

    public boolean endvisit(Statement s) throws Exception {
        return super.endvisit(s);
    }

    public boolean visit(Expression s) throws Exception {
        if (s instanceof Block) {
            return true;
        }
        if (s instanceof ComposedRuleElement) {
            ComposedRuleElement cre = (ComposedRuleElement)s;
            List<Expression> elements = cre.getElements();
            if (this.inLargeRule == 2) {
                this.inLargeRule = 4;
            }
            this.append(PAR_OPEN);
            this.traverseAstNodes(elements, cre.isDisjunctive() ? " |" : "");
            this.append(PAR_CLOSE);
            this.appendRuleElement(cre);
            if (this.inLargeRule == 4) {
                this.inLargeRule = 1;
            }
            return false;
        }
        if (s instanceof RutaRuleElement) {
            RutaRuleElement ruleEl = (RutaRuleElement)s;
            if (this.inLargeRule == 2) {
                this.appendNewLine();
            } else if (this.inLargeRule == 1) {
                this.inLargeRule = 2;
            }
            this.appendRuleElement(ruleEl);
            return false;
        }
        if (s instanceof RutaAction) {
            RutaAction a = (RutaAction)s;
            String name = this.document.get(a.getNameStart(), a.getNameEnd());
            this.append(name);
            List<Expression> childs = a.getChilds();
            if (childs != null && !childs.isEmpty()) {
                this.append(PAR_OPEN);
                if (a instanceof RutaStructureAction) {
                    if (name.equals("TRIE")) {
                        this.printStructureAction2(a);
                    } else {
                        this.printStructureAction(a);
                    }
                } else {
                    this.traverseAstNodes(childs);
                }
                if (a instanceof RutaLogAction && ((RutaLogAction)a).isLogLevelAssigned()) {
                    this.appendSeparator(COMMA);
                    RutaLogAction logAction = (RutaLogAction)a;
                    this.append(logAction.getLogLevelStart(), logAction.getLogLevelEnd());
                }
                this.append(PAR_CLOSE);
            }
            return false;
        }
        if (s instanceof RutaCondition) {
            RutaCondition c = (RutaCondition)s;
            this.append(this.document.get(c.getNameStart(), c.getNameEnd()));
            List<Expression> childs = c.getChilds();
            if (s.getKind() != 10141 && childs != null && !childs.isEmpty()) {
                this.append(PAR_OPEN);
            }
            this.traverseAstNodes(childs);
            if (s.getKind() != 10141 && childs != null && !childs.isEmpty()) {
                this.append(PAR_CLOSE);
            }
            return false;
        }
        if (s instanceof RutaBooleanNumberExpression) {
            RutaBooleanNumberExpression tmbne = (RutaBooleanNumberExpression)s;
            this.append(PAR_OPEN);
            if (tmbne.getE1() != null) {
                tmbne.getE1().traverse((ASTVisitor)this);
            }
            this.append(tmbne.getOperator());
            if (tmbne.getE2() != null) {
                tmbne.getE2().traverse((ASTVisitor)this);
            }
            this.append(PAR_CLOSE);
            return false;
        }
        if (s instanceof RutaStringExpression && ((RutaExpression)s).getExpression() != null) {
            RutaStringExpression tmse = (RutaStringExpression)s;
            List childs = tmse.getExpression().getChilds();
            Object object2 = childs.get(0);
            if (object2 instanceof ASTNode) {
                ASTNode astnode = (ASTNode)object2;
                List childs2 = astnode.getChilds();
                for (Object object : childs2) {
                    if (object instanceof RutaExpression) {
                        RutaExpression expr = (RutaExpression)((Object)object);
                        this.append((ASTNode)expr);
                    } else if (object instanceof StringLiteral) {
                        StringLiteral sl = (StringLiteral)object;
                        String value = sl.getValue();
                        this.append(value);
                    } else if (object instanceof RutaVariableReference) {
                        RutaVariableReference vr = (RutaVariableReference)((Object)object);
                        this.append(vr.getName());
                    }
                    if (childs2.indexOf(object) >= childs2.size() - 1) continue;
                    this.append(CONCAT);
                }
            } else {
                this.append((ASTNode)s);
            }
            return false;
        }
        if (s instanceof RutaListExpression) {
            RutaListExpression le = (RutaListExpression)s;
            this.append(CURLY_OPEN);
            ASTListNode exprs = le.getExprs();
            this.traverseAstNodes(exprs.getChilds());
            this.append(CURLY_CLOSE);
            return false;
        }
        if (s instanceof RutaBinaryArithmeticExpression) {
            RutaBinaryArithmeticExpression ba = (RutaBinaryArithmeticExpression)s;
            String operator = ba.getOperator();
            this.append(operator);
            this.append(PAR_OPEN);
            this.traverseAstNodes(ba.getChilds());
            this.append(PAR_CLOSE);
        }
        this.append((ASTNode)s);
        return false;
    }

    private void printStructureAction(RutaAction a) {
        RutaStructureAction tmca = (RutaStructureAction)a;
        if (tmca.getStructure() != null) {
            this.append((ASTNode)tmca.getStructure());
        }
        this.append(COMMA);
        this.append(" ");
        List<Expression> indices = tmca.getExpressions();
        if (indices != null) {
            this.traverseAstNodes(indices);
        }
        if (!indices.isEmpty()) {
            this.append(COMMA);
            this.append(" ");
        }
        Map<Expression, Expression> assignments = tmca.getAssignments();
        Iterator<Map.Entry<Expression, Expression>> it = assignments.entrySet().iterator();
        while (it.hasNext()) {
            if (assignments.size() > 3) {
                this.appendNewLineAndIndent();
            }
            Map.Entry<Expression, Expression> pairs = it.next();
            try {
                pairs.getKey().traverse((ASTVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.append(EQUALS);
            try {
                pairs.getValue().traverse((ASTVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!it.hasNext()) continue;
            this.output.append(COMMA);
            this.append(" ");
        }
    }

    private void printStructureAction2(RutaAction a) {
        RutaStructureAction tmca = (RutaStructureAction)a;
        Map<Expression, Expression> assignments = tmca.getAssignments();
        Iterator<Map.Entry<Expression, Expression>> it = assignments.entrySet().iterator();
        while (it.hasNext()) {
            if (assignments.size() > 3) {
                this.appendNewLineAndIndent();
            }
            Map.Entry<Expression, Expression> pairs = it.next();
            try {
                pairs.getKey().traverse((ASTVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.append(EQUALS);
            try {
                pairs.getValue().traverse((ASTVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.output.append(COMMA);
            this.append(" ");
        }
        if (tmca.getStructure() != null) {
            this.append((ASTNode)tmca.getStructure());
        }
        this.append(COMMA);
        this.append(" ");
        List<Expression> indices = tmca.getExpressions();
        if (indices != null) {
            this.traverseAstNodes(indices);
        }
    }

    public boolean endvisit(Expression s) throws Exception {
        return super.endvisit(s);
    }

    private void appendRuleElement(RutaRuleElement ruleEl) {
        if (ruleEl.getHead() != null) {
            this.append((ASTNode)ruleEl.getHead());
        }
        List<RutaCondition> conditions = ruleEl.getConditions();
        List<RutaAction> actions = ruleEl.getActions();
        List<Expression> quantifierExpressions = ruleEl.getQuantifierExpressions();
        if (quantifierExpressions != null && !quantifierExpressions.isEmpty()) {
            if (quantifierExpressions.size() == 1) {
                ASTNode astNode = (ASTNode)quantifierExpressions.get(0);
                if (astNode instanceof RutaQuantifierLiteralExpression) {
                    this.append(astNode);
                } else {
                    this.append(BRACK_OPEN);
                    this.append(astNode);
                    this.append(BRACK_CLOSE);
                }
            } else if (quantifierExpressions.size() == 2) {
                if (quantifierExpressions.get(1) instanceof RutaQuantifierLiteralExpression) {
                    this.append(BRACK_OPEN);
                    this.append((ASTNode)quantifierExpressions.get(0));
                    this.append(BRACK_CLOSE);
                    this.append((ASTNode)quantifierExpressions.get(1));
                } else {
                    this.append(BRACK_OPEN);
                    this.append((ASTNode)quantifierExpressions.get(0));
                    this.append(", ");
                    this.append((ASTNode)quantifierExpressions.get(1));
                    this.append(BRACK_CLOSE);
                }
            } else if (quantifierExpressions.size() == 3) {
                this.append(BRACK_OPEN);
                this.append((ASTNode)quantifierExpressions.get(0));
                this.append(", ");
                this.append((ASTNode)quantifierExpressions.get(1));
                this.append(BRACK_CLOSE);
                this.append((ASTNode)quantifierExpressions.get(2));
            }
        }
        if (!this.inBlockDeclaration && conditions == null && actions == null) {
            return;
        }
        if (!this.inBlockDeclaration && (conditions == null && actions.isEmpty() || actions == null && conditions != null && conditions.isEmpty())) {
            return;
        }
        this.append(CURLY_OPEN);
        if (conditions != null && !conditions.isEmpty()) {
            this.traverseAstNodes(conditions);
        }
        if (conditions == null || !conditions.isEmpty()) {
            // empty if block
        }
        if (actions != null && !actions.isEmpty()) {
            if (conditions != null && !conditions.isEmpty()) {
                this.append(" -> ");
            } else {
                this.append("-> ");
            }
            this.traverseAstNodes(actions);
        }
        this.append(CURLY_CLOSE);
    }

    private void traverseAstNodes(List<? extends ASTNode> astnodes) {
        this.traverseAstNodes(astnodes, COMMA);
    }

    private void traverseAstNodes(List<? extends ASTNode> astnodes, String separator) {
        if (astnodes == null) {
            return;
        }
        Iterator<? extends ASTNode> iterator2 = astnodes.iterator();
        while (iterator2.hasNext()) {
            ASTNode node = iterator2.next();
            try {
                node.traverse((ASTVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!iterator2.hasNext()) continue;
            this.appendSeparator(separator);
        }
    }

    private void appendSeparator(String separator) {
        this.output.append(separator);
        this.append(" ");
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        this.appendComments((ASTNode)s);
        this.fillNewLines(s);
        if (s instanceof RutaBlock) {
            RutaBlock b = (RutaBlock)s;
            this.appendIntoNewLine("BLOCK(");
            this.append(b.getName());
            this.append(") ");
            this.inBlockDeclaration = true;
            if (b.getRule() != null) {
                b.getRule().traverse(this);
            }
            this.inBlockDeclaration = false;
            this.append(" {");
            ++this.indentLevel;
            b.getBody().traverse((ASTVisitor)this);
            this.lastStatements.put(this.indentLevel, null);
            --this.indentLevel;
            this.lastStatements.put(this.indentLevel, s);
            this.appendIntoNewLine(CURLY_CLOSE);
            this.appendNewLine();
            return false;
        }
        return super.visit(s);
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        return true;
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        return super.visit(s);
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        return super.visitGeneral(node);
    }

    private void append(int begin, int end) {
        this.append(this.document.get(begin, end));
    }

    private void append(String string) {
        if (this.outputPosInLine() + string.length() > this.maxLineLength) {
            this.appendNewLine();
            this.indentGenerator.generateIndent(1, this.output);
        }
        this.output.append(string);
    }

    private void appendIntoNewLine(String string) {
        this.appendNewLine();
        this.output.append(string);
    }

    private void append(ASTNode s) {
        this.appendComments(s);
        this.append(this.document.get(s.sourceStart(), s.sourceEnd()));
    }

    private void appendIntoNewLine(ASTNode s) {
        this.appendComments(s);
        this.appendNewLine();
        this.append(s);
    }

    private void appendNewLine() {
        this.output.append(this.lineDelimiter);
        this.indentGenerator.generateIndent(this.indentLevel, this.output);
    }

    private void appendNewLineAndIndent() {
        this.output.append(this.lineDelimiter);
        this.indentGenerator.generateIndent(this.indentLevel + 1, this.output);
    }

    private void appendStatementEnd() {
        this.output.append(SEMI);
    }

    private int appendComments(ASTNode s) {
        return this.appendComments(s.sourceStart());
    }

    private int appendComments(int start) {
        while (this.currentComment != null && this.currentComment.getStartIndex() < start) {
            String text = this.currentComment.getText().trim();
            this.fillNewLines(this.currentComment);
            this.append("" + text);
            this.currentComment = this.iterator.hasNext() ? this.iterator.next() : null;
            ++this.commentLineSince;
        }
        return start;
    }

    private void appendLeftComments() {
        while (this.currentComment != null) {
            this.append(this.currentComment.getText());
            this.currentComment = this.iterator.hasNext() ? this.iterator.next() : null;
        }
    }

    private int outputPosInLine() {
        String out = this.output.toString();
        int lastIndexOf = out.lastIndexOf("\n");
        return out.length() - lastIndexOf;
    }
}

