/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class SetFeatureAction
extends AbstractRutaAction {
    private final StringExpression featureStringExpression;
    private StringExpression stringExpr;
    private NumberExpression numberExpr;
    private BooleanExpression booleanExpr;
    private TypeExpression typeExpr;

    protected SetFeatureAction(StringExpression feature) {
        this.featureStringExpression = feature;
    }

    public SetFeatureAction(StringExpression feature, StringExpression stringExpr) {
        this(feature);
        this.stringExpr = stringExpr;
    }

    public SetFeatureAction(StringExpression feature, NumberExpression numberExpr) {
        this(feature);
        this.numberExpr = numberExpr;
    }

    public SetFeatureAction(StringExpression feature, BooleanExpression booleanExpr) {
        this(feature);
        this.booleanExpr = booleanExpr;
    }

    public SetFeatureAction(StringExpression feature, TypeExpression typeExpr) {
        this(feature);
        this.typeExpr = typeExpr;
    }

    public StringExpression getFeatureStringExpression() {
        return this.featureStringExpression;
    }

    public StringExpression getStringExpr() {
        return this.stringExpr;
    }

    public NumberExpression getNumberExpr() {
        return this.numberExpr;
    }

    public BooleanExpression getBooleanExpr() {
        return this.booleanExpr;
    }

    public TypeExpression getTypeExpr() {
        return this.typeExpr;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Object> types = new ArrayList();
        if (element instanceof RutaRuleElement) {
            types = ((RutaRuleElement)element).getMatcher().getTypes(element.getParent(), stream);
        }
        if (types == null) {
            return;
        }
        for (Type type : types) {
            String featureString = this.featureStringExpression.getStringValue(element.getParent());
            Feature featureByBaseName = type.getFeatureByBaseName(featureString);
            List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotationsOf(element, stream);
            for (AnnotationFS annotationFS : matchedAnnotations) {
                if (annotationFS.getType().getFeatureByBaseName(featureString) == null) {
                    System.out.println("Can't access feature " + featureString + ", because it's not defined in the matched type: " + annotationFS.getType());
                    return;
                }
                stream.getCas().removeFsFromIndexes((FeatureStructure)annotationFS);
                if (this.stringExpr != null) {
                    String string = this.stringExpr.getStringValue(element.getParent());
                    annotationFS.setStringValue(featureByBaseName, string);
                } else if (this.numberExpr != null) {
                    String range = featureByBaseName.getRange().getName();
                    if (range.equals("uima.cas.Integer")) {
                        int v = this.numberExpr.getIntegerValue(element.getParent());
                        annotationFS.setIntValue(featureByBaseName, v);
                    } else if (range.equals("uima.cas.Double")) {
                        double v = this.numberExpr.getDoubleValue(element.getParent());
                        annotationFS.setDoubleValue(featureByBaseName, v);
                    } else if (range.equals("uima.cas.Float")) {
                        float v = this.numberExpr.getFloatValue(element.getParent());
                        annotationFS.setFloatValue(featureByBaseName, v);
                    } else if (range.equals("uima.cas.Byte")) {
                        byte v = (byte)this.numberExpr.getIntegerValue(element.getParent());
                        annotationFS.setByteValue(featureByBaseName, v);
                    } else if (range.equals("uima.cas.Short")) {
                        short v = (short)this.numberExpr.getIntegerValue(element.getParent());
                        annotationFS.setShortValue(featureByBaseName, v);
                    } else if (range.equals("uima.cas.Long")) {
                        long v = this.numberExpr.getIntegerValue(element.getParent());
                        annotationFS.setLongValue(featureByBaseName, v);
                    }
                } else if (this.booleanExpr != null) {
                    boolean v = this.booleanExpr.getBooleanValue(element.getParent());
                    annotationFS.setBooleanValue(featureByBaseName, v);
                } else if (this.typeExpr != null) {
                    Type t = this.typeExpr.getType(element.getParent());
                    List<AnnotationFS> inWindow = stream.getAnnotationsInWindow(annotationFS, t);
                    if (featureByBaseName.getRange().isArray()) {
                        annotationFS.setFeatureValue(featureByBaseName, (FeatureStructure)UIMAUtils.toFSArray(stream.getJCas(), inWindow));
                    } else {
                        AnnotationFS annotation = inWindow.get(0);
                        annotationFS.setFeatureValue(featureByBaseName, (FeatureStructure)annotation);
                    }
                }
                stream.getCas().addFsToIndexes((FeatureStructure)annotationFS);
            }
        }
    }
}

