/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.CasCache;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerShiftExample;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.util.CasCopier;

public class TextRulerExampleDocument {
    protected String casFileName;
    protected CasCache casCache;
    protected List<TextRulerExample> positiveExamples = new ArrayList<TextRulerExample>();
    protected List<TextRulerExample> negativeExamples = new ArrayList<TextRulerExample>();

    public TextRulerExampleDocument(String casFileName, CasCache casCache) {
        this.casCache = casCache;
        this.casFileName = casFileName;
    }

    public CAS getCAS() {
        return this.casCache.getCAS(this.casFileName);
    }

    public List<TextRulerExample> getPositiveExamples() {
        return this.positiveExamples;
    }

    public List<TextRulerExample> getNegativeExamples() {
        return this.negativeExamples;
    }

    protected void createPositiveExamplesForTarget(TextRulerTarget target) {
        this.positiveExamples = this.createSlotInstancesForCAS(this.getCAS(), target, true);
    }

    public List<TextRulerExample> createSlotInstancesForCAS(CAS aCas, TextRulerTarget target, boolean createFromRawTypeName) {
        ArrayList<TextRulerExample> result;
        block15: {
            block14: {
                result = new ArrayList<TextRulerExample>();
                if (!target.isMultiSlot()) break block14;
                TypeSystem ts = aCas.getTypeSystem();
                int currentSlotIndex = 0;
                TextRulerAnnotation[] currentAnnotations = new TextRulerAnnotation[target.slotNames.length];
                ArrayList<Type> slotTypes = new ArrayList<Type>();
                for (String s : target.slotNames) {
                    slotTypes.add(ts.getType(s));
                }
                FSIterator it = aCas.getAnnotationIndex().iterator(true);
                while (it.isValid()) {
                    AnnotationFS fs = (AnnotationFS)it.get();
                    Type theType = fs.getType();
                    if (slotTypes.contains(theType)) {
                        int idx = slotTypes.indexOf(theType);
                        if (idx < currentSlotIndex) {
                            result.add(new TextRulerExample(this, currentAnnotations, true, target));
                            currentAnnotations = new TextRulerAnnotation[target.slotNames.length];
                        }
                        currentAnnotations[idx] = new TextRulerAnnotation(fs, this);
                        if (idx >= target.slotNames.length - 1) {
                            result.add(new TextRulerExample(this, currentAnnotations, true, target));
                            currentAnnotations = new TextRulerAnnotation[target.slotNames.length];
                            currentSlotIndex = 0;
                        } else {
                            currentSlotIndex = idx + 1;
                        }
                    }
                    it.moveToNext();
                }
                if (currentSlotIndex <= 0) break block15;
                result.add(new TextRulerExample(this, currentAnnotations, true, target));
                break block15;
            }
            if (target.isLeftCorrection() || target.isRightCorrection()) {
                TextRulerBasicLearner learner = target.getLearner();
                Set<String> filterSet = learner.getFilterSet();
                CAS testCAS = learner.getTestCAS();
                TextRulerStatisticsCollector c = new TextRulerStatisticsCollector();
                this.resetAndFillTestCAS(testCAS, target);
                CAS docCAS = this.getCAS();
                TypeSystem ts = docCAS.getTypeSystem();
                Type tokensRootType = ts.getType("org.apache.uima.ruta.type.ANY");
                AnalysisEngine analysisEngine = learner.getAnalysisEngine();
                try {
                    analysisEngine.process(testCAS);
                }
                catch (AnalysisEngineProcessException analysisEngineProcessException) {
                    // empty catch block
                }
                TextRulerTarget newTarget = new TextRulerTarget(target.slotNames, target.getLearner());
                newTarget.type = target.isLeftCorrection() ? TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY : TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY;
                this.createExamplesForTarget(newTarget);
                learner.compareOriginalDocumentWithTestCAS(this, testCAS, newTarget, c, true);
                List<TextRulerExample> correctTags = this.getPositiveExamples();
                ArrayList<TextRulerExample> wrongTags = new ArrayList<TextRulerExample>(c.getCoveredNegativeExamples());
                for (TextRulerExample wrongTag : wrongTags) {
                    List<AnnotationFS> left = TextRulerToolkit.getAnnotationsBeforePosition(docCAS, wrongTag.getAnnotation().getBegin(), target.getMaxShiftDistance(), TextRulerToolkit.getFilterSetWithSlotNames(target.slotNames, filterSet), tokensRootType);
                    List<AnnotationFS> right = TextRulerToolkit.getAnnotationsAfterPosition(docCAS, wrongTag.getAnnotation().getEnd(), target.getMaxShiftDistance() + 1, TextRulerToolkit.getFilterSetWithSlotNames(target.slotNames, filterSet), tokensRootType);
                    right.remove(0);
                    int leftDistance = 0;
                    TextRulerExample leftCorrectTag = null;
                    for (int i = left.size() - 1; i >= 0; --i) {
                        ++leftDistance;
                        TextRulerAnnotation needle = TextRulerToolkit.convertToTargetAnnotation(left.get(i), this, target, docCAS.getTypeSystem());
                        leftCorrectTag = TextRulerExampleDocument.exampleListContainsAnnotation(correctTags, needle);
                        if (leftCorrectTag != null) break;
                    }
                    int rightDistance = 0;
                    TextRulerExample rightCorrectTag = null;
                    for (AnnotationFS fs : right) {
                        ++rightDistance;
                        TextRulerAnnotation needle = TextRulerToolkit.convertToTargetAnnotation(fs, this, target, docCAS.getTypeSystem());
                        rightCorrectTag = TextRulerExampleDocument.exampleListContainsAnnotation(correctTags, needle);
                        if (rightCorrectTag == null) continue;
                        break;
                    }
                    TextRulerExample theCorrectTag = null;
                    theCorrectTag = rightDistance < leftDistance && rightCorrectTag != null ? rightCorrectTag : (rightDistance > leftDistance && leftCorrectTag != null ? leftCorrectTag : (target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY && rightCorrectTag != null ? rightCorrectTag : leftCorrectTag));
                    if (theCorrectTag == null) continue;
                    TextRulerToolkit.log("FOUND BAD EXAMPLE FOR SHIFTING !!");
                    TextRulerShiftExample shiftExample = new TextRulerShiftExample(this, wrongTag.getAnnotation(), theCorrectTag.getAnnotation(), true, target);
                    result.add(shiftExample);
                }
            } else {
                List<AnnotationFS> slots = TextRulerToolkit.extractAnnotationsForSlotName(aCas, createFromRawTypeName ? target.getSingleSlotRawTypeName() : target.getSingleSlotTypeName());
                for (AnnotationFS a : slots) {
                    result.add(new TextRulerExample(this, TextRulerToolkit.convertToTargetAnnotation(a, this, target, aCas.getTypeSystem()), true, target));
                }
            }
        }
        return result;
    }

    protected void createNegativeExamplesForTarget(TextRulerTarget target) {
    }

    public void createExamplesForTarget(TextRulerTarget target) {
        this.createPositiveExamplesForTarget(target);
        this.createNegativeExamplesForTarget(target);
    }

    public void clearCurrentExamples() {
        this.positiveExamples.clear();
        this.negativeExamples.clear();
    }

    public void resetAndFillTestCAS(CAS testCas, TextRulerTarget target) {
        testCas.reset();
        CAS docCas = this.getCAS();
        CasCopier cc = new CasCopier(docCas, testCas);
        testCas.setDocumentText(docCas.getDocumentText());
        TypeSystem ts = docCas.getTypeSystem();
        ArrayList<Type> slotTypes = new ArrayList<Type>();
        for (String s : target.getSlotTypeNames()) {
            slotTypes.add(ts.getType(s));
        }
        if (target.isBoundary()) {
            for (String s : target.slotNames) {
                slotTypes.add(ts.getType(s));
            }
        }
        for (AnnotationFS fs : docCas.getAnnotationIndex()) {
            if (slotTypes.contains(fs.getType()) || fs.getType().equals(docCas.getDocumentAnnotation().getType())) continue;
            FeatureStructure copyFs = cc.copyFs((FeatureStructure)fs);
            testCas.addFsToIndexes(copyFs);
        }
    }

    public String getCasFileName() {
        return this.casFileName;
    }

    public static void createBoundaryAnnotationsForCas(CAS aCas, String slotName, Set<String> tokenFilterSet) {
        List<AnnotationFS> slots = TextRulerToolkit.extractAnnotationsForSlotName(aCas, slotName);
        TypeSystem ts = aCas.getTypeSystem();
        for (AnnotationFS a : slots) {
            List<AnnotationFS> slotTokens = TextRulerToolkit.getAnnotationsWithinBounds(aCas, a.getBegin(), a.getEnd(), TextRulerToolkit.getFilterSetWithSlotName(slotName, tokenFilterSet), ts.getType("org.apache.uima.ruta.type.ANY"));
            if (slotTokens.isEmpty()) continue;
            AnnotationFS first = slotTokens.get(0);
            AnnotationFS last = slotTokens.get(slotTokens.size() - 1);
            Type typeLB = ts.getType(slotName + "START");
            aCas.addFsToIndexes((FeatureStructure)aCas.createAnnotation(typeLB, first.getBegin(), first.getEnd()));
            Type typeRB = ts.getType(slotName + "END");
            aCas.addFsToIndexes((FeatureStructure)aCas.createAnnotation(typeRB, last.getBegin(), last.getEnd()));
        }
    }

    public static void removeBoundaryAnnotationsFromCas(CAS aCas, String slotName) {
        AnnotationFS fs2;
        TypeSystem ts = aCas.getTypeSystem();
        Type startType = ts.getType(slotName + "START");
        Type endType = ts.getType(slotName + "END");
        ArrayList<AnnotationFS> removeList = new ArrayList<AnnotationFS>();
        FSIterator it = aCas.getAnnotationIndex(startType).iterator(true);
        while (it.isValid()) {
            fs2 = (AnnotationFS)it.get();
            removeList.add(fs2);
            it.moveToNext();
        }
        it = aCas.getAnnotationIndex(endType).iterator(true);
        while (it.isValid()) {
            fs2 = (AnnotationFS)it.get();
            removeList.add(fs2);
            it.moveToNext();
        }
        for (AnnotationFS fs2 : removeList) {
            aCas.removeFsFromIndexes((FeatureStructure)fs2);
        }
    }

    public static synchronized TextRulerExample exampleListContainsAnnotation(List<TextRulerExample> list, TextRulerAnnotation ann) {
        TextRulerExample needle = new TextRulerExample(null, ann, true, null);
        int index = Collections.binarySearch(list, needle, new Comparator<TextRulerExample>(){

            @Override
            public int compare(TextRulerExample o1, TextRulerExample o2) {
                TextRulerAnnotation afs1 = o1.getAnnotation();
                TextRulerAnnotation afs2 = o2.getAnnotation();
                if (afs1.getBegin() < afs2.getBegin()) {
                    return -1;
                }
                if (afs1.getBegin() > afs2.getBegin()) {
                    return 1;
                }
                return 0;
            }
        });
        if (index >= 0) {
            return list.get(index);
        }
        return null;
    }
}

