/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class GoTranslateVisitor
extends AbstractTranslateVisitor {
    private static final String GO_PACKAGE_NAME = "gremlingo.";

    public GoTranslateVisitor() {
        super("g");
    }

    public GoTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    @Override
    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(GoTranslateVisitor.removeFirstAndLastCharacters(dtString));
        this.sb.append("time.UnixMilli(" + dt.toInstant().toEpochMilli() + ")");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("math.Inf(-1)");
        } else {
            this.sb.append("math.Inf(1)");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        int lastCharIndex;
        String integerLiteral = ctx.getText().toLowerCase();
        char lastChar = integerLiteral.charAt(lastCharIndex = integerLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            this.sb.append(integerLiteral, 0, lastCharIndex);
        } else {
            this.sb.append(integerLiteral);
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        int lastCharIndex;
        String floatLiteral = ctx.getText().toLowerCase();
        char lastChar = floatLiteral.charAt(lastCharIndex = floatLiteral.length() - 1);
        if (Character.isAlphabetic(lastChar)) {
            this.sb.append(floatLiteral, 0, lastCharIndex);
        } else {
            this.sb.append(floatLiteral);
        }
        return null;
    }

    @Override
    public Void visitGenericLiteralRange(GremlinParser.GenericLiteralRangeContext ctx) {
        throw new TranslatorException("Go does not support range literals");
    }

    @Override
    public Void visitGenericLiteralSet(GremlinParser.GenericLiteralSetContext ctx) {
        this.sb.append(GO_PACKAGE_NAME);
        this.sb.append("NewSimpleSet(");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitGenericLiteralCollection(GremlinParser.GenericLiteralCollectionContext ctx) {
        this.sb.append("[]interface{}{");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("}");
        return null;
    }

    @Override
    public Void visitGenericLiteralMap(GremlinParser.GenericLiteralMapContext ctx) {
        this.sb.append("map[interface{}]interface{}{");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append(" }");
        return null;
    }

    @Override
    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        boolean isKeyWrappedInParens = ctx.getChild(0).getText().equals("(");
        if (ctx.getChild(0) instanceof TerminalNode && !isKeyWrappedInParens) {
            this.handleStringLiteralText(ctx.getChild(0).getText());
        } else {
            int indexOfActualKey = isKeyWrappedInParens ? 1 : 0;
            this.visit(ctx.getChild(indexOfActualKey));
        }
        this.sb.append(": ");
        int indexOfValue = isKeyWrappedInParens ? 4 : 2;
        this.visit(ctx.getChild(indexOfValue));
        return null;
    }

    @Override
    public Void visitStringNullableLiteral(GremlinParser.StringNullableLiteralContext ctx) {
        if (ctx.getText().equals("null")) {
            this.sb.append("nil");
        } else {
            String text = GoTranslateVisitor.removeFirstAndLastCharacters(ctx.getText());
            this.handleStringLiteralText(text);
        }
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("math.NaN()");
        return null;
    }

    @Override
    public Void visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        this.sb.append("nil");
        return null;
    }

    @Override
    public Void visitStructureVertex(GremlinParser.StructureVertexContext ctx) {
        this.sb.append(GO_PACKAGE_NAME).append("Vertex{Element{");
        this.visit(ctx.getChild(3));
        this.sb.append(", ");
        this.visit(ctx.getChild(5));
        this.sb.append("}}");
        return null;
    }

    @Override
    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append(GO_PACKAGE_NAME).append(ctx.getText()).append("()");
        } else {
            String strategyName = ctx.getChild(0).getText().equals("new") ? ctx.getChild(1).getText() : ctx.getChild(0).getText();
            this.sb.append(GO_PACKAGE_NAME).append(strategyName).append("(");
            this.sb.append(GO_PACKAGE_NAME + strategyName + "Config{");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            for (int ix = 0; ix < configs.size(); ++ix) {
                this.visit((ParseTree)configs.get(ix));
                if (ix >= configs.size() - 1) continue;
                this.sb.append(", ");
            }
            this.sb.append("})");
        }
        return null;
    }

    @Override
    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        int ix;
        this.sb.append(SymbolHelper.toGo(ctx.getChild(0).getText()));
        this.sb.append(": ");
        this.visit(ctx.getChild(2));
        if (ctx.getChild(0).getText().equals("readPartitions") && (ix = this.sb.lastIndexOf("ReadPartitions: [")) > 0) {
            int endIx = this.sb.indexOf("\"}", ix);
            this.sb.replace(endIx, endIx + 2, "\")");
            this.sb.replace(ix, ix + "ReadPartitions: []interface{}{".length(), "ReadPartitions: gremlingo.NewSimpleSet(");
        }
        return null;
    }

    @Override
    public Void visitTraversalCardinality(GremlinParser.TraversalCardinalityContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.appendExplicitNaming(ctx.getText(), VertexProperty.Cardinality.class.getSimpleName());
        } else {
            String txt = ctx.getChild(0).getText();
            if (txt.startsWith("Cardinality.")) {
                txt = txt.replaceFirst("Cardinality.", "");
            }
            this.appendExplicitNaming(txt, "CardinalityValue");
            this.appendStepOpen();
            this.visit(ctx.getChild(2));
            this.appendStepClose();
        }
        return null;
    }

    @Override
    protected void visitP(ParserRuleContext ctx, Class<?> clazzOfP, String methodName) {
        this.sb.append(GO_PACKAGE_NAME);
        super.visitP(ctx, clazzOfP, methodName);
    }

    @Override
    protected String processGremlinSymbol(String step) {
        return SymbolHelper.toGo(step);
    }

    @Override
    protected void appendExplicitNaming(String txt, String prefix) {
        this.sb.append(GO_PACKAGE_NAME);
        super.appendExplicitNaming(txt, prefix);
    }

    @Override
    protected void appendAnonymousSpawn() {
        this.sb.append(GO_PACKAGE_NAME).append("T__.");
    }

    static final class SymbolHelper {
        private static final Map<String, String> TO_GO_MAP = new HashMap<String, String>();
        private static final Map<String, String> FROM_GO_MAP = new HashMap<String, String>();

        private SymbolHelper() {
        }

        public static String toGo(String symbol) {
            return TO_GO_MAP.getOrDefault(symbol, StringUtils.capitalize((String)symbol));
        }

        public static String toJava(String symbol) {
            return FROM_GO_MAP.getOrDefault(symbol, StringUtils.uncapitalize((String)symbol));
        }

        static {
            TO_GO_MAP.put("OUT", "Out");
            TO_GO_MAP.put("IN", "In");
            TO_GO_MAP.put("BOTH", "Both");
            TO_GO_MAP.put("WithOptions", "gremlingo.WithOptions");
            TO_GO_MAP.put("IO", "gremlingo.IO");
            TO_GO_MAP.put("__", "gremlingo.T__");
            TO_GO_MAP.forEach((k, v) -> FROM_GO_MAP.put((String)v, (String)k));
        }
    }
}

