/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;

public class SlowNodeAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private static final Log LOG = LogFactory.getLog(SlowNodeAnalyzer.class);
    private static final String[] headers = new String[]{"nodeName", "noOfTasksExecuted", "noOfKilledTasks", "noOfFailedTasks", "avgSucceededTaskExecutionTime", "avgKilledTaskExecutionTime", "avgFailedTaskExecutionTime", "avgHDFSBytesRead", "avgHDFSBytesWritten", "avgFileBytesRead", "avgFileBytesWritten", "avgGCTimeMillis", "avgCPUTimeMillis"};
    private final CSVResult csvResult = new CSVResult(headers);
    private final Configuration config;

    public SlowNodeAnalyzer(Configuration config) {
        this.config = config;
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        Multimap nodeDetails = dagInfo.getNodeDetails();
        for (String nodeName : nodeDetails.keySet()) {
            LinkedList record = Lists.newLinkedList();
            Collection taskAttemptInfos = nodeDetails.get((Object)nodeName);
            record.add(nodeName);
            record.add(taskAttemptInfos.size() + "");
            record.add(this.getNumberOfTasks(taskAttemptInfos, TaskAttemptState.KILLED) + "");
            record.add(this.getNumberOfTasks(taskAttemptInfos, TaskAttemptState.FAILED) + "");
            Iterable<TaskAttemptInfo> succeedTasks = this.getFilteredTaskAttempts(taskAttemptInfos, TaskAttemptState.SUCCEEDED);
            record.add(this.getAvgTaskExecutionTime(succeedTasks) + "");
            Iterable<TaskAttemptInfo> killedTasks = this.getFilteredTaskAttempts(taskAttemptInfos, TaskAttemptState.KILLED);
            record.add(this.getAvgTaskExecutionTime(killedTasks) + "");
            Iterable<TaskAttemptInfo> failedTasks = this.getFilteredTaskAttempts(taskAttemptInfos, TaskAttemptState.FAILED);
            record.add(this.getAvgTaskExecutionTime(failedTasks) + "");
            record.add(this.getAvgCounter(taskAttemptInfos, FileSystemCounter.class.getName(), FileSystemCounter.HDFS_BYTES_READ.name()) + "");
            record.add(this.getAvgCounter(taskAttemptInfos, FileSystemCounter.class.getName(), FileSystemCounter.HDFS_BYTES_WRITTEN.name()) + "");
            record.add(this.getAvgCounter(taskAttemptInfos, FileSystemCounter.class.getName(), FileSystemCounter.FILE_BYTES_READ.name()) + "");
            record.add(this.getAvgCounter(taskAttemptInfos, FileSystemCounter.class.getName(), FileSystemCounter.FILE_BYTES_WRITTEN.name()) + "");
            record.add(this.getAvgCounter(taskAttemptInfos, TaskCounter.class.getName(), TaskCounter.GC_TIME_MILLIS.name()) + "");
            record.add(this.getAvgCounter(taskAttemptInfos, TaskCounter.class.getName(), TaskCounter.CPU_MILLISECONDS.name()) + "");
            this.csvResult.addRecord(record.toArray(new String[record.size()]));
        }
    }

    private Iterable<TaskAttemptInfo> getFilteredTaskAttempts(Collection<TaskAttemptInfo> taskAttemptInfos, final TaskAttemptState status) {
        return Iterables.filter(taskAttemptInfos, (Predicate)new Predicate<TaskAttemptInfo>(){

            public boolean apply(TaskAttemptInfo input) {
                return input.getStatus().equalsIgnoreCase(status.toString());
            }
        });
    }

    private float getAvgTaskExecutionTime(Iterable<TaskAttemptInfo> taskAttemptInfos) {
        long totalTime = 0L;
        int size = 0;
        for (TaskAttemptInfo attemptInfo : taskAttemptInfos) {
            totalTime += attemptInfo.getTimeTaken();
            ++size;
        }
        return size > 0 ? (float)totalTime * 1.0f / (float)size : 0.0f;
    }

    private int getNumberOfTasks(Collection<TaskAttemptInfo> taskAttemptInfos, TaskAttemptState status) {
        int tasks = 0;
        for (TaskAttemptInfo attemptInfo : taskAttemptInfos) {
            if (!attemptInfo.getStatus().equalsIgnoreCase(status.toString())) continue;
            ++tasks;
        }
        return tasks;
    }

    private float getAvgCounter(Collection<TaskAttemptInfo> taskAttemptInfos, String counterGroupName, String counterName) {
        long total = 0L;
        int taskCount = 0;
        for (TaskAttemptInfo attemptInfo : taskAttemptInfos) {
            TezCounters tezCounters = attemptInfo.getTezCounters();
            TezCounter counter = tezCounters.findCounter(counterGroupName, counterName);
            if (counter != null) {
                total += counter.getValue();
                ++taskCount;
                continue;
            }
            LOG.info((Object)("Could not find counterGroupName=" + counterGroupName + ", counter=" + counterName + " in " + attemptInfo));
        }
        return taskCount > 0 ? (float)total * 1.0f / (float)taskCount : 0.0f;
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Slow Node Analyzer";
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Analyze node details for the DAG.").append("\n");
        sb.append("This could be used to find out the set of nodes where the tasks are taking more time on average.").append("\n");
        sb.append("This could be used to find out the set of nodes where the tasks are taking more time on average and to understand whether too many tasks got scheduled on a node.").append("\n");
        sb.append("One needs to combine the task execution time with other metrics like bytes read/written etc to get better idea of bad nodes. In order to understand the slow nodes due to network, it might be worthwhile to consider the shuffle performance analyzer tool in tez-tools").append("\n");
        return sb.toString();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        SlowNodeAnalyzer analyzer = new SlowNodeAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

