/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tools.javadoc.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.tez.tools.javadoc.model.Config;
import org.apache.tez.tools.javadoc.model.ConfigProperty;
import org.apache.tez.tools.javadoc.util.Writer;

public class XmlWriter
extends Writer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Config config) throws IOException {
        String fileName;
        PrintWriter out = null;
        if (config.configName == null || config.configName.isEmpty()) {
            throw new RuntimeException("Config Name is null or empty");
        }
        String string = fileName = config.templateName == null || config.templateName.isEmpty() ? config.configName : config.templateName;
        if (!fileName.endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        try {
            File file = new File(fileName);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println();
            out.println("<!-- WARNING: THIS IS A GENERATED TEMPLATE PURELY FOR DOCUMENTATION PURPOSES");
            out.println(" AND SHOULD NOT BE USED AS A CONFIGURATION FILE FOR TEZ -->");
            out.println();
            out.println("<configuration>");
            for (ConfigProperty configProperty : config.configProperties.values()) {
                if (!this.isValidConfigProperty(configProperty)) continue;
                out.println();
                out.println("  <property>");
                out.println("    <name>" + configProperty.propertyName + "</name>");
                if (configProperty.defaultValue != null && !configProperty.defaultValue.isEmpty()) {
                    out.println("    <defaultValue>" + configProperty.defaultValue + "</defaultValue>");
                }
                if (configProperty.description != null && !configProperty.description.isEmpty()) {
                    out.println("    <description>" + StringEscapeUtils.escapeXml((String)configProperty.description) + "</description>");
                }
                if (configProperty.type != null && !configProperty.type.isEmpty()) {
                    out.println("    <type>" + configProperty.type + "</type>");
                }
                if (configProperty.isUnstable) {
                    out.println("    <unstable>true</unstable>");
                }
                if (configProperty.isEvolving) {
                    out.println("    <evolving>true</evolving>");
                }
                if (configProperty.isPrivate) {
                    out.println("    <private>true</private>");
                }
                out.println("  </property>");
            }
            out.println();
            out.println("</configuration>");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

