/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.tez.common.web;

import org.apache.hadoop.yarn.webapp.MimeType;
import org.eclipse.jetty.servlet.DefaultServlet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * Servlet to serve files generated by {@link ProfileServlet}.
 */
public class ProfileOutputServlet extends DefaultServlet {
  public static final String FILE_QUERY_PARAM = "file";

  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    String queriedFile = request.getParameter(FILE_QUERY_PARAM);
    if (queriedFile == null) {
      writeMessage(response, "Run the profiler to be able to receive its output");
      return;
    }
    File outputFile = new File(ProfileServlet.OUTPUT_DIR, queriedFile);
    if (!outputFile.exists()) {
      writeMessage(response, "Requested file does not exist: " + queriedFile);
      return;
    }
    if (outputFile.length() < 100) {
      response.setIntHeader("Refresh", 2);
      writeMessage(response, "This page auto-refreshes every 2 seconds until output file is ready...");
      return;
    }
    response.setContentType(MimeType.HTML);
    response.getOutputStream().write(Files.readAllBytes(Paths.get(outputFile.getPath())));
    response.getOutputStream().flush();
    response.getOutputStream().close();
  }

  private void writeMessage(HttpServletResponse response, String message) throws IOException {
    response.setContentType(MimeType.TEXT);
    PrintWriter out = response.getWriter();
    out.println(message);
    out.close();
  }
}
