/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.Objects;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.OutputCommitterContext;

public class OutputCommitterContextImpl
implements OutputCommitterContext {
    private final ApplicationId applicationId;
    private final int dagAttemptNumber;
    private final String dagName;
    private final String vertexName;
    private final int vertexIdx;
    private final RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> output;

    public OutputCommitterContextImpl(ApplicationId applicationId, int dagAttemptNumber, String dagName, String vertexName, RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> output, int vertexIdx) {
        Objects.requireNonNull(applicationId, "applicationId is null");
        Objects.requireNonNull(dagName, "dagName is null");
        Objects.requireNonNull(vertexName, "vertexName is null");
        Objects.requireNonNull(output, "output is null");
        this.applicationId = applicationId;
        this.dagAttemptNumber = dagAttemptNumber;
        this.dagName = dagName;
        this.vertexName = vertexName;
        this.output = output;
        this.vertexIdx = vertexIdx;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public int getDAGAttemptNumber() {
        return this.dagAttemptNumber;
    }

    public String getDAGName() {
        return this.dagName;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public String getOutputName() {
        return this.output.getName();
    }

    public UserPayload getOutputUserPayload() {
        return ((OutputDescriptor)this.output.getIODescriptor()).getUserPayload();
    }

    public UserPayload getUserPayload() {
        return ((OutputCommitterDescriptor)this.output.getControllerDescriptor()).getUserPayload();
    }

    public int getVertexIndex() {
        return this.vertexIdx;
    }
}

