/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.lops.MapMultChain;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class MMChainFEDInstruction
extends UnaryFEDInstruction {
    private final MapMultChain.ChainType _type;

    public MMChainFEDInstruction(CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, MapMultChain.ChainType type, int k, String opcode, String istr) {
        super(FEDInstruction.FEDType.MMChain, null, in1, in2, in3, out, opcode, istr);
        this._type = type;
    }

    public MapMultChain.ChainType getMMChainType() {
        return this._type;
    }

    public static MMChainFEDInstruction parseInstruction(MMChainCPInstruction inst, ExecutionContext ec) {
        MatrixObject mo = ec.getMatrixObject(inst.input1);
        if (mo.isFederated(FTypes.FType.ROW)) {
            return MMChainFEDInstruction.parseInstruction(inst);
        }
        return null;
    }

    private static MMChainFEDInstruction parseInstruction(MMChainCPInstruction instr) {
        return new MMChainFEDInstruction(instr.input1, instr.input2, instr.input3, instr.output, instr.getMMChainType(), instr.getNumThreads(), instr.getOpcode(), instr.getInstructionString());
    }

    public static MMChainFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5, 6);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        if (parts.length == 6) {
            CPOperand out = new CPOperand(parts[3]);
            MapMultChain.ChainType type = MapMultChain.ChainType.valueOf(parts[4]);
            int k = Integer.parseInt(parts[5]);
            return new MMChainFEDInstruction(in1, in2, null, out, type, k, opcode, str);
        }
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        MapMultChain.ChainType type = MapMultChain.ChainType.valueOf(parts[5]);
        int k = Integer.parseInt(parts[6]);
        return new MMChainFEDInstruction(in1, in2, in3, out, type, k, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixLineagePair mo3;
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        MatrixLineagePair mo2 = ec.getMatrixLineagePair(this.input2);
        MatrixLineagePair matrixLineagePair = mo3 = this._type.isWeighted() ? ec.getMatrixLineagePair(this.input3) : null;
        if (!mo1.isFederated()) {
            throw new DMLRuntimeException("Federated MMChain: Federated main input expected, but invoked w/ " + mo1.isFederated() + " " + mo2.isFederated());
        }
        FederatedRequest fr1 = mo1.getFedMapping().broadcast(mo2);
        if (this._type.isWeighted() && mo3.isFederated() && mo1.getFedMapping().isAligned(mo3.getFedMapping(), FTypes.AlignType.ROW)) {
            FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{mo1.getFedMapping().getID(), fr1.getID(), mo3.getFedMapping().getID()});
            FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
            FederatedRequest fr4 = mo1.getFedMapping().cleanup(this.getTID(), fr2.getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3, fr4);
            MatrixBlock ret = FederationUtils.aggAdd(tmp);
            ec.setMatrixOutput(this.output.getName(), ret);
        } else if (!this._type.isWeighted()) {
            FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), fr1.getID()});
            FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
            FederatedRequest fr4 = mo1.getFedMapping().cleanup(this.getTID(), fr2.getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3, fr4);
            MatrixBlock ret = FederationUtils.aggAdd(tmp);
            ec.setMatrixOutput(this.output.getName(), ret);
        } else {
            FederatedRequest[] fr0 = mo1.getFedMapping().broadcastSliced(mo3, false);
            FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{mo1.getFedMapping().getID(), fr1.getID(), fr0[0].getID()});
            FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
            FederatedRequest fr4 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID(), fr2.getID());
            Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr0, new FederatedRequest[]{fr1, fr2, fr3, fr4});
            MatrixBlock ret = FederationUtils.aggAdd(tmp);
            ec.setMatrixOutput(this.output.getName(), ret);
        }
    }
}

