/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.ACount;

public abstract class ACountHashMap<T>
implements Cloneable {
    protected static final Log LOG = LogFactory.getLog((String)ACountHashMap.class.getName());
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.8f;
    protected static final int shortCutSize = 10;
    protected int size;
    protected ACount<T>[] data;

    public ACountHashMap() {
        this.data = this.create(1);
        this.size = 0;
    }

    public ACountHashMap(int arrSize) {
        this.data = arrSize < 10 ? this.create(1) : this.create(arrSize += (arrSize = (int)((double)arrSize * 1.2499999813735487)) % 2 == 0 ? 1 : 0);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public final int increment(T key) {
        return this.increment(key, 1);
    }

    public final int increment(double key) {
        return this.increment(key, 1);
    }

    public synchronized int increment(T key, int count) {
        int ix = this.data.length < 10 ? 0 : this.hash(key) % this.data.length;
        try {
            return this.increment(key, ix, count);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (ix < 0) {
                return this.increment(key, 0, count);
            }
            throw new RuntimeException(e);
        }
    }

    private final int increment(T key, int ix, int count) throws ArrayIndexOutOfBoundsException {
        ACount<T> l = this.data[ix];
        if (l == null) {
            this.data[ix] = this.create(key, this.size);
            return this.size++;
        }
        ACount<T> v = l.inc(key, count, this.size);
        if (v.id == this.size) {
            ++this.size;
            this.resize();
            return this.size - 1;
        }
        return v.id;
    }

    public final synchronized int increment(double key, int count) {
        int ix = this.data.length < 10 ? 0 : ACount.DCounts.hashIndex(key) % this.data.length;
        try {
            return this.increment(key, ix, count);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (ix < 0) {
                return this.increment(key, 0, count);
            }
            throw new RuntimeException(e);
        }
    }

    private final int increment(double key, int ix, int count) throws ArrayIndexOutOfBoundsException {
        ACount<T> l = this.data[ix];
        if (l == null) {
            this.data[ix] = this.create(key, this.size);
            return this.size++;
        }
        ACount<T> v = l.inc(key, count, this.size);
        if (v.id == this.size) {
            ++this.size;
            this.resize();
            return this.size - 1;
        }
        return v.id;
    }

    public int get(T key) {
        return this.getC(key).count;
    }

    public int getId(T key) {
        return this.getC(key).id;
    }

    public ACount<T> getC(T key) {
        int ix = this.data.length < 10 ? 0 : this.hash(key) % this.data.length;
        try {
            ACount<T> l = this.data[ix];
            return l != null ? l.get(key) : null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (ix < 0) {
                ACount<T> l = this.data[0];
                return l != null ? l.get(key) : null;
            }
            throw new RuntimeException(e);
        }
    }

    public int getOrDefault(T key, int def) {
        ACount<T> e = this.getC(key);
        return e == null ? def : e.count;
    }

    public final ACount<T>[] extractValues() {
        ACount<T>[] ret = this.create(this.size);
        int i = 0;
        ACount<T>[] aCountArray = this.data;
        int n = aCountArray.length;
        for (int j = 0; j < n; ++j) {
            for (ACount<T> e = aCountArray[j]; e != null; e = e.next()) {
                ret[i++] = e;
            }
        }
        return ret;
    }

    public T getMostFrequent() {
        T f = null;
        int fq = 0;
        ACount<T>[] aCountArray = this.data;
        int n = aCountArray.length;
        for (int i = 0; i < n; ++i) {
            for (ACount<T> e = aCountArray[i]; e != null; e = e.next()) {
                if (e.count <= fq) continue;
                fq = e.count;
                f = e.key();
            }
        }
        return f;
    }

    private void resize() {
        if ((float)this.size >= 0.8f * (float)this.data.length && this.size > 10) {
            this.resize(Math.max(this.data.length, 10) * 2 + 1);
        }
    }

    private void resize(int underlying_size) {
        ACount<T>[] olddata = this.data;
        this.data = this.create(underlying_size);
        for (ACount<T> e : olddata) {
            this.appendValue(e);
        }
    }

    protected void appendValue(ACount<T> ent) {
        if (ent != null) {
            this.appendValue(ent.next());
            ent.setNext(null);
            int ix = this.hash(ent.key()) % this.data.length;
            try {
                this.appendValue(ent, ix);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (ix < 0) {
                    this.appendValue(ent, 0);
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void appendValue(ACount<T> ent, int ix) {
        ACount<T> l = this.data[ix];
        this.data[ix] = ent;
        ent.setNext(l);
    }

    public void sortBuckets() {
        if (this.size > 10) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == null) continue;
                this.data[i] = this.data[i].sort();
            }
        }
    }

    public void reset(int size) {
        this.data = this.create(size);
        this.size = 0;
    }

    protected abstract ACount<T>[] create(int var1);

    protected abstract int hash(T var1);

    protected abstract ACount<T> create(T var1, int var2);

    protected ACount<T> create(double key, int id) {
        throw new NotImplementedException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            sb.append(", " + this.data[i]);
        }
        return sb.toString();
    }
}

