/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.cocode.ColIndexes;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class MemorizerV2 {
    private final AComEst _sEst;
    private final Map<ColIndexes, CompressedSizeInfoColGroup>[] mem;
    private int st1 = 0;
    private int st2 = 0;
    private int st3 = 0;
    private int st4 = 0;

    public MemorizerV2(AComEst sEst, int nCol) {
        this._sEst = sEst;
        this.mem = new Map[nCol];
    }

    public void put(CompressedSizeInfoColGroup g) {
        this.put(new ColIndexes(g.getColumns()), g);
    }

    public void put(ColIndexes key, CompressedSizeInfoColGroup val) {
        IColIndex gi = key._indexes;
        int bucketID = gi.get(0);
        Map<ColIndexes, CompressedSizeInfoColGroup> bucket = this.mem[bucketID];
        if (bucket == null) {
            bucket = this.mem[bucketID] = new HashMap<ColIndexes, CompressedSizeInfoColGroup>();
        }
        bucket.put(key, val);
    }

    public CompressedSizeInfoColGroup get(ColIndexes c) {
        return this.mem[c._indexes.get(0)].get(c);
    }

    public void remove(ColIndexes c1, ColIndexes c2) {
        this.mem[c1._indexes.get((int)0)] = null;
        this.mem[c2._indexes.get((int)0)] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressedSizeInfoColGroup getOrCreate(ColIndexes cI, ColIndexes c1, ColIndexes c2) {
        CompressedSizeInfoColGroup g = this.get(cI);
        ++this.st2;
        if (g == null) {
            CompressedSizeInfoColGroup left = this.get(c1);
            CompressedSizeInfoColGroup right = this.get(c2);
            if (left != null && right != null) {
                ++this.st3;
                g = this._sEst.combine(cI._indexes, left, right);
                if (g != null && g.getNumVals() < 0) {
                    throw new DMLCompressionException("Combination returned less distinct values on: \n" + left + "\nand\n" + right + "\nEq\n" + g);
                }
                MemorizerV2 memorizerV2 = this;
                synchronized (memorizerV2) {
                    this.put(cI, g);
                }
            }
        }
        return g;
    }

    public void incst1() {
        ++this.st1;
    }

    public void incst4() {
        ++this.st4;
    }

    public String stats() {
        return " possible: " + this.st1 + " requests: " + this.st2 + " combined: " + this.st3 + " outSecond: " + this.st4;
    }

    public void resetStats() {
        this.st1 = 0;
        this.st2 = 0;
        this.st3 = 0;
        this.st4 = 0;
    }

    public String toString() {
        return this.mem.toString();
    }
}

