/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HashMapLongInt
implements Iterable<KV> {
    protected static final Log LOG = LogFactory.getLog((String)HashMapLongInt.class.getName());
    protected long[][] keys;
    protected int[][] values;
    protected int size = 0;

    public HashMapLongInt(int arrSize) {
        this.keys = this.createKeys(arrSize);
        this.values = this.createValues(arrSize);
    }

    public int size() {
        return this.size;
    }

    public int putIfAbsent(long key, int value) {
        int ix = this.hash(key);
        if (this.keys[ix] == null) {
            return this.createBucket(ix, key, value);
        }
        return this.addToBucket(ix, key, value);
    }

    public int get(long key) {
        int ix = this.hash(key);
        long[] bucketKeys = this.keys[ix];
        if (bucketKeys != null) {
            for (int i = 0; i < bucketKeys.length; ++i) {
                if (bucketKeys[i] != key) continue;
                return this.values[ix][i];
            }
        }
        return -1;
    }

    private int addToBucket(int ix, long key, int value) {
        long[] bucketKeys = this.keys[ix];
        for (int i = 0; i < bucketKeys.length; ++i) {
            if (bucketKeys[i] == key) {
                return this.values[ix][i];
            }
            if (bucketKeys[i] != -1L) continue;
            bucketKeys[i] = key;
            this.values[ix][i] = value;
            ++this.size;
            return -1;
        }
        return this.reallocateBucket(ix, key, value);
    }

    private int reallocateBucket(int ix, long key, int value) {
        long[] bucketKeys = this.keys[ix];
        int len = bucketKeys.length;
        long[] newBucketKeys = new long[len * 2];
        int[] newBucketValues = new int[len * 2];
        System.arraycopy(bucketKeys, 0, newBucketKeys, 0, len);
        System.arraycopy(this.values[ix], 0, newBucketValues, 0, len);
        Arrays.fill(newBucketKeys, len + 1, newBucketKeys.length, -1L);
        newBucketKeys[len] = key;
        newBucketValues[len] = value;
        this.keys[ix] = newBucketKeys;
        this.values[ix] = newBucketValues;
        ++this.size;
        return -1;
    }

    private int createBucket(int ix, long key, int value) {
        this.keys[ix] = new long[4];
        this.values[ix] = new int[4];
        this.keys[ix][0] = key;
        this.values[ix][0] = value;
        this.keys[ix][1] = -1L;
        this.keys[ix][2] = -1L;
        this.keys[ix][3] = -1L;
        ++this.size;
        return -1;
    }

    protected long[][] createKeys(int size) {
        return new long[size][];
    }

    protected int[][] createValues(int size) {
        return new int[size][];
    }

    protected int hash(long key) {
        return Long.hashCode(key) % this.keys.length;
    }

    @Override
    public Iterator<KV> iterator() {
        return new Itt();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            sb.append(String.format("\nB:%d: ", i));
            for (int j = 0; j < this.keys[i].length; ++j) {
                if (this.keys[i][j] == -1L) continue;
                sb.append(String.format("%d->%d, ", this.keys[i][j], this.values[i][j]));
            }
        }
        return sb.delete(sb.length() - 2, sb.length()).toString();
    }

    public class KV {
        public long k;
        public int v;

        private KV(long k, int v) {
            this.k = k;
            this.v = v;
        }

        protected KV set(long k, int v) {
            this.k = k;
            this.v = v;
            return this;
        }
    }

    private class Itt
    implements Iterator<KV> {
        private final int lastBucket;
        private final int lastCell;
        private int bucketId = 0;
        private int bucketCell = 0;
        private KV tmp = new KV(-1L, -1);

        protected Itt() {
            if (HashMapLongInt.this.size == 0) {
                this.lastBucket = -1;
                this.lastCell = -1;
            } else {
                int tmpLastBucket = HashMapLongInt.this.keys.length - 1;
                long[] bucket = HashMapLongInt.this.keys[tmpLastBucket];
                while ((bucket = HashMapLongInt.this.keys[tmpLastBucket]) == null) {
                    --tmpLastBucket;
                }
                int tmpLastCell = bucket.length - 1;
                while (bucket[tmpLastCell] == -1L) {
                    --tmpLastCell;
                }
                this.lastBucket = tmpLastBucket;
                this.lastCell = tmpLastCell;
            }
        }

        @Override
        public boolean hasNext() {
            return this.lastBucket != -1 && (this.bucketId < this.lastBucket || this.bucketId == this.lastBucket && this.bucketCell <= this.lastCell);
        }

        @Override
        public KV next() {
            long[] bucket = HashMapLongInt.this.keys[this.bucketId];
            if (bucket != null && (this.bucketCell >= bucket.length || bucket[this.bucketCell] == -1L)) {
                ++this.bucketId;
                this.bucketCell = 0;
            }
            while ((bucket = HashMapLongInt.this.keys[this.bucketId]) == null) {
                bucket = HashMapLongInt.this.keys[this.bucketId++];
            }
            this.tmp.set(bucket[this.bucketCell], HashMapLongInt.this.values[this.bucketId][this.bucketCell]);
            ++this.bucketCell;
            return this.tmp;
        }
    }
}

