/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class MatMultCP
extends Lop {
    private int numThreads = -1;
    private boolean isLeftTransposed;
    private boolean isRightTransposed;
    private boolean useTranspose;

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this(input1, input2, dt, vt, et, 1);
    }

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k) {
        super(Lop.Type.MatMultCP, dt, vt);
        this.init(input1, input2, dt, vt, et);
        this.numThreads = k;
    }

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et, boolean isLeftTransposed, boolean isRightTransposed) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, dt, vt, et);
        this.isLeftTransposed = isLeftTransposed;
        this.isRightTransposed = isRightTransposed;
        this.useTranspose = true;
    }

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et, int k, boolean isLeftTransposed, boolean isRightTransposed) {
        this(input1, input2, dt, vt, et, k);
        this.isLeftTransposed = isLeftTransposed;
        this.isRightTransposed = isRightTransposed;
        this.useTranspose = true;
    }

    private void init(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: ba+*";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        String ret = null;
        ret = !this.useTranspose ? InstructionUtils.concatOperands(this.getExecType().name(), Opcodes.MMULT.toString(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), String.valueOf(this.numThreads)) : InstructionUtils.concatOperands(this.getExecType().name(), Opcodes.MMULT.toString(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), String.valueOf(this.numThreads), String.valueOf(this.isLeftTransposed), String.valueOf(this.isRightTransposed));
        if (this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, this._fedOutput.name());
        }
        return ret;
    }
}

