/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import org.apache.sysds.common.Types;

public class MappingProperties {
    private RepresentationProperties representationProperties;
    private RecordProperties recordProperties;
    private DataProperties dataProperties;
    private Object patternValue;
    private Types.ValueType patternValueType;

    public void setSymmetricRepresentation() {
        this.representationProperties = RepresentationProperties.SYMMETRIC;
    }

    public void setSkewSymmetricRepresentation() {
        this.representationProperties = RepresentationProperties.SKEWSYMMETRIC;
    }

    public void setPatternRepresentation(Types.ValueType valueType, Object value) {
        this.representationProperties = RepresentationProperties.PATTERN;
        this.patternValueType = valueType;
        this.patternValue = value;
    }

    public void setTypicalRepresentation() {
        this.representationProperties = RepresentationProperties.TYPICAL;
    }

    public void setArrayColWiseRepresentation() {
        this.representationProperties = RepresentationProperties.ARRAYCOLWISE;
    }

    public void setArrayRowWiseRepresentation() {
        this.representationProperties = RepresentationProperties.ARRAYROWWISE;
    }

    public void setDataFullExist() {
        this.dataProperties = DataProperties.FULLEXIST;
    }

    public void setDataNotExist() {
        this.dataProperties = DataProperties.NOTEXIST;
    }

    public void setDataPartiallyExist() {
        this.dataProperties = DataProperties.PARTIALLYEXIST;
    }

    public void setRecordSingleLine() {
        this.recordProperties = RecordProperties.SINGLELINE;
    }

    public void setRecordMultiLine() {
        this.recordProperties = RecordProperties.MULTILINE;
    }

    public boolean isRepresentation() {
        return this.representationProperties != null;
    }

    public RepresentationProperties getRepresentationProperties() {
        return this.representationProperties;
    }

    public RecordProperties getRecordProperties() {
        return this.recordProperties;
    }

    public DataProperties getDataProperties() {
        return this.dataProperties;
    }

    public Object getPatternValue() {
        return this.patternValue;
    }

    public Types.ValueType getPatternValueType() {
        return this.patternValueType;
    }

    public static enum DataProperties {
        FULLEXIST,
        PARTIALLYEXIST,
        NOTEXIST;


        public String toString() {
            return this.name().toUpperCase();
        }
    }

    public static enum RecordProperties {
        SINGLELINE,
        MULTILINE;


        public String toString() {
            return this.name().toUpperCase();
        }
    }

    public static enum RepresentationProperties {
        TYPICAL,
        SYMMETRIC,
        SKEWSYMMETRIC,
        PATTERN,
        ARRAYCOLWISE,
        ARRAYROWWISE;


        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

