/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.federated.ExecutionContextMap;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedLookupTable;
import org.apache.sysds.runtime.controlprogram.federated.FederatedReadCache;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandler;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkloadAnalyzer;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDHandler;

public class FederatedLocalData
extends FederatedData {
    protected static final Logger log = Logger.getLogger(FederatedWorkerHandler.class);
    private static final FederatedLookupTable _flt = new FederatedLookupTable();
    private static final FederatedReadCache _frc = new FederatedReadCache();
    private static final FederatedWorkloadAnalyzer _fan = FederatedLocalData.initAnalyzer();
    private final FederatedWorkerHandler _fwh = new FederatedWorkerHandler(_flt, _frc, _fan);
    private final CacheableData<?> _data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederatedLocalData(long id, CacheableData<?> data) {
        super(data.getDataType(), null, data.getFileName());
        ExecutionContextMap ecm;
        this._data = data;
        long pid = Long.valueOf(IDHandler.getProcessID());
        ExecutionContextMap executionContextMap = ecm = _flt.getECM("nohost", pid);
        synchronized (executionContextMap) {
            ecm.get(-1L).setVariable(Long.toString(id), this._data);
        }
        this.setVarID(id);
    }

    private static FederatedWorkloadAnalyzer initAnalyzer() {
        if (ConfigurationManager.getCompressConfig().isWorkload()) {
            return new FederatedWorkloadAnalyzer();
        }
        return null;
    }

    @Override
    boolean equalAddress(FederatedData that) {
        return that.getClass().equals(this.getClass());
    }

    @Override
    public FederatedData copyWithNewID(long varID) {
        return new FederatedLocalData(varID, this._data);
    }

    @Override
    public synchronized Future<FederatedResponse> executeFederatedOperation(FederatedRequest ... request) {
        return CompletableFuture.completedFuture(this._fwh.createResponse(request));
    }
}

