/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops.rewrite;

import java.util.List;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.rewrite.LopRewriteRule;
import org.apache.sysds.parser.StatementBlock;

public class RewriteFixIDs
extends LopRewriteRule {
    @Override
    public List<StatementBlock> rewriteLOPinStatementBlock(StatementBlock sb) {
        if (!(ConfigurationManager.isPrefetchEnabled() || ConfigurationManager.isBroadcastEnabled() || ConfigurationManager.isCheckpointEnabled())) {
            return List.of(sb);
        }
        if (sb.getLops() != null && !sb.getLops().isEmpty()) {
            for (Lop root : sb.getLops()) {
                this.assignNewID(root);
            }
            sb.getLops().forEach(Lop::resetVisitStatus);
        }
        return List.of(sb);
    }

    @Override
    public List<StatementBlock> rewriteLOPinStatementBlocks(List<StatementBlock> sbs) {
        return sbs;
    }

    private void assignNewID(Lop lop) {
        if (lop.isVisited()) {
            return;
        }
        if (lop.getInputs().isEmpty()) {
            lop.setNewID();
            lop.setVisited();
            return;
        }
        for (Lop input : lop.getInputs()) {
            this.assignNewID(input);
        }
        lop.setNewID();
        lop.setVisited();
    }
}

