# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/apply_pipeline.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def apply_pipeline(testData: Frame,
                   pip: Frame,
                   applyFunc: Frame,
                   hp: Matrix,
                   exState: List,
                   iState: List,
                   **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This script will read the dirty and clean data, then it will apply the best pipeline on dirty data
     and then will classify both cleaned dataset and check if the cleaned dataset is performing same as original dataset
     in terms of classification accuracy
    
    
    
    :param trainData: ---
    :param testData: ---
    :param metaData: ---
    :param lp: ---
    :param pip: ---
    :param hp: ---
    :param evaluationFunc: ---
    :param evalFunHp: ---
    :param isLastLabel: ---
    :param correctTypos: ---
    :return: ---
    """

    params_dict = {'testData': testData, 'pip': pip, 'applyFunc': applyFunc, 'hp': hp, 'exState': exState, 'iState': iState}
    params_dict.update(kwargs)
    return Matrix(testData.sds_context,
        'apply_pipeline',
        named_input_nodes=params_dict)
