/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.shuffle.BlockPushingListener;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.ShuffleBlockPusher$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShufflePushBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-h!B+W\u0001as\u0006\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u000bE\u0004A\u0011\u0001:\t\rY\u0004\u0001\u0015!\u0003x\u0011\u0019Q\b\u0001)A\u0005o\"11\u0010\u0001Q\u0001\n]Da\u0001 \u0001!\u0002\u0013i\bbBA\u0001\u0001\u0001\u0006I! \u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003x\u0011\u001d\t)\u0001\u0001Q!\nuD\u0001\"a\u0002\u0001A\u0003%\u0011\u0011\u0002\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002(!A!\u0011\u001e\u0001!\u0002\u0013\tI\u0003\u0003\u0005\u0003l\u0002\u0001\u000b\u0011\u0002Bw\u0011)\u0019)\u0001\u0001b\u0001\n\u000316q\u0001\u0005\t\u0007\u001f\u0001\u0001\u0015!\u0003\u0004\n!A1\u0011\u0003\u0001\u0005\u0002Y\u001b\u0019\u0002\u0003\u0005\u0004\u0016\u0001!\tAVB\f\u0011!\u0019y\u0006\u0001C\u0001-\n\u0005\bbBB1\u0001\u0011E11\r\u0005\b\u0007_\u0002A\u0011\u0002Bq\u0011\u001d\u0019\t\b\u0001C\u0005\u0007gBqa!\u001f\u0001\t\u0013\u0019Y\bC\u0004\u0004\b\u0002!Ia!#\t\u0011\ru\u0005\u0001\"\u0001W\u0007?Cqaa3\u0001\t#\u0019im\u0002\u0005\u0002JYC\t\u0001WA&\r\u001d)f\u000b#\u0001Y\u0003\u001bBa!]\u000e\u0005\u0002\u0005=caBA)7\u0001C\u00161\u000b\u0005\u000b\u0003Cj\"Q3A\u0005\u0002\u0005\r\u0004BCA3;\tE\t\u0015!\u0003\u0002\u001a!Q\u0011qM\u000f\u0003\u0016\u0004%\t!!\u001b\t\u0015\u0005%UD!E!\u0002\u0013\tY\u0007\u0003\u0006\u0002\fv\u0011)\u001a!C\u0001\u0003\u001bC!\"a(\u001e\u0005#\u0005\u000b\u0011BAH\u0011\u0019\tX\u0004\"\u0001\u0002\"\"I\u0011QV\u000fC\u0002\u0013\u0005\u0011q\u0016\u0005\b\u0003ck\u0002\u0015!\u0003~\u0011%\t\u0019,HA\u0001\n\u0003\t)\fC\u0005\u0002>v\t\n\u0011\"\u0001\u0002@\"I\u0011Q[\u000f\u0012\u0002\u0013\u0005\u0011q\u001b\u0005\n\u00037l\u0012\u0013!C\u0001\u0003;D\u0011\"!9\u001e\u0003\u0003%\t%a9\t\u0013\u0005UX$!A\u0005\u0002\u0005=\u0006\"CA|;\u0005\u0005I\u0011AA}\u0011%\u0011)!HA\u0001\n\u0003\u00129\u0001C\u0005\u0003\u0012u\t\t\u0011\"\u0001\u0003\u0014!I!QD\u000f\u0002\u0002\u0013\u0005#q\u0004\u0005\n\u0005Ci\u0012\u0011!C!\u0005GA\u0011B!\n\u001e\u0003\u0003%\tEa\n\b\u0015\t-2$!A\t\u0002a\u0013iC\u0002\u0006\u0002Rm\t\t\u0011#\u0001Y\u0005_Aa!\u001d\u001b\u0005\u0002\tu\u0002\"\u0003B\u0011i\u0005\u0005IQ\tB\u0012\u0011%\u0011y\u0004NA\u0001\n\u0003\u0013\t\u0005C\u0005\u0003JQ\n\t\u0011\"!\u0003L!I!Q\f\u001b\u0002\u0002\u0013%!q\f\u0004\u0007\u0005OZBI!\u001b\t\u0015\t-$H!f\u0001\n\u0003\u0011i\u0007\u0003\u0006\u0003~i\u0012\t\u0012)A\u0005\u0005_B!Ba ;\u0005+\u0007I\u0011\u0001BA\u0011)\u0011II\u000fB\tB\u0003%!1\u0011\u0005\u0007cj\"\tAa#\t\u0013\u0005M&(!A\u0005\u0002\tM\u0005\"CA_uE\u0005I\u0011\u0001BM\u0011%\t)NOI\u0001\n\u0003\u0011i\nC\u0005\u0002bj\n\t\u0011\"\u0011\u0002d\"I\u0011Q\u001f\u001e\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003oT\u0014\u0011!C\u0001\u0005CC\u0011B!\u0002;\u0003\u0003%\tEa\u0002\t\u0013\tE!(!A\u0005\u0002\t\u0015\u0006\"\u0003B\u000fu\u0005\u0005I\u0011\tB\u0010\u0011%\u0011\tCOA\u0001\n\u0003\u0012\u0019\u0003C\u0005\u0003&i\n\t\u0011\"\u0011\u0003*\u001eI!QV\u000e\u0002\u0002#%!q\u0016\u0004\n\u0005OZ\u0012\u0011!E\u0005\u0005cCa!\u001d'\u0005\u0002\te\u0006\"\u0003B\u0011\u0019\u0006\u0005IQ\tB\u0012\u0011%\u0011y\u0004TA\u0001\n\u0003\u0013Y\fC\u0005\u0003J1\u000b\t\u0011\"!\u0003B\"I!Q\f'\u0002\u0002\u0013%!q\f\u0005\n\u0005\u0013\\\"\u0019!C\u0005\u0005\u0017D\u0001B!8\u001cA\u0003%!Q\u001a\u0005\t\u0005?\\B\u0011\u0001-\u0003b\n\u00112\u000b[;gM2,'\t\\8dWB+8\u000f[3s\u0015\t9\u0006,A\u0004tQV4g\r\\3\u000b\u0005eS\u0016!B:qCJ\\'BA.]\u0003\u0019\t\u0007/Y2iK*\tQ,A\u0002pe\u001e\u001c2\u0001A0f!\t\u00017-D\u0001b\u0015\u0005\u0011\u0017!B:dC2\f\u0017B\u00013b\u0005\u0019\te.\u001f*fMB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eW\u0001\tS:$XM\u001d8bY&\u0011!n\u001a\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011an\\\u0007\u00021&\u0011\u0001\u000f\u0017\u0002\n'B\f'o[\"p]\u001a\fa\u0001P5oSRtDCA:v!\t!\b!D\u0001W\u0011\u0015Y'\u00011\u0001n\u0003Ii\u0017\r\u001f\"m_\u000e\\7+\u001b>f)>\u0004Vo\u001d5\u0011\u0005\u0001D\u0018BA=b\u0005\u0011auN\\4\u0002#5\f\u0007P\u00117pG.\u0014\u0015\r^2i'&TX-\u0001\tnCb\u0014\u0015\u0010^3t\u0013:4E.[4ii\u0006yQ.\u0019=SKF\u001c\u0018J\u001c$mS\u001eDG\u000f\u0005\u0002a}&\u0011q0\u0019\u0002\u0004\u0013:$\u0018aG7bq\ncwnY6t\u0013:4E.[4iiB+'/\u00113ee\u0016\u001c8/A\u0007csR,7/\u00138GY&<\u0007\u000e^\u0001\re\u0016\f8/\u00138GY&<\u0007\u000e^\u0001\u001c]Vl'\t\\8dWNLeN\u00127jO\"$\b+\u001a:BI\u0012\u0014Xm]:\u0011\u000f\u0005-\u0011QCA\r{6\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005M\u0011-\u0001\u0006d_2dWm\u0019;j_:LA!a\u0006\u0002\u000e\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0001,A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0012Q\u0004\u0002\u000f\u00052|7m['b]\u0006<WM]%e\u0003Q!WMZ3se\u0016$\u0007+^:i%\u0016\fX/Z:ugBA\u00111BA\u000b\u00033\tI\u0003\u0005\u0004\u0002\f\u0005-\u0012qF\u0005\u0005\u0003[\tiAA\u0003Rk\u0016,X\rE\u0002\u00022uq1!a\r\u001b\u001d\u0011\t)$a\u0012\u000f\t\u0005]\u0012Q\t\b\u0005\u0003s\t\u0019E\u0004\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty\u0004\\\u0001\u0007yI|w\u000e\u001e \n\u0003uK!a\u0017/\n\u0005eS\u0016BA,Y\u0003I\u0019\u0006.\u001e4gY\u0016\u0014En\\2l!V\u001c\b.\u001a:\u0011\u0005Q\\2CA\u000e`)\t\tYEA\u0006QkND'+Z9vKN$8CB\u000f`\u0003+\nY\u0006E\u0002a\u0003/J1!!\u0017b\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001YA/\u0013\r\ty&\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bC\u0012$'/Z:t+\t\tI\"\u0001\u0005bI\u0012\u0014Xm]:!\u0003\u0019\u0011Gn\\2lgV\u0011\u00111\u000e\t\u0007\u0003[\n9(! \u000f\t\u0005=\u00141\u000f\b\u0005\u0003w\t\t(C\u0001c\u0013\r\t)(Y\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI(a\u001f\u0003\u0007M+\u0017OC\u0002\u0002v\u0005\u0004b\u0001YA@\u0003\u0007k\u0018bAAAC\n1A+\u001e9mKJ\u0002B!a\u0007\u0002\u0006&!\u0011qQA\u000f\u0005\u001d\u0011En\\2l\u0013\u0012\fqA\u00197pG.\u001c\b%A\u0005sKF\u0014UO\u001a4feV\u0011\u0011q\u0012\t\u0005\u0003#\u000bY*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003\u0019\u0011WO\u001a4fe*\u0019\u0011\u0011\u0014-\u0002\u000f9,Go^8sW&!\u0011QTAJ\u00055i\u0015M\\1hK\u0012\u0014UO\u001a4fe\u0006Q!/Z9Ck\u001a4WM\u001d\u0011\u0015\u0011\u0005\r\u0016qUAU\u0003W\u00032!!*\u001e\u001b\u0005Y\u0002bBA1I\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003O\"\u0003\u0019AA6\u0011\u001d\tY\t\na\u0001\u0003\u001f\u000bAa]5{KV\tQ0A\u0003tSj,\u0007%\u0001\u0003d_BLH\u0003CAR\u0003o\u000bI,a/\t\u0013\u0005\u0005t\u0005%AA\u0002\u0005e\u0001\"CA4OA\u0005\t\u0019AA6\u0011%\tYi\nI\u0001\u0002\u0004\ty)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005'\u0006BA\r\u0003\u0007\\#!!2\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001f\f\u0017AC1o]>$\u0018\r^5p]&!\u00111[Ae\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIN\u000b\u0003\u0002l\u0005\r\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003?TC!a$\u0002D\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!:\u0011\t\u0005\u001d\u0018\u0011_\u0007\u0003\u0003STA!a;\u0002n\u0006!A.\u00198h\u0015\t\ty/\u0001\u0003kCZ\f\u0017\u0002BAz\u0003S\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003w\u0014\t\u0001E\u0002a\u0003{L1!a@b\u0005\r\te.\u001f\u0005\t\u0005\u0007i\u0013\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0003\u0011\r\t-!QBA~\u001b\t\t\t\"\u0003\u0003\u0003\u0010\u0005E!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0006\u0003\u001cA\u0019\u0001Ma\u0006\n\u0007\te\u0011MA\u0004C_>dW-\u00198\t\u0013\t\rq&!AA\u0002\u0005m\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003u\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003K\fa!Z9vC2\u001cH\u0003\u0002B\u000b\u0005SA\u0011Ba\u00013\u0003\u0003\u0005\r!a?\u0002\u0017A+8\u000f\u001b*fcV,7\u000f\u001e\t\u0004\u0003K#4#\u0002\u001b\u00032\u0005m\u0003\u0003\u0004B\u001a\u0005s\tI\"a\u001b\u0002\u0010\u0006\rVB\u0001B\u001b\u0015\r\u00119$Y\u0001\beVtG/[7f\u0013\u0011\u0011YD!\u000e\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003.\u0005)\u0011\r\u001d9msRA\u00111\u0015B\"\u0005\u000b\u00129\u0005C\u0004\u0002b]\u0002\r!!\u0007\t\u000f\u0005\u001dt\u00071\u0001\u0002l!9\u00111R\u001cA\u0002\u0005=\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u001b\u0012I\u0006E\u0003a\u0005\u001f\u0012\u0019&C\u0002\u0003R\u0005\u0014aa\u00149uS>t\u0007#\u00031\u0003V\u0005e\u00111NAH\u0013\r\u00119&\u0019\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tm\u0003(!AA\u0002\u0005\r\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0007\u0005\u0003\u0002h\n\r\u0014\u0002\u0002B3\u0003S\u0014aa\u00142kK\u000e$(A\u0003)vg\"\u0014Vm];miN1!hXA+\u00037\nqA\u00197pG.LE-\u0006\u0002\u0003pA!!\u0011\u000fB=\u001d\u0011\u0011\u0019H!\u001e\u0011\u0007\u0005m\u0012-C\u0002\u0003x\u0005\fa\u0001\u0015:fI\u00164\u0017\u0002BAz\u0005wR1Aa\u001eb\u0003!\u0011Gn\\2l\u0013\u0012\u0004\u0013a\u00024bS2,(/Z\u000b\u0003\u0005\u0007\u0003B!!\u001c\u0003\u0006&!!qQA>\u0005%!\u0006N]8xC\ndW-\u0001\u0005gC&dWO]3!)\u0019\u0011iIa$\u0003\u0012B\u0019\u0011Q\u0015\u001e\t\u000f\t-t\b1\u0001\u0003p!9!qP A\u0002\t\rEC\u0002BG\u0005+\u00139\nC\u0005\u0003l\u0001\u0003\n\u00111\u0001\u0003p!I!q\u0010!\u0011\u0002\u0003\u0007!1Q\u000b\u0003\u00057SCAa\u001c\u0002DV\u0011!q\u0014\u0016\u0005\u0005\u0007\u000b\u0019\r\u0006\u0003\u0002|\n\r\u0006\u0002\u0003B\u0002\u000b\u0006\u0005\t\u0019A?\u0015\t\tU!q\u0015\u0005\n\u0005\u00079\u0015\u0011!a\u0001\u0003w$BA!\u0006\u0003,\"I!1\u0001&\u0002\u0002\u0003\u0007\u00111`\u0001\u000b!V\u001c\bNU3tk2$\bcAAS\u0019N)AJa-\u0002\\AQ!1\u0007B[\u0005_\u0012\u0019I!$\n\t\t]&Q\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001BX)\u0019\u0011iI!0\u0003@\"9!1N(A\u0002\t=\u0004b\u0002B@\u001f\u0002\u0007!1\u0011\u000b\u0005\u0005\u0007\u00149\rE\u0003a\u0005\u001f\u0012)\rE\u0004a\u0003\u007f\u0012yGa!\t\u0013\tm\u0003+!AA\u0002\t5\u0015!\u0005\"M\u001f\u000e[u\fU+T\u0011\u0016\u0013v\fU(P\u0019V\u0011!Q\u001a\t\u0005\u0005\u001f\u0014I.\u0004\u0002\u0003R*!!1\u001bBk\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005/\fi/\u0001\u0003vi&d\u0017\u0002\u0002Bn\u0005#\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\u0013\u00052{5iS0Q+NCUIU0Q\u001f>c\u0005%\u0001\u0003ti>\u0004HC\u0001Br!\r\u0001'Q]\u0005\u0004\u0005O\f'\u0001B+oSR\fA\u0002];tQJ+\u0017/^3tiN\fA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004BAa<\u0003\u0000:!!\u0011\u001fB}\u001d\u0011\u0011\u0019Pa>\u000f\t\u0005U\"Q_\u0005\u0004\u00033C\u0016bA,\u0002\u0018&!!1 B\u007f\u00031)%O]8s\u0011\u0006tG\r\\3s\u0015\r9\u0016qS\u0005\u0005\u0007\u0003\u0019\u0019AA\u000bCY>\u001c7\u000eU;tQ\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\t\tm(Q`\u0001\u0015k:\u0014X-Y2iC\ndWM\u00117pG.luM]:\u0016\u0005\r%\u0001CBA\u0006\u0007\u0017\tI\"\u0003\u0003\u0004\u000e\u00055!a\u0002%bg\"\u001cV\r^\u0001\u0016k:\u0014X-Y2iC\ndWM\u00117pG.luM]:!\u0003I\u0019'/Z1uK\u0016\u0013(o\u001c:IC:$G.\u001a:\u0015\u0005\t5\u0018!E5oSRL\u0017\r^3CY>\u001c7\u000eU;tQRQ!1]B\r\u0007S\u0019\u0019da\u0017\t\u000f\rm\u0011\u00031\u0001\u0004\u001e\u0005AA-\u0019;b\r&dW\r\u0005\u0003\u0004 \r\u0015RBAB\u0011\u0015\u0011\u0019\u0019#!<\u0002\u0005%|\u0017\u0002BB\u0014\u0007C\u0011AAR5mK\"911F\tA\u0002\r5\u0012\u0001\u00059beRLG/[8o\u0019\u0016tw\r\u001e5t!\u0011\u00017qF<\n\u0007\rE\u0012MA\u0003BeJ\f\u0017\u0010C\u0004\u00046E\u0001\raa\u000e\u0002\u0007\u0011,\u0007\u000f\r\u0005\u0004:\r\r3\u0011KB,!%q71HB \u0007\u001f\u001a)&C\u0002\u0004>a\u0013\u0011c\u00155vM\u001adW\rR3qK:$WM\\2z!\u0011\u0019\tea\u0011\r\u0001\u0011a1QIB\u001a\u0003\u0003\u0005\tQ!\u0001\u0004H\t\u0019q\fJ\u0019\u0012\t\r%\u00131 \t\u0004A\u000e-\u0013bAB'C\n9aj\u001c;iS:<\u0007\u0003BB!\u0007#\"Aba\u0015\u00044\u0005\u0005\t\u0011!B\u0001\u0007\u000f\u00121a\u0018\u00133!\u0011\u0019\tea\u0016\u0005\u0019\re31GA\u0001\u0002\u0003\u0015\taa\u0012\u0003\u0007}#3\u0007\u0003\u0004\u0004^E\u0001\r!`\u0001\t[\u0006\u0004\u0018J\u001c3fq\u0006qAO]=QkNDW\u000b\u001d+p\u001b\u0006D\u0018AC:vE6LG\u000fV1tWR!!1]B3\u0011\u001d\u00199g\u0005a\u0001\u0007S\nA\u0001^1tWB!\u0011q]B6\u0013\u0011\u0019i'!;\u0003\u0011I+hN\\1cY\u0016\f1\u0002];tQV\u0003Hk\\'bq\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0011\u0011\u0019o!\u001e\t\u000f\r]T\u00031\u0001\u00020\u00059!/Z9vKN$\u0018AH:mS\u000e,'+Z9Ck\u001a4WM]%oi>\u0014En\\2l\u0005V4g-\u001a:t)\u0019\u0019iha \u0004\u0002B)\u0001ma\f\u0002\u0010\"9\u00111\u0012\fA\u0002\u0005=\u0005bBBB-\u0001\u00071QQ\u0001\u000bE2|7m[*ju\u0016\u001c\b#BA7\u0003oj\u0018!H;qI\u0006$Xm\u0015;bi\u0016\fe\u000eZ\"iK\u000e\\\u0017J\u001a)vg\"luN]3\u0015\u0015\tU11RBH\u0007#\u001b9\n\u0003\u0004\u0004\u000e^\u0001\ra^\u0001\fEf$Xm\u001d)vg\",G\rC\u0004\u0002b]\u0001\r!!\u0007\t\u000f\rMu\u00031\u0001\u0004\u0016\u0006y!/Z7bS:Lgn\u001a\"m_\u000e\\7\u000f\u0005\u0004\u0002\f\r-!q\u000e\u0005\b\u00073;\u0002\u0019ABN\u0003)\u0001Xo\u001d5SKN,H\u000e\u001e\t\u0004\u0003cQ\u0014\u0001\u00079sKB\f'/\u001a\"m_\u000e\\\u0007+^:i%\u0016\fX/Z:ugR\u00112\u0011UBR\u0007O\u001bYka,\u00044\u000eU6qWB_!\u0019\ti'a\u001e\u00020!11Q\u0015\rA\u0002u\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bBBBU1\u0001\u0007Q0A\u0006qCJ$\u0018\u000e^5p]&#\u0007BBBW1\u0001\u0007Q0A\u0005tQV4g\r\\3JI\"11\u0011\u0017\rA\u0002u\fab\u001d5vM\u001adW-T3sO\u0016LE\rC\u0004\u0004\u001ca\u0001\ra!\b\t\u000f\r-\u0002\u00041\u0001\u0004.!91\u0011\u0018\rA\u0002\rm\u0016AC7fe\u001e,'\u000fT8dgB1\u0011QNA<\u00033Aqaa0\u0019\u0001\u0004\u0019\t-A\u0007ue\u0006t7\u000f]8si\u000e{gN\u001a\t\u0005\u0007\u0007\u001c9-\u0004\u0002\u0004F*!!q[AL\u0013\u0011\u0019Im!2\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u0003M\u0019'/Z1uKJ+\u0017/^3ti\n+hMZ3s))\tyia4\u0004R\u000eM7q\u001b\u0005\u0007Wf\u0001\ra!1\t\u000f\rm\u0011\u00041\u0001\u0004\u001e!11Q[\rA\u0002]\faa\u001c4gg\u0016$\bBBBm3\u0001\u0007q/\u0001\u0004mK:<G\u000f\u001b\u0015\u0006\u0001\ru7q\u001d\t\u0005\u0007?\u001c\u0019/\u0004\u0002\u0004b*\u0019\u0011q\u001a-\n\t\r\u00158\u0011\u001d\u0002\u0006'&t7-Z\u0011\u0003\u0007S\fQa\r\u00183]A\u0002")
public class ShuffleBlockPusher
implements Logging {
    private final SparkConf conf;
    private final long maxBlockSizeToPush;
    private final long maxBlockBatchSize;
    private final long maxBytesInFlight;
    private final int maxReqsInFlight;
    private final int maxBlocksInFlightPerAddress;
    private long bytesInFlight;
    private int reqsInFlight;
    private final HashMap<BlockManagerId, Object> numBlocksInFlightPerAddress;
    private final HashMap<BlockManagerId, Queue<PushRequest>> deferredPushRequests;
    private final Queue<PushRequest> pushRequests;
    public final ErrorHandler.BlockPushErrorHandler org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler;
    private final HashSet<BlockManagerId> unreachableBlockMgrs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashSet<BlockManagerId> unreachableBlockMgrs() {
        return this.unreachableBlockMgrs;
    }

    public ErrorHandler.BlockPushErrorHandler createErrorHandler() {
        return new ErrorHandler.BlockPushErrorHandler(null){

            public boolean shouldRetryError(Throwable t) {
                if (t.getCause() != null && t.getCause() instanceof FileNotFoundException) {
                    return false;
                }
                return !(t instanceof BlockPushNonFatalFailure) || !BlockPushNonFatalFailure.shouldNotRetryErrorCode((BlockPushNonFatalFailure.ReturnCode)((BlockPushNonFatalFailure)t).getReturnCode());
            }
        };
    }

    public void initiateBlockPush(File dataFile, long[] partitionLengths, ShuffleDependency<?, ?, ?> dep, int mapIndex) {
        int numPartitions = dep.partitioner().numPartitions();
        TransportConf transportConf = SparkTransportConf$.MODULE$.fromSparkConf(this.conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        Seq<PushRequest> requests = this.prepareBlockPushRequests(numPartitions, mapIndex, dep.shuffleId(), dep.shuffleMergeId(), dataFile, partitionLengths, dep.getMergerLocs(), transportConf);
        this.pushRequests.$plus$plus$eq(Utils$.MODULE$.randomize(requests, ClassTag$.MODULE$.apply(PushRequest.class)));
        this.submitTask(() -> this.tryPushUpToMax());
    }

    public void tryPushUpToMax() {
        try {
            this.pushUpToMax();
        }
        catch (FileNotFoundException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The shuffle files got deleted when this shuffle-block-push-thread was reading from them which could happen when the job finishes and the driver instructs the executor to cleanup the shuffle. In this case, push of the blocks belonging to this shuffle will stop.", e);
        }
    }

    public void submitTask(Runnable task) {
        block0: {
            if (ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL() == null) break block0;
            ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL().execute(task);
        }
    }

    private synchronized void pushUpToMax() {
        if (this.deferredPushRequests.nonEmpty()) {
            this.deferredPushRequests.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ShuffleBlockPusher.$anonfun$pushUpToMax$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ShuffleBlockPusher.$anonfun$pushUpToMax$2(this, x$1);
                return BoxedUnit.UNIT;
            });
        }
        while (this.isRemoteBlockPushable$1(this.pushRequests)) {
            PushRequest request = (PushRequest)this.pushRequests.dequeue();
            BlockManagerId remoteAddress = request.address();
            if (this.isRemoteAddressMaxedOut$1(remoteAddress, request)) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deferring push request for ").append(remoteAddress).append(" with ").append(request.blocks().size()).append(" blocks").toString());
                ((Queue)this.deferredPushRequests.getOrElseUpdate((Object)remoteAddress, (Function0 & Serializable & scala.Serializable)() -> new Queue())).enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PushRequest[]{request}));
                continue;
            }
            this.sendRequest(request);
        }
    }

    private void sendRequest(PushRequest request) {
        this.bytesInFlight += (long)request.size();
        ++this.reqsInFlight;
        this.numBlocksInFlightPerAddress.update((Object)request.address(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.getOrElseUpdate((Object)request.address(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + request.blocks().length())));
        Map sizeMap = ((TraversableOnce)request.blocks().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockId blockId = (BlockId)tuple2._1();
            int size = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)blockId.toString(), (Object)BoxesRunTime.boxToInteger((int)size));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        BlockManagerId address = request.address();
        Seq blockIds = (Seq)request.blocks().map((Function1 & Serializable & scala.Serializable)x$2 -> ((BlockId)x$2._1()).toString(), Seq$.MODULE$.canBuildFrom());
        HashSet remainingBlocks = (HashSet)new HashSet().$plus$plus$eq((TraversableOnce)blockIds);
        BlockPushingListener blockPushListener = new BlockPushingListener(this, sizeMap, address, remainingBlocks){
            private final /* synthetic */ ShuffleBlockPusher $outer;
            private final Map sizeMap$1;
            private final BlockManagerId address$1;
            private final HashSet remainingBlocks$1;

            public void onBlockTransferSuccess(String x$1, ManagedBuffer x$2) {
                super.onBlockTransferSuccess(x$1, x$2);
            }

            public void onBlockTransferFailure(String x$1, Throwable x$2) {
                super.onBlockTransferFailure(x$1, x$2);
            }

            public String getTransferType() {
                return super.getTransferType();
            }

            public void handleResult(PushResult result) {
                this.$outer.submitTask(() -> {
                    block0: {
                        if (!$this.$outer.org$apache$spark$shuffle$ShuffleBlockPusher$$updateStateAndCheckIfPushMore(BoxesRunTime.unboxToInt((Object)$this.sizeMap$1.apply((Object)result.blockId())), $this.address$1, (HashSet<String>)$this.remainingBlocks$1, result)) break block0;
                        $this.$outer.tryPushUpToMax();
                    }
                });
            }

            public void onBlockPushSuccess(String blockId, ManagedBuffer data) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Push for block ").append(blockId).append(" to ").append($this.address$1).append(" successful.").toString());
                this.handleResult(new PushResult(blockId, null));
            }

            public void onBlockPushFailure(String blockId, Throwable exception) {
                if (!this.$outer.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler.shouldLogError(exception)) {
                    this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Pushing block ").append(blockId).append(" to ").append($this.address$1).append(" failed.").toString(), exception);
                } else {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Pushing block ").append(blockId).append(" to ").append($this.address$1).append(" failed.").toString(), exception);
                }
                this.handleResult(new PushResult(blockId, exception));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sizeMap$1 = sizeMap$1;
                this.address$1 = address$1;
                this.remainingBlocks$1 = remainingBlocks$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onBlockPushSuccess$1(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String ), $anonfun$onBlockPushFailure$1(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String ), $anonfun$onBlockPushFailure$2(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String )}, serializedLambda);
            }
        };
        Tuple2 tuple2 = Utils$.MODULE$.randomize((TraversableOnce)blockIds.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.sliceReqBufferIntoBlockBuffers(request.reqBuffer(), (Seq<Object>)((Seq)request.blocks().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())))), Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Tuple2.class)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq blockPushIds = (Seq)tuple2._1();
        Seq blockPushBuffers = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockPushIds, (Object)blockPushBuffers);
        Tuple2 tuple23 = tuple22;
        Seq blockPushIds2 = (Seq)tuple23._1();
        Seq blockPushBuffers2 = (Seq)tuple23._2();
        SparkEnv$.MODULE$.get().blockManager().blockStoreClient().pushBlocks(address.host(), address.port(), (String[])blockPushIds2.toArray(ClassTag$.MODULE$.apply(String.class)), (ManagedBuffer[])blockPushBuffers2.toArray(ClassTag$.MODULE$.apply(ManagedBuffer.class)), blockPushListener);
    }

    private ManagedBuffer[] sliceReqBufferIntoBlockBuffers(ManagedBuffer reqBuffer, Seq<Object> blockSizes) {
        ManagedBuffer[] managedBufferArray;
        if (blockSizes.size() == 1) {
            managedBufferArray = (ManagedBuffer[])((Object[])new ManagedBuffer[]{reqBuffer});
        } else {
            ByteBuffer inMemoryBuffer = reqBuffer.nioByteBuffer();
            int[] blockOffsets = new int[blockSizes.size()];
            IntRef offset = IntRef.create((int)0);
            blockSizes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                blockOffsets$1[index] = offset$1.elem;
                offset$1.elem += BoxesRunTime.unboxToInt((Object)blockSizes.apply(index));
            });
            managedBufferArray = (ManagedBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(blockOffsets)).zip(blockSizes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int offset = tuple2._1$mcI$sp();
                int size = tuple2._2$mcI$sp();
                NioManagedBuffer nioManagedBuffer = new NioManagedBuffer(((ByteBuffer)inMemoryBuffer.duplicate().position(offset).limit(offset + size)).slice());
                return nioManagedBuffer;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NioManagedBuffer.class))))).toArray(ClassTag$.MODULE$.apply(ManagedBuffer.class));
        }
        return managedBufferArray;
    }

    public synchronized boolean org$apache$spark$shuffle$ShuffleBlockPusher$$updateStateAndCheckIfPushMore(long bytesPushed, BlockManagerId address, HashSet<String> remainingBlocks, PushResult pushResult) {
        remainingBlocks.$minus$eq((Object)pushResult.blockId());
        this.bytesInFlight -= bytesPushed;
        this.numBlocksInFlightPerAddress.update((Object)address, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.apply((Object)address)) - 1)));
        if (remainingBlocks.isEmpty()) {
            --this.reqsInFlight;
        }
        if (pushResult.failure() != null && pushResult.failure().getCause() instanceof ConnectException && !this.unreachableBlockMgrs().contains((Object)address)) {
            IntRef removed = IntRef.create((int)0);
            this.unreachableBlockMgrs().add((Object)address);
            removed.elem += this.pushRequests.dequeueAll((Function1 & Serializable & scala.Serializable)req -> BoxesRunTime.boxToBoolean((boolean)ShuffleBlockPusher.$anonfun$updateStateAndCheckIfPushMore$1(address, req))).length();
            removed.elem += BoxesRunTime.unboxToInt((Object)this.deferredPushRequests.remove((Object)address).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.length())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Received a ConnectException from ").append(address).append(". ").append("Dropping ").append(removed$1.elem).append(" push-requests and ").append("not pushing any more blocks to this address.").toString());
        }
        if (pushResult.failure() != null && !this.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler.shouldRetryError(pushResult.failure())) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Encountered an exception from ").append(address).append(" which indicates that push needs to ").append("stop.").toString());
            return false;
        }
        return remainingBlocks.isEmpty() && (this.pushRequests.nonEmpty() || this.deferredPushRequests.nonEmpty());
    }

    public Seq<PushRequest> prepareBlockPushRequests(int numPartitions, int partitionId, int shuffleId, int shuffleMergeId, File dataFile, long[] partitionLengths, Seq<BlockManagerId> mergerLocs, TransportConf transportConf) {
        LongRef offset = LongRef.create((long)0L);
        IntRef currentReqSize = IntRef.create((int)0);
        LongRef currentReqOffset = LongRef.create((long)0L);
        IntRef currentMergerId = IntRef.create((int)0);
        int numMergers = mergerLocs.length();
        ArrayBuffer requests = new ArrayBuffer();
        ObjectRef blocks = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)reduceId -> {
            long blockSize = partitionLengths[reduceId];
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Block ").append(new ShufflePushBlockId(shuffleId, shuffleMergeId, partitionId, reduceId)).append(" is of size ").append(blockSize).toString());
            if (blockSize > 0L) {
                int mergerId = (int)package$.MODULE$.min(package$.MODULE$.floor((double)reduceId * 1.0 / (double)numPartitions * (double)numMergers), (double)(numMergers - 1));
                if ((long)currentReqSize$1.elem + blockSize <= $this.maxBlockBatchSize && ((ArrayBuffer)blocks$1.elem).size() < $this.maxBlocksInFlightPerAddress && mergerId == currentMergerId$1.elem && blockSize <= $this.maxBlockSizeToPush) {
                    currentReqSize$1.elem += (int)blockSize;
                } else {
                    if (((ArrayBuffer)blocks$1.elem).nonEmpty()) {
                        requests.$plus$eq((Object)new PushRequest((BlockManagerId)mergerLocs.apply(currentMergerId$1.elem), (Seq<Tuple2<BlockId, Object>>)((ArrayBuffer)blocks$1.elem).toSeq(), this.createRequestBuffer(transportConf, dataFile, currentReqOffset$1.elem, currentReqSize$1.elem)));
                        blocks$1.elem = new ArrayBuffer();
                    }
                    currentReqSize$1.elem = 0;
                    currentReqOffset$1.elem = -1L;
                    currentMergerId$1.elem = mergerId;
                }
                if (blockSize <= $this.maxBlockSizeToPush) {
                    int blockSizeInt = (int)blockSize;
                    ((ArrayBuffer)blocks$1.elem).$plus$eq((Object)new Tuple2((Object)new ShufflePushBlockId(shuffleId, shuffleMergeId, partitionId, reduceId), (Object)BoxesRunTime.boxToInteger((int)blockSizeInt)));
                    if (currentReqOffset$1.elem == -1L) {
                        currentReqOffset$1.elem = offset$2.elem;
                    }
                    if (currentReqSize$1.elem == 0) {
                        currentReqSize$1.elem += blockSizeInt;
                    }
                }
            }
            offset$2.elem += blockSize;
        });
        Object object = ((ArrayBuffer)blocks.elem).nonEmpty() ? requests.$plus$eq((Object)new PushRequest((BlockManagerId)mergerLocs.apply(currentMergerId.elem), (Seq<Tuple2<BlockId, Object>>)((ArrayBuffer)blocks.elem).toSeq(), this.createRequestBuffer(transportConf, dataFile, currentReqOffset.elem, currentReqSize.elem))) : BoxedUnit.UNIT;
        return requests.toSeq();
    }

    public ManagedBuffer createRequestBuffer(TransportConf conf, File dataFile, long offset, long length) {
        return new FileSegmentManagedBuffer(conf, dataFile, offset, length);
    }

    public static final /* synthetic */ boolean $anonfun$pushUpToMax$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$pushUpToMax$2(ShuffleBlockPusher $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            BlockManagerId remoteAddress = (BlockManagerId)tuple2._1();
            Queue defReqQueue = (Queue)tuple2._2();
            while ($this.isRemoteBlockPushable$1(defReqQueue) && !$this.isRemoteAddressMaxedOut$1(remoteAddress, (PushRequest)defReqQueue.front())) {
                PushRequest request = (PushRequest)defReqQueue.dequeue();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Processing deferred push request for ").append(remoteAddress).append(" with ").append(request.blocks().length()).append(" blocks").toString());
                $this.sendRequest(request);
                Object object = defReqQueue.isEmpty() ? $this.deferredPushRequests.$minus$eq((Object)remoteAddress) : BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean isRemoteBlockPushable$1(Queue pushReqQueue) {
        return pushReqQueue.nonEmpty() && (this.bytesInFlight == 0L || this.reqsInFlight + 1 <= this.maxReqsInFlight && this.bytesInFlight + (long)((PushRequest)pushReqQueue.front()).size() <= this.maxBytesInFlight);
    }

    private final boolean isRemoteAddressMaxedOut$1(BlockManagerId remoteAddress, PushRequest request) {
        return BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.getOrElse((Object)remoteAddress, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + request.blocks().size() > this.maxBlocksInFlightPerAddress;
    }

    public static final /* synthetic */ boolean $anonfun$updateStateAndCheckIfPushMore$1(BlockManagerId address$2, PushRequest req) {
        BlockManagerId blockManagerId = req.address();
        BlockManagerId blockManagerId2 = address$2;
        return !(blockManagerId != null ? !((Object)blockManagerId).equals(blockManagerId2) : blockManagerId2 != null);
    }

    public ShuffleBlockPusher(SparkConf conf) {
        this.conf = conf;
        Logging.$init$(this);
        this.maxBlockSizeToPush = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MAX_BLOCK_SIZE_TO_PUSH()));
        this.maxBlockBatchSize = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MAX_BLOCK_BATCH_SIZE_FOR_PUSH()));
        this.maxBytesInFlight = conf.getSizeAsMb("spark.reducer.maxSizeInFlight", "48m") * 1024L * 1024L;
        this.maxReqsInFlight = conf.getInt("spark.reducer.maxReqsInFlight", Integer.MAX_VALUE);
        this.maxBlocksInFlightPerAddress = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.REDUCER_MAX_BLOCKS_IN_FLIGHT_PER_ADDRESS()));
        this.bytesInFlight = 0L;
        this.reqsInFlight = 0;
        this.numBlocksInFlightPerAddress = new HashMap();
        this.deferredPushRequests = new HashMap();
        this.pushRequests = new Queue();
        this.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler = this.createErrorHandler();
        this.unreachableBlockMgrs = new HashSet();
    }

    public static class PushRequest
    implements Product,
    scala.Serializable {
        private final BlockManagerId address;
        private final Seq<Tuple2<BlockId, Object>> blocks;
        private final ManagedBuffer reqBuffer;
        private final int size;

        public BlockManagerId address() {
            return this.address;
        }

        public Seq<Tuple2<BlockId, Object>> blocks() {
            return this.blocks;
        }

        public ManagedBuffer reqBuffer() {
            return this.reqBuffer;
        }

        public int size() {
            return this.size;
        }

        public PushRequest copy(BlockManagerId address, Seq<Tuple2<BlockId, Object>> blocks, ManagedBuffer reqBuffer) {
            return new PushRequest(address, blocks, reqBuffer);
        }

        public BlockManagerId copy$default$1() {
            return this.address();
        }

        public Seq<Tuple2<BlockId, Object>> copy$default$2() {
            return this.blocks();
        }

        public ManagedBuffer copy$default$3() {
            return this.reqBuffer();
        }

        public String productPrefix() {
            return "PushRequest";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            ManagedBuffer managedBuffer;
            int n = x$1;
            switch (n) {
                case 0: {
                    managedBuffer = this.address();
                    break;
                }
                case 1: {
                    managedBuffer = this.blocks();
                    break;
                }
                case 2: {
                    managedBuffer = this.reqBuffer();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return managedBuffer;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PushRequest;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PushRequest)) return false;
            boolean bl = true;
            if (!bl) return false;
            PushRequest pushRequest = (PushRequest)x$1;
            BlockManagerId blockManagerId = this.address();
            BlockManagerId blockManagerId2 = pushRequest.address();
            if (blockManagerId == null) {
                if (blockManagerId2 != null) {
                    return false;
                }
            } else if (!((Object)blockManagerId).equals(blockManagerId2)) return false;
            Seq<Tuple2<BlockId, Object>> seq = this.blocks();
            Seq<Tuple2<BlockId, Object>> seq2 = pushRequest.blocks();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            ManagedBuffer managedBuffer = this.reqBuffer();
            ManagedBuffer managedBuffer2 = pushRequest.reqBuffer();
            if (managedBuffer == null) {
                if (managedBuffer2 != null) {
                    return false;
                }
            } else if (!managedBuffer.equals(managedBuffer2)) return false;
            if (!pushRequest.canEqual(this)) return false;
            return true;
        }

        public PushRequest(BlockManagerId address, Seq<Tuple2<BlockId, Object>> blocks, ManagedBuffer reqBuffer) {
            this.address = address;
            this.blocks = blocks;
            this.reqBuffer = reqBuffer;
            Product.$init$((Product)this);
            this.size = BoxesRunTime.unboxToInt((Object)((TraversableOnce)blocks.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
    }

    private static class PushResult
    implements Product,
    scala.Serializable {
        private final String blockId;
        private final Throwable failure;

        public String blockId() {
            return this.blockId;
        }

        public Throwable failure() {
            return this.failure;
        }

        public PushResult copy(String blockId, Throwable failure) {
            return new PushResult(blockId, failure);
        }

        public String copy$default$1() {
            return this.blockId();
        }

        public Throwable copy$default$2() {
            return this.failure();
        }

        public String productPrefix() {
            return "PushResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.blockId();
                    break;
                }
                case 1: {
                    object = this.failure();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PushResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PushResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            PushResult pushResult = (PushResult)x$1;
            String string = this.blockId();
            String string2 = pushResult.blockId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.failure();
            Throwable throwable2 = pushResult.failure();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!pushResult.canEqual(this)) return false;
            return true;
        }

        public PushResult(String blockId, Throwable failure) {
            this.blockId = blockId;
            this.failure = failure;
            Product.$init$((Product)this);
        }
    }
}

