/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.cost.CostEstimatorBuilder;
import org.apache.sysds.runtime.compress.cost.DistinctCostEstimator;
import org.apache.sysds.runtime.compress.cost.HybridCostEstimator;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.cost.MemoryCostEstimator;

public final class CostEstimatorFactory {
    protected static final Log LOG = LogFactory.getLog((String)CostEstimatorFactory.class.getName());

    public static ICostEstimate create(CompressionSettings cs, CostEstimatorBuilder costVector, int nRows, int nCols, double sparsity) {
        switch (cs.costComputationType) {
            case DISTINCT: {
                return new DistinctCostEstimator(nRows, cs, sparsity);
            }
            case HYBRID_W_TREE: {
                if (costVector != null) {
                    return costVector.create(nRows, nCols, sparsity, true);
                }
                return CostEstimatorFactory.genDefaultCostCase(nRows, nCols, sparsity, true);
            }
            case MEMORY: {
                return new MemoryCostEstimator(nRows, nCols, sparsity);
            }
        }
        if (costVector != null) {
            return costVector.create(nRows, nCols, sparsity, cs.isInSparkInstruction);
        }
        return CostEstimatorFactory.genDefaultCostCase(nRows, nCols, sparsity, cs.isInSparkInstruction);
    }

    public static ICostEstimate genDefaultCostCase(int nRows, int nCols, double sparsity, boolean isInSparkInstruction) {
        if (isInSparkInstruction) {
            return new HybridCostEstimator(nRows, nCols, sparsity, 1, 1, 0, 1, 1, 1, 10, true);
        }
        return new ComputationCostEstimator(nRows, nCols, sparsity, 1, 1, 0, 1, 1, 1, 10, true);
    }

    public static enum CostType {
        MEMORY,
        W_TREE,
        HYBRID_W_TREE,
        DISTINCT,
        AUTO;

    }
}

