/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import java.util.Map;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.lops.Compression;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.runtime.compress.cost.CostEstimatorBuilder;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;
import org.apache.sysds.runtime.compress.workload.WorkloadAnalyzer;

public class IPAPassCompressionWorkloadAnalysis
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return Compression.CompressConfig.valueOf(ConfigurationManager.getDMLConfig().getTextValue("sysds.compressed.linalg").toUpperCase()) == Compression.CompressConfig.WORKLOAD;
    }

    @Override
    public boolean rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        OptimizerUtils.ALLOW_COMPRESSION_REWRITE = false;
        Map<Long, WTreeRoot> map = WorkloadAnalyzer.getAllCandidateWorkloads(prog);
        for (Map.Entry<Long, WTreeRoot> e : map.entrySet()) {
            WTreeRoot tree = e.getValue();
            CostEstimatorBuilder b = new CostEstimatorBuilder(tree);
            boolean shouldCompress = b.shouldTryToCompress();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("IPAPass Should Compress:\n" + tree + "\n" + b + "\n Should Compress: " + shouldCompress));
            }
            if (!shouldCompress) continue;
            tree.getRoot().setRequiresCompression(tree);
        }
        return map != null;
    }
}

