/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.functions;

import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysds.lops.BinaryM;
import org.apache.sysds.runtime.instructions.spark.data.LazyIterableIterator;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import scala.Tuple2;

public class MatrixVectorBinaryOpPartitionFunction
implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = 9096091404578628534L;
    private BinaryOperator _op = null;
    private PartitionedBroadcast<MatrixBlock> _pmV = null;
    private BinaryM.VectorType _vtype = null;

    public MatrixVectorBinaryOpPartitionFunction(BinaryOperator op, PartitionedBroadcast<MatrixBlock> binput, BinaryM.VectorType vtype) {
        this._op = op;
        this._pmV = binput;
        this._vtype = vtype;
    }

    public LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg0) throws Exception {
        return new MapBinaryPartitionIterator(arg0);
    }

    private class MapBinaryPartitionIterator
    extends LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> {
        public MapBinaryPartitionIterator(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> in) {
            super(in);
        }

        @Override
        protected Tuple2<MatrixIndexes, MatrixBlock> computeNext(Tuple2<MatrixIndexes, MatrixBlock> arg) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)arg._1();
            MatrixBlock in1 = (MatrixBlock)arg._2();
            int rix = (int)(MatrixVectorBinaryOpPartitionFunction.this._vtype == BinaryM.VectorType.COL_VECTOR ? ix.getRowIndex() : 1L);
            int cix = (int)(MatrixVectorBinaryOpPartitionFunction.this._vtype == BinaryM.VectorType.COL_VECTOR ? 1L : ix.getColumnIndex());
            MatrixBlock in2 = (MatrixBlock)MatrixVectorBinaryOpPartitionFunction.this._pmV.getBlock(rix, cix);
            MatrixBlock ret = in1.binaryOperations(MatrixVectorBinaryOpPartitionFunction.this._op, in2, new MatrixBlock());
            return new Tuple2((Object)ix, (Object)ret);
        }
    }
}

