/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderBin;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ColumnEncoderDummycode
extends ColumnEncoder {
    private static final long serialVersionUID = 5832130477659116489L;
    public int _domainSize = -1;

    public ColumnEncoderDummycode() {
        super(-1);
    }

    public ColumnEncoderDummycode(int colID) {
        super(colID);
    }

    public ColumnEncoderDummycode(int colID, int domainSize) {
        super(colID);
        this._domainSize = domainSize;
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public List<Callable<Object>> getPartialBuildTasks(FrameBlock in, int blockSize) {
        return null;
    }

    @Override
    public void mergeBuildPartial(List<Future<Object>> futurePartials, int start, int end) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        throw new DMLRuntimeException("Called DummyCoder with FrameBlock");
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        for (int i = rowStart; i < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++i) {
            double val = in.quickGetValueThreadSafe(i, outputCol);
            int nCol = outputCol + (int)val - 1;
            if (nCol != outputCol) {
                out.quickSetValueThreadSafe(i, outputCol, 0.0);
            }
            out.quickSetValueThreadSafe(i, nCol, 1.0);
        }
        return out;
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderDummycode) {
            assert (other._colID == this._colID);
            this._domainSize = 0;
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims, int colOffset) {
        beginDims[1] = beginDims[1] + (long)colOffset;
        endDims[1] = endDims[1] + (long)(this._domainSize - 1 + colOffset);
    }

    public void updateDomainSizes(List<ColumnEncoder> columnEncoders) {
        if (this._colID == -1) {
            return;
        }
        for (ColumnEncoder columnEncoder : columnEncoders) {
            int distinct = -1;
            if (columnEncoder instanceof ColumnEncoderRecode) {
                ColumnEncoderRecode columnEncoderRecode = (ColumnEncoderRecode)columnEncoder;
                distinct = columnEncoderRecode.getNumDistinctValues();
            } else if (columnEncoder instanceof ColumnEncoderBin) {
                distinct = ((ColumnEncoderBin)columnEncoder)._numBin;
            }
            if (distinct == -1) continue;
            this._domainSize = distinct;
        }
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._domainSize = -1;
        this._domainSize = (int)meta.getColumnMetadata()[this._colID - 1].getNumDistinct();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._domainSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._domainSize = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnEncoderDummycode that = (ColumnEncoderDummycode)o;
        return this._colID == that._colID && this._domainSize == that._domainSize;
    }

    public int hashCode() {
        int result = Objects.hash(this._colID);
        result = 31 * result + Objects.hashCode(this._domainSize);
        return result;
    }

    public int getDomainSize() {
        return this._domainSize;
    }
}

