/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.QDictionary;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.Bitmap;
import org.apache.sysds.runtime.compress.utils.BitmapLossy;
import org.apache.sysds.runtime.compress.utils.MultiColBitmap;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class DictionaryFactory {
    protected static final Log LOG = LogFactory.getLog((String)DictionaryFactory.class.getName());

    public static ADictionary read(DataInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case FP64_DICT: {
                return Dictionary.read(in);
            }
            case MATRIX_BLOCK_DICT: {
                return MatrixBlockDictionary.read(in);
            }
            case INT8_DICT: {
                return QDictionary.read(in);
            }
        }
        throw new DMLCompressionException("Unsupported type of dictionary : " + (Object)((Object)type));
    }

    public static long getInMemorySize(int nrValues, int nrColumns, double tupleSparsity, boolean lossy) {
        if (lossy) {
            return QDictionary.getInMemorySize(nrValues * nrColumns);
        }
        if (nrColumns > 1 && tupleSparsity < 0.4) {
            return MatrixBlockDictionary.getInMemorySize(nrValues, nrColumns, tupleSparsity);
        }
        return Dictionary.getInMemorySize(nrValues * nrColumns);
    }

    public static ADictionary create(ABitmap ubm) {
        return DictionaryFactory.create(ubm, 1.0);
    }

    public static ADictionary create(ABitmap ubm, double sparsity, boolean withZeroTuple) {
        return withZeroTuple ? DictionaryFactory.createWithAppendedZeroTuple(ubm, sparsity) : DictionaryFactory.create(ubm, sparsity);
    }

    public static ADictionary create(ABitmap ubm, double sparsity) {
        if (ubm instanceof BitmapLossy) {
            return new QDictionary((BitmapLossy)ubm);
        }
        if (ubm instanceof Bitmap) {
            return new Dictionary(((Bitmap)ubm).getValues());
        }
        if (sparsity < 0.4 && ubm instanceof MultiColBitmap) {
            int nCols = ubm.getNumColumns();
            int nRows = ubm.getNumValues();
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(nRows, nCols, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            int nVals = ubm.getNumValues();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCols; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            return new MatrixBlockDictionary(m);
        }
        if (ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            int nCol = ubm.getNumColumns();
            int nVals = ubm.getNumValues();
            double[] resValues = new double[nVals * nCol];
            for (int i = 0; i < nVals; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCol, nCol);
            }
            return new Dictionary(resValues);
        }
        throw new NotImplementedException("Not implemented creation of bitmap type : " + ubm.getClass().getSimpleName());
    }

    public static ADictionary createWithAppendedZeroTuple(ABitmap ubm) {
        return DictionaryFactory.createWithAppendedZeroTuple(ubm, 1.0);
    }

    public static ADictionary createWithAppendedZeroTuple(ABitmap ubm, double sparsity) {
        int nRows = ubm.getNumValues() + 1;
        int nCols = ubm.getNumColumns();
        if (ubm instanceof Bitmap) {
            Bitmap bm = (Bitmap)ubm;
            double[] resValues = new double[ubm.getNumValues() + 1];
            double[] from = bm.getValues();
            System.arraycopy(from, 0, resValues, 0, from.length);
            return new Dictionary(resValues);
        }
        if (sparsity < 0.4 && ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(nRows, nCols, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            int nVals = ubm.getNumValues();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCols; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            return new MatrixBlockDictionary(m);
        }
        if (ubm instanceof MultiColBitmap) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            int nVals = ubm.getNumValues();
            double[] resValues = new double[nRows * nCols];
            for (int i = 0; i < nVals; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCols, nCols);
            }
            return new Dictionary(resValues);
        }
        throw new NotImplementedException("Not implemented creation of bitmap type : " + ubm.getClass().getSimpleName());
    }

    public static ADictionary moveFrequentToLastDictionaryEntry(ADictionary dict, ABitmap ubm, int nRow, int largestIndex) {
        int zeros = nRow - (int)ubm.getNumOffsets();
        int nCol = ubm.getNumColumns();
        int largestIndexSize = ubm.getOffsetsList(largestIndex).size();
        if (dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary mbd = (MatrixBlockDictionary)dict;
            MatrixBlock mb = mbd.getMatrixBlock();
            if (mb.isEmpty()) {
                if (zeros == 0) {
                    return dict;
                }
                return new MatrixBlockDictionary(new MatrixBlock(mb.getNumRows() + 1, mb.getNumColumns(), true));
            }
            if (mb.isInSparseFormat()) {
                MatrixBlockDictionary mbdn = DictionaryFactory.moveToLastDictionaryEntrySparse(mb.getSparseBlock(), largestIndex, zeros, nCol, largestIndexSize);
                MatrixBlock mbn = mbdn.getMatrixBlock();
                mbn.setNonZeros(mb.getNonZeros());
                if (mbn.getNonZeros() == 0L) {
                    mbn.recomputeNonZeros();
                }
                return mbdn;
            }
            return DictionaryFactory.moveToLastDictionaryEntryDense(mb.getDenseBlockValues(), largestIndex, zeros, nCol, largestIndexSize);
        }
        return DictionaryFactory.moveToLastDictionaryEntryDense(dict.getValues(), largestIndex, zeros, nCol, largestIndexSize);
    }

    private static MatrixBlockDictionary moveToLastDictionaryEntrySparse(SparseBlock sb, int indexToMove, int zeros, int nCol, int largestIndexSize) {
        if (zeros == 0) {
            MatrixBlock ret = new MatrixBlock(sb.numRows(), nCol, true);
            ret.setSparseBlock(sb);
            SparseRow swap = sb.get(indexToMove);
            for (int i = indexToMove + 1; i < sb.numRows(); ++i) {
                sb.set(i - 1, sb.get(i), false);
            }
            sb.set(sb.numRows() - 1, swap, false);
            return new MatrixBlockDictionary(ret);
        }
        MatrixBlock ret = new MatrixBlock(sb.numRows() + 1, nCol, true);
        ret.allocateSparseRowsBlock();
        SparseBlock retB = ret.getSparseBlock();
        if (zeros > largestIndexSize) {
            for (int i = 0; i < sb.numRows(); ++i) {
                retB.set(i, sb.get(i), false);
            }
        } else {
            int i;
            for (i = 0; i < indexToMove; ++i) {
                retB.set(i, sb.get(i), false);
            }
            retB.set(sb.numRows(), sb.get(indexToMove), false);
            for (i = indexToMove + 1; i < sb.numRows(); ++i) {
                retB.set(i - 1, sb.get(i), false);
            }
        }
        return new MatrixBlockDictionary(ret);
    }

    private static ADictionary moveToLastDictionaryEntryDense(double[] values, int indexToMove, int zeros, int nCol, int largestIndexSize) {
        int offsetToLargest = indexToMove * nCol;
        if (zeros == 0) {
            double[] swap = new double[nCol];
            System.arraycopy(values, offsetToLargest, swap, 0, nCol);
            for (int i = offsetToLargest; i < values.length - nCol; ++i) {
                values[i] = values[i + nCol];
            }
            System.arraycopy(swap, 0, values, values.length - nCol, nCol);
            return new Dictionary(values);
        }
        double[] newDict = new double[values.length + nCol];
        if (zeros > largestIndexSize) {
            System.arraycopy(values, 0, newDict, 0, values.length);
        } else {
            System.arraycopy(values, 0, newDict, 0, offsetToLargest);
            System.arraycopy(values, offsetToLargest + nCol, newDict, offsetToLargest, values.length - offsetToLargest - nCol);
            System.arraycopy(values, offsetToLargest, newDict, newDict.length - nCol, nCol);
        }
        return new Dictionary(newDict);
    }

    public static enum Type {
        FP64_DICT,
        MATRIX_BLOCK_DICT,
        INT8_DICT;

    }
}

