/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysds.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.VariableSet;

public class RewriteSplitDagUnknownCSVRead
extends StatementBlockRewriteRule {
    @Override
    public boolean createsSplitDag() {
        return true;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus state) {
        if (DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE || !HopRewriteUtils.isLastLevelStatementBlock(sb)) {
            return Arrays.asList(sb);
        }
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        ArrayList<Hop> cand = new ArrayList<Hop>();
        this.collectCSVReadHopsUnknownSize(sb.getHops(), cand);
        if (!cand.isEmpty()) {
            try {
                StatementBlock sb1 = new StatementBlock();
                sb1.setDMLProg(sb.getDMLProg());
                sb1.setParseInfo(sb);
                sb1.setLiveIn(new VariableSet());
                sb1.setLiveOut(new VariableSet());
                ArrayList<Hop> sb1hops = new ArrayList<Hop>();
                for (Hop reblock : cand) {
                    for (int i = 0; i < reblock.getInput().size(); ++i) {
                        if (!(reblock.getInput().get(i) instanceof LiteralOp)) continue;
                        HopRewriteUtils.replaceChildReference(reblock, reblock.getInput().get(i), new LiteralOp((LiteralOp)reblock.getInput().get(i)));
                    }
                    DataOp tread = HopRewriteUtils.createTransientRead(reblock.getName(), reblock);
                    ArrayList<Hop> parents = new ArrayList<Hop>(reblock.getParent());
                    for (int i = 0; i < parents.size(); ++i) {
                        Hop parent = parents.get(i);
                        HopRewriteUtils.replaceChildReference(parent, reblock, tread);
                    }
                    DataOp twrite = HopRewriteUtils.createTransientWrite(reblock.getName(), reblock);
                    sb1hops.add(twrite);
                    DataIdentifier diVar = sb.variablesRead().getVariable(reblock.getName());
                    if (diVar == null) continue;
                    sb1.liveOut().addVariable(reblock.getName(), new DataIdentifier(diVar));
                    sb.liveIn().addVariable(reblock.getName(), new DataIdentifier(diVar));
                }
                sb1.setHops(sb1hops);
                sb1.updateRecompilationFlag();
                ret.add(sb1);
                ret.add(sb);
                sb.setSplitDag(true);
            }
            catch (Exception ex) {
                throw new HopsException("Failed to split hops dag for csv read with unknown size.", ex);
            }
            LOG.debug((Object)"Applied splitDagUnknownCSVRead.");
        } else {
            ret.add(sb);
        }
        return ret;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlocks(List<StatementBlock> sbs, ProgramRewriteStatus sate) {
        return sbs;
    }

    private void collectCSVReadHopsUnknownSize(ArrayList<Hop> roots, ArrayList<Hop> cand) {
        if (roots == null) {
            return;
        }
        Hop.resetVisitStatus(roots);
        for (Hop root : roots) {
            this.collectCSVReadHopsUnknownSize(root, cand);
        }
    }

    private void collectCSVReadHopsUnknownSize(Hop hop, ArrayList<Hop> cand) {
        DataOp dop;
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof DataOp && (dop = (DataOp)hop).getOp() == Types.OpOpData.PERSISTENTREAD && dop.getFileFormat() == Types.FileFormat.CSV && !dop.dimsKnown() && !HopRewriteUtils.hasOnlyWriteParents(dop, true, false)) {
            cand.add(dop);
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                this.collectCSVReadHopsUnknownSize(c, cand);
            }
        }
        hop.setVisited();
    }
}

