/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCOO;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class SparseBlockFactory {
    public static SparseBlock createSparseBlock(int rlen) {
        return SparseBlockFactory.createSparseBlock(MatrixBlock.DEFAULT_SPARSEBLOCK, rlen);
    }

    public static SparseBlock createSparseBlock(SparseBlock.Type type, int rlen) {
        switch (type) {
            case MCSR: {
                return new SparseBlockMCSR(rlen, -1);
            }
            case CSR: {
                return new SparseBlockCSR(rlen);
            }
            case COO: {
                return new SparseBlockCOO(rlen);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static SparseBlock createSparseBlock(SparseBlock.Type type, SparseRow row) {
        SparseBlock ret = SparseBlockFactory.createSparseBlock(type, 1);
        ret.set(0, row, true);
        return ret;
    }

    public static SparseBlock copySparseBlock(SparseBlock.Type type, SparseBlock sblock, boolean forceCopy) {
        if (sblock == null) {
            return null;
        }
        if (!forceCopy && SparseBlockFactory.isSparseBlockType(sblock, type)) {
            return sblock;
        }
        switch (type) {
            case MCSR: {
                return new SparseBlockMCSR(sblock);
            }
            case CSR: {
                return new SparseBlockCSR(sblock);
            }
            case COO: {
                return new SparseBlockCOO(sblock);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static boolean isSparseBlockType(SparseBlock sblock, SparseBlock.Type type) {
        return SparseBlockFactory.getSparseBlockType(sblock) == type;
    }

    public static SparseBlock.Type getSparseBlockType(SparseBlock sblock) {
        return sblock instanceof SparseBlockMCSR ? SparseBlock.Type.MCSR : (sblock instanceof SparseBlockCSR ? SparseBlock.Type.CSR : (sblock instanceof SparseBlockCOO ? SparseBlock.Type.COO : null));
    }

    public static long estimateSizeSparseInMemory(SparseBlock.Type type, long nrows, long ncols, double sparsity) {
        switch (type) {
            case MCSR: {
                return SparseBlockMCSR.estimateMemory(nrows, ncols, sparsity);
            }
            case CSR: {
                return SparseBlockCSR.estimateMemory(nrows, ncols, sparsity);
            }
            case COO: {
                return SparseBlockCOO.estimateMemory(nrows, ncols, sparsity);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }
}

