/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderRecode
extends Encoder {
    private static final long serialVersionUID = 8213163881283341874L;
    private HashMap<Integer, HashMap<String, Long>> _rcdMaps = new HashMap();
    private HashMap<Integer, HashSet<Object>> _rcdMapsPart = null;

    public EncoderRecode(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        if (parsedSpec.containsKey("recode")) {
            this._colList = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, "recode");
        }
    }

    public HashMap<Integer, HashMap<String, Long>> getCPRecodeMaps() {
        return this._rcdMaps;
    }

    public HashMap<Integer, HashSet<Object>> getCPRecodeMapsPartial() {
        return this._rcdMapsPart;
    }

    private long lookupRCDMap(int colID, String key) {
        if (!this._rcdMaps.containsKey(colID)) {
            return -1L;
        }
        Long tmp = this._rcdMaps.get(colID).get(key);
        return tmp != null ? tmp : -1L;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        if (!this.isApplicable()) {
            return out;
        }
        this.build(in);
        this.apply(in, out);
        return out;
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        Iterator<String[]> iter = in.getStringRowIterator(this._colList);
        while (iter.hasNext()) {
            String[] row = iter.next();
            for (int j = 0; j < this._colList.length; ++j) {
                int colID = this._colList[j];
                if (!this._rcdMaps.containsKey(colID)) {
                    this._rcdMaps.put(colID, new HashMap());
                }
                HashMap<String, Long> map = this._rcdMaps.get(colID);
                String key = row[j];
                if (key == null || key.isEmpty() || map.containsKey(key)) continue;
                map.put(key, Long.valueOf(map.size() + 1));
            }
        }
    }

    public void buildPartial(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        if (this._rcdMapsPart == null) {
            this._rcdMapsPart = new HashMap();
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            if (!this._rcdMapsPart.containsKey(colID)) {
                this._rcdMapsPart.put(colID, new HashSet());
            }
            HashSet<Object> map = this._rcdMapsPart.get(colID);
            for (int i = 0; i < in.getNumRows(); ++i) {
                map.add(in.get(i, colID - 1));
            }
            map.remove(null);
            map.remove("");
        }
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object okey = in.get(i, colID - 1);
                String key = okey != null ? okey.toString() : null;
                long code = this.lookupRCDMap(colID, key);
                out.quickSetValue(i, colID - 1, code >= 0L ? (double)code : Double.NaN);
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        int maxDistinct = 0;
        for (int j = 0; j < this._colList.length; ++j) {
            if (!this._rcdMaps.containsKey(this._colList[j])) continue;
            maxDistinct = Math.max(maxDistinct, this._rcdMaps.get(this._colList[j]).size());
        }
        meta.ensureAllocatedColumns(maxDistinct);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int rowID = 0;
            if (this._rcdMaps.containsKey(this._colList[j])) {
                for (Map.Entry<String, Long> e : this._rcdMaps.get(colID).entrySet()) {
                    meta.set(rowID++, colID - 1, EncoderRecode.constructRecodeMapEntry(e.getKey(), e.getValue(), sb));
                }
            }
            meta.getColumnMetadata(colID - 1).setNumDistinct(this._rcdMaps.get(colID).size());
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._rcdMaps.put(colID, meta.getRecodeMap(colID - 1));
        }
    }

    public static String constructRecodeMapEntry(String token, Long code) {
        StringBuilder sb = new StringBuilder(token.length() + 16);
        return EncoderRecode.constructRecodeMapEntry(token, code, sb);
    }

    private static String constructRecodeMapEntry(String token, Long code, StringBuilder sb) {
        sb.setLength(0);
        return sb.append(token).append("\u00b7").append(code).toString();
    }

    public static String[] splitRecodeMapEntry(String value) {
        int pos = value.toString().lastIndexOf("\u00b7");
        return new String[]{value.substring(0, pos), value.substring(pos + 1)};
    }
}

