/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;

public class CSVReblockReducer
extends ReduceBase
implements Reducer<TaggedFirstSecondIndexes, CSVReblockMR.BlockRow, MatrixIndexes, MatrixBlock> {
    public void reduce(TaggedFirstSecondIndexes key, Iterator<CSVReblockMR.BlockRow> values, OutputCollector<MatrixIndexes, MatrixBlock> out, Reporter reporter) throws IOException {
        long start = System.currentTimeMillis();
        this.commonSetup(reporter);
        this.cachedValues.reset();
        this.processCSVReblock(key, values, this.dimensions);
        this.processReducerInstructions();
        this.outputResultsFromCachedValues(reporter);
        reporter.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - start);
    }

    protected void processCSVReblock(TaggedFirstSecondIndexes indexes, Iterator<CSVReblockMR.BlockRow> values, HashMap<Byte, MatrixCharacteristics> dimensions) throws IOException {
        try {
            Byte tag = indexes.getTag();
            IndexedMatrixValue block = this.cachedValues.getFirst(tag);
            while (values.hasNext()) {
                CSVReblockMR.BlockRow row = values.next();
                if (block == null) {
                    block = this.cachedValues.holdPlace(tag, this.valueClass);
                    int brlen = dimensions.get(tag).getRowsPerBlock();
                    int bclen = dimensions.get(tag).getColsPerBlock();
                    int realBrlen = (int)Math.min((long)brlen, dimensions.get(tag).getRows() - (indexes.getFirstIndex() - 1L) * (long)brlen);
                    int realBclen = (int)Math.min((long)bclen, dimensions.get(tag).getCols() - (indexes.getSecondIndex() - 1L) * (long)bclen);
                    block.getValue().reset(realBrlen, realBclen, false);
                    block.getIndexes().setIndexes(indexes.getFirstIndex(), indexes.getSecondIndex());
                }
                MatrixBlock mb = (MatrixBlock)block.getValue();
                mb.copy(row.indexInBlock, row.indexInBlock, 0, row.data.getNumColumns() - 1, row.data, false);
            }
            ((MatrixBlock)block.getValue()).recomputeNonZeros();
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void configure(JobConf job) {
        CSVReblockInstruction[] reblockInstructions;
        MRJobConfiguration.setMatrixValueClass(job, true);
        super.configure(job);
        try {
            reblockInstructions = MRJobConfiguration.getCSVReblockInstructions(job);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        for (CSVReblockInstruction ins : reblockInstructions) {
            this.dimensions.put(ins.output, MRJobConfiguration.getMatrixCharactristicsForReblock(job, ins.output));
        }
    }
}

