/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NLineInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.io.IOUtilFunctions;

public class RemoteParForColocatedFileSplit
extends FileSplit {
    private String _fname = null;
    private int _blen = 1;

    private RemoteParForColocatedFileSplit() {
        super(null, -1L, -1L, new String[0]);
    }

    public RemoteParForColocatedFileSplit(FileSplit split, String fname, int blen) throws IOException {
        super(split.getPath(), split.getStart(), split.getLength(), split.getLocations());
        this._fname = fname;
        this._blen = blen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLocations() throws IOException {
        JobConf job = new JobConf(ConfigurationManager.getCachedJobConf());
        FileSystem fs = IOUtilFunctions.getFileSystem(this.getPath(), job);
        LongWritable key = new LongWritable();
        Text value = new Text();
        RecordReader reader = null;
        try {
            reader = new NLineInputFormat().getRecordReader((InputSplit)this, job, Reporter.NULL);
            reader.next(key, value);
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
        Task t = Task.parseCompactString(value.toString());
        HashMap<String, Integer> hosts = new HashMap<String, Integer>();
        if (t.getType() == Task.TaskType.SET) {
            for (IntObject val : t.getIterations()) {
                BlockLocation[] tmp1;
                String fname = this._fname + "/" + String.valueOf((val.getLongValue() - 1L) / (long)this._blen + 1L);
                FileStatus status = fs.getFileStatus(new Path(fname));
                for (BlockLocation bl : tmp1 = fs.getFileBlockLocations(status, 0L, status.getLen())) {
                    RemoteParForColocatedFileSplit.countHosts(hosts, bl.getHosts());
                }
            }
        } else {
            long lFrom = t.getIterations().get(0).getLongValue();
            long lTo = t.getIterations().get(1).getLongValue();
            for (long li : new long[]{lFrom, lTo}) {
                BlockLocation[] tmp1;
                String fname = this._fname + "/" + String.valueOf((li - 1L) / (long)this._blen + 1L);
                FileStatus status = fs.getFileStatus(new Path(fname));
                for (BlockLocation bl : tmp1 = fs.getFileBlockLocations(status, 0L, status.getLen())) {
                    RemoteParForColocatedFileSplit.countHosts(hosts, bl.getHosts());
                }
            }
        }
        return RemoteParForColocatedFileSplit.getTopHosts(hosts);
    }

    private static void countHosts(HashMap<String, Integer> hosts, String[] names) {
        for (String name : names) {
            Integer tmp = hosts.get(name);
            if (tmp != null) {
                hosts.put(name, tmp + 1);
                continue;
            }
            hosts.put(name, 1);
        }
    }

    private static String[] getTopHosts(HashMap<String, Integer> hosts) {
        int max = Integer.MIN_VALUE;
        HashSet<String> maxName = new HashSet<String>();
        for (Map.Entry<String, Integer> e : hosts.entrySet()) {
            if (e.getValue() > max) {
                maxName.clear();
                max = e.getValue();
                maxName.add(e.getKey());
                continue;
            }
            if (e.getValue() != max) continue;
            maxName.add(e.getKey());
        }
        return maxName.toArray(new String[0]);
    }
}

