/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.xml.sax.Attributes;

public class RemoteException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final int errorCode;
    private String className;

    public RemoteException(String className, String msg) {
        super(msg);
        this.className = className;
        this.errorCode = -1;
    }

    public RemoteException(String className, String msg, RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto erCode) {
        super(msg);
        this.className = className;
        this.errorCode = erCode != null ? erCode.getNumber() : -1;
    }

    public String getClassName() {
        return this.className;
    }

    public RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto getErrorCode() {
        return RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.valueOf((int)this.errorCode);
    }

    public IOException unwrapRemoteException(Class<?> ... lookupTypes) {
        if (lookupTypes == null) {
            return this;
        }
        for (Class<?> lookupClass : lookupTypes) {
            if (!lookupClass.getName().equals(this.getClassName())) continue;
            try {
                return this.instantiateException(lookupClass.asSubclass(IOException.class));
            }
            catch (Exception e) {
                return this;
            }
        }
        return this;
    }

    public IOException unwrapRemoteException() {
        try {
            Class<?> realClass = Class.forName(this.getClassName());
            return this.instantiateException(realClass.asSubclass(IOException.class));
        }
        catch (Exception exception) {
            return this;
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        IOException ex = cn.newInstance(this.getMessage());
        ex.initCause(this);
        return ex;
    }

    public static RemoteException valueOf(Attributes attrs) {
        return new RemoteException(attrs.getValue("class"), attrs.getValue("message"));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.className + "): " + this.getMessage();
    }
}

