/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.functions.ComputeBinaryBlockNnzFunction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.io.FileFormatProperties;
import org.apache.sysml.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.MapReduceTool;

public class WriteSPInstruction
extends SPInstruction {
    private CPOperand input1 = null;
    private CPOperand input2 = null;
    private CPOperand input3 = null;
    private CPOperand input4 = null;
    private FileFormatProperties formatProperties;

    private WriteSPInstruction(CPOperand in1, CPOperand in2, CPOperand in3, String opcode, String str) {
        super(SPInstruction.SPType.Write, opcode, str);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.formatProperties = null;
    }

    public static WriteSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equals("write")) {
            throw new DMLRuntimeException("Unsupported opcode");
        }
        if (parts.length != 5 && parts.length != 9) {
            throw new DMLRuntimeException("Invalid number of operands in write instruction: " + str);
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        WriteSPInstruction inst = new WriteSPInstruction(in1, in2, in3, opcode, str);
        if (in3.getName().equalsIgnoreCase("csv")) {
            CPOperand in4;
            boolean hasHeader = Boolean.parseBoolean(parts[4]);
            String delim = parts[5];
            boolean sparse = Boolean.parseBoolean(parts[6]);
            FileFormatPropertiesCSV formatProperties = new FileFormatPropertiesCSV(hasHeader, delim, sparse);
            inst.setFormatProperties(formatProperties);
            inst.input4 = in4 = new CPOperand(parts[8]);
        } else {
            CPOperand in4;
            FileFormatProperties ffp = new FileFormatProperties();
            inst.input4 = in4 = new CPOperand(parts[4]);
            inst.setFormatProperties(ffp);
        }
        return inst;
    }

    public FileFormatProperties getFormatProperties() {
        return this.formatProperties;
    }

    public void setFormatProperties(FileFormatProperties prop) {
        this.formatProperties = prop;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String fname = ec.getScalarInput(this.input2.getName(), Expression.ValueType.STRING, this.input2.isLiteral()).getStringValue();
        String desc = ec.getScalarInput(this.input4.getName(), Expression.ValueType.STRING, this.input4.isLiteral()).getStringValue();
        this.formatProperties.setDescription(desc);
        Expression.ValueType[] schema = this.input1.getDataType() == Expression.DataType.FRAME ? sec.getFrameObject(this.input1.getName()).getSchema() : null;
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fname);
            String outFmt = this.input3.getName();
            OutputInfo oi = OutputInfo.stringToOutputInfo(outFmt);
            if (this.input1.getDataType() == Expression.DataType.MATRIX) {
                this.processMatrixWriteInstruction(sec, fname, oi);
            } else {
                this.processFrameWriteInstruction(sec, fname, oi, schema);
            }
        }
        catch (IOException ex) {
            throw new DMLRuntimeException("Failed to process write instruction", ex);
        }
    }

    protected void processMatrixWriteInstruction(SparkExecutionContext sec, String fname, OutputInfo oi) throws IOException {
        JavaPairRDD in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        if (oi == OutputInfo.MatrixMarketOutputInfo || oi == OutputInfo.TextCellOutputInfo) {
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            JavaRDD header = null;
            if (oi == OutputInfo.MatrixMarketOutputInfo) {
                ArrayList<String> headerContainer = new ArrayList<String>(1);
                String headerStr = "%%MatrixMarket matrix coordinate real general\n" + mc.getRows() + " " + mc.getCols() + " " + mc.getNonZeros();
                headerContainer.add(headerStr);
                header = sec.getSparkContext().parallelize(headerContainer);
            }
            JavaRDD<String> ijv = RDDConverterUtils.binaryBlockToTextCell(in1, mc);
            if (header != null) {
                WriteSPInstruction.customSaveTextFile((JavaRDD<String>)header.union(ijv), fname, true);
            } else {
                WriteSPInstruction.customSaveTextFile(ijv, fname, false);
            }
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
        } else if (oi == OutputInfo.CSVOutputInfo) {
            if (mc.getRows() == 0L || mc.getCols() == 0L) {
                throw new IOException("Write of matrices with zero rows or columns not supported (" + mc.getRows() + "x" + mc.getCols() + ").");
            }
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            JavaRDD<String> out = RDDConverterUtils.binaryBlockToCsv((JavaPairRDD<MatrixIndexes, MatrixBlock>)in1, mc, (FileFormatPropertiesCSV)this.formatProperties, true);
            WriteSPInstruction.customSaveTextFile(out, fname, false);
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
        } else if (oi == OutputInfo.BinaryBlockOutputInfo) {
            LongAccumulator aNnz = null;
            if (!mc.nnzKnown()) {
                aNnz = sec.getSparkContext().sc().longAccumulator("nnz");
                in1 = in1.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
            }
            in1.saveAsHadoopFile(fname, MatrixIndexes.class, MatrixBlock.class, SequenceFileOutputFormat.class);
            if (!mc.nnzKnown()) {
                mc.setNonZeros(aNnz.value());
            }
        } else {
            throw new DMLRuntimeException("Unexpected data format: " + OutputInfo.outputInfoToString(oi));
        }
        MapReduceTool.writeMetaDataFile(fname + ".mtd", Expression.ValueType.DOUBLE, mc, oi, this.formatProperties);
    }

    protected void processFrameWriteInstruction(SparkExecutionContext sec, String fname, OutputInfo oi, Expression.ValueType[] schema) throws IOException {
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        if (oi == OutputInfo.TextCellOutputInfo) {
            JavaRDD<String> out = FrameRDDConverterUtils.binaryBlockToTextCell(in1, mc);
            WriteSPInstruction.customSaveTextFile(out, fname, false);
        } else if (oi == OutputInfo.CSVOutputInfo) {
            FileFormatPropertiesCSV props = this.formatProperties != null ? (FileFormatPropertiesCSV)this.formatProperties : null;
            JavaRDD<String> out = FrameRDDConverterUtils.binaryBlockToCsv(in1, mc, props, true);
            WriteSPInstruction.customSaveTextFile(out, fname, false);
        } else if (oi == OutputInfo.BinaryBlockOutputInfo) {
            JavaPairRDD out = in1.mapToPair((PairFunction)new FrameRDDConverterUtils.LongFrameToLongWritableFrameFunction());
            out.saveAsHadoopFile(fname, LongWritable.class, FrameBlock.class, SequenceFileOutputFormat.class);
        } else {
            throw new DMLRuntimeException("Unexpected data format: " + OutputInfo.outputInfoToString(oi));
        }
        MapReduceTool.writeMetaDataFile(fname + ".mtd", this.input1.getValueType(), schema, Expression.DataType.FRAME, mc, oi, this.formatProperties);
    }

    private static void customSaveTextFile(JavaRDD<String> rdd, String fname, boolean inSingleFile) {
        if (inSingleFile) {
            Random rand = new Random();
            String randFName = fname + "_" + rand.nextLong() + "_" + rand.nextLong();
            try {
                while (MapReduceTool.existsFileOnHDFS(randFName)) {
                    randFName = fname + "_" + rand.nextLong() + "_" + rand.nextLong();
                }
                rdd.saveAsTextFile(randFName);
                MapReduceTool.mergeIntoSingleFile(randFName, fname);
            }
            catch (IOException e) {
                throw new DMLRuntimeException("Cannot merge the output into single file: " + e.getMessage());
            }
            finally {
                try {
                    MapReduceTool.deleteFileIfExistOnHDFS(randFName);
                }
                catch (IOException e) {
                    throw new DMLRuntimeException("Cannot merge the output into single file: " + e.getMessage());
                }
            }
        }
        rdd.saveAsTextFile(fname);
    }
}

