/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.NaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;

public class RewriteRemoveDanglingParentReferences
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        int numRm = 0;
        for (Hop h : roots) {
            numRm += this.removeDanglingParentReferences(h, false);
        }
        if (LOG.isDebugEnabled() && numRm > 0) {
            LOG.debug((Object)("Remove Dangling Parents - removed " + numRm + " operators."));
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return root;
        }
        int numRm = this.removeDanglingParentReferences(root, true);
        if (LOG.isDebugEnabled() && numRm > 0) {
            LOG.debug((Object)("Remove Dangling Parents - removed " + numRm + " operators."));
        }
        return root;
    }

    private int removeDanglingParentReferences(Hop hop, boolean pin) {
        if (hop.isVisited()) {
            return 0;
        }
        hop.setVisited();
        int count = 0;
        for (int i = 0; i < hop.getParent().size(); ++i) {
            Hop p = hop.getParent().get(i);
            count += this.removeDanglingParentReferences(p, false);
            i -= hop.getParent().contains(p) ? 0 : 1;
        }
        ArrayList<Hop> inputs = hop.getInput();
        if (!pin && hop.getParent().isEmpty() && !RewriteRemoveDanglingParentReferences.isValidRootNode(hop)) {
            HopRewriteUtils.cleanupUnreferenced(hop);
            ++count;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            count += this.removeDanglingParentReferences(inputs.get(i), false);
        }
        return count;
    }

    private static boolean isValidRootNode(Hop hop) {
        return hop instanceof DataOp && ((DataOp)hop).isWrite() || hop instanceof UnaryOp && ((UnaryOp)hop).getOp() == Hop.OpOp1.STOP || hop instanceof UnaryOp && ((UnaryOp)hop).getOp() == Hop.OpOp1.PRINT || hop instanceof UnaryOp && ((UnaryOp)hop).getOp() == Hop.OpOp1.ASSERT || hop instanceof NaryOp && ((NaryOp)hop).getOp() == Hop.OpOpN.PRINTF || hop instanceof FunctionOp || hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.FUNCTIONOUTPUT;
    }
}

