/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public final class RegexUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexUtils.class);
    public static final Pattern MATCH_NOTHING_PATTERN = Pattern.compile("a^");

    public static boolean isValidRegex(String pattern) {
        try {
            if (StringUtils.isNotBlank((CharSequence)pattern)) {
                Pattern.compile(pattern);
                return true;
            }
        }
        catch (PatternSyntaxException exception) {
            LOGGER.debug("Pattern [{}] is not a valid regex.", (Object)pattern);
        }
        return false;
    }

    public static Pattern concatenate(Collection<?> requiredValues, boolean caseInsensitive) {
        String pattern = requiredValues.stream().map(Object::toString).collect(Collectors.joining("|", "(", ")"));
        return RegexUtils.createPattern(pattern, caseInsensitive ? 2 : 0);
    }

    public static Pattern createPattern(String pattern) {
        return RegexUtils.createPattern(pattern, 2);
    }

    public static Pattern createPattern(String pattern, int flags) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            LOGGER.warn("Pattern cannot be null/blank");
            return MATCH_NOTHING_PATTERN;
        }
        try {
            return Pattern.compile(pattern, flags);
        }
        catch (PatternSyntaxException exception) {
            LOGGER.debug("Pattern [{}] is not a valid regex.", (Object)pattern);
            return MATCH_NOTHING_PATTERN;
        }
    }

    public static boolean matches(Pattern pattern, String value) {
        return pattern.matcher(value).matches();
    }

    public static boolean matches(Pattern pattern, String value, boolean completeMatch) {
        Matcher matcher = pattern.matcher(value);
        LOGGER.debug("Matching value [{}] against pattern [{}]", (Object)value, (Object)pattern.pattern());
        if (completeMatch) {
            return matcher.matches();
        }
        return matcher.find();
    }

    public static boolean find(Pattern pattern, String value) {
        return pattern.matcher(value).find();
    }

    public static boolean find(String pattern, String value) {
        return StringUtils.isNotBlank((CharSequence)value) && RegexUtils.createPattern(pattern, 2).matcher(value).find();
    }

    public static Optional<String> findFirst(String pattern, Collection elements) {
        Pattern compiledPattern = RegexUtils.createPattern(pattern);
        return elements.stream().filter(entry -> RegexUtils.find(compiledPattern, entry.toString())).findFirst();
    }

    public static Optional<String> findFirst(Collection<String> patterns, Collection elements) {
        return patterns.stream().map(RegexUtils::createPattern).flatMap(compiledPattern -> elements.stream().filter(r -> RegexUtils.find(compiledPattern, r.toString()))).findFirst();
    }

    public static boolean matchesIpAddress(String pattern, String remoteAddr) {
        try {
            IpAddressMatcher ipAddressMatcher = new IpAddressMatcher(pattern);
            LOGGER.trace("Attempting to match [{}] against [{}] as a IP or netmask", (Object)remoteAddr, (Object)pattern);
            return ipAddressMatcher.matches(remoteAddr);
        }
        catch (Exception e) {
            LOGGER.trace("Falling back to regex match. Couldn't treat [{}] as an IP address or netmask: [{}]", (Object)pattern, (Object)e.getMessage());
            return RegexUtils.find(pattern, remoteAddr);
        }
    }

    @Generated
    private RegexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

