/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.RegisteredClaims;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.impl.PayloadImpl;
import com.auth0.jwt.interfaces.Payload;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class PayloadDeserializer
extends StdDeserializer<Payload> {
    private final ObjectReader objectReader;

    PayloadDeserializer(ObjectReader reader) {
        this(null, reader);
    }

    private PayloadDeserializer(Class<?> vc, ObjectReader reader) {
        super(vc);
        this.objectReader = reader;
    }

    public Payload deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map tree = (Map)p.getCodec().readValue(p, (TypeReference)new TypeReference<Map<String, JsonNode>>(){});
        if (tree == null) {
            throw new JWTDecodeException("Parsing the Payload's JSON resulted on a Null map");
        }
        String issuer = this.getString(tree, RegisteredClaims.ISSUER);
        String subject = this.getString(tree, RegisteredClaims.SUBJECT);
        List<String> audience = this.getStringOrArray(tree, RegisteredClaims.AUDIENCE);
        Instant expiresAt = this.getInstantFromSeconds(tree, RegisteredClaims.EXPIRES_AT);
        Instant notBefore = this.getInstantFromSeconds(tree, RegisteredClaims.NOT_BEFORE);
        Instant issuedAt = this.getInstantFromSeconds(tree, RegisteredClaims.ISSUED_AT);
        String jwtId = this.getString(tree, RegisteredClaims.JWT_ID);
        return new PayloadImpl(issuer, subject, audience, expiresAt, notBefore, issuedAt, jwtId, tree, this.objectReader);
    }

    List<String> getStringOrArray(Map<String, JsonNode> tree, String claimName) throws JWTDecodeException {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull() || !node.isArray() && !node.isTextual()) {
            return null;
        }
        if (node.isTextual() && !node.asText().isEmpty()) {
            return Collections.singletonList(node.asText());
        }
        ArrayList<String> list = new ArrayList<String>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            try {
                list.add((String)this.objectReader.treeToValue((TreeNode)node.get(i), String.class));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to String", e);
            }
        }
        return list;
    }

    Instant getInstantFromSeconds(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        if (!node.canConvertToLong()) {
            throw new JWTDecodeException(String.format("The claim '%s' contained a non-numeric date value.", claimName));
        }
        return Instant.ofEpochSecond(node.asLong());
    }

    String getString(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText(null);
    }
}

