/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.authentication.credential.AbstractCredential;
import org.pac4j.core.credentials.AnonymousCredentials;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.UserProfile;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class ClientCredential
extends AbstractCredential {
    public static final String NOT_YET_AUTHENTICATED = "NotYetAuthenticated-";
    public static final String AUTHENTICATION_ATTRIBUTE_CLIENT_NAME = "clientName";
    private static final long serialVersionUID = -7883301304291894763L;
    private final Credentials credentials;
    private final String clientName;
    private boolean typedIdUsed = true;
    private UserProfile userProfile;

    public ClientCredential(String clientName, UserProfile userProfile) {
        this.credentials = new AnonymousCredentials();
        this.clientName = clientName;
        this.userProfile = userProfile;
    }

    public UserProfile getUserProfile() {
        return Optional.ofNullable(this.userProfile).orElseGet(() -> ((Credentials)this.credentials).getUserProfile());
    }

    public String getId() {
        UserProfile up = this.getUserProfile();
        if (up != null) {
            return this.typedIdUsed ? up.getTypedId() : up.getId();
        }
        return NOT_YET_AUTHENTICATED + String.valueOf(UUID.randomUUID());
    }

    @Generated
    public String toString() {
        return "ClientCredential(credentials=" + String.valueOf(this.credentials) + ", clientName=" + this.clientName + ", typedIdUsed=" + this.typedIdUsed + ", userProfile=" + String.valueOf(this.userProfile) + ")";
    }

    @Generated
    public void setTypedIdUsed(boolean typedIdUsed) {
        this.typedIdUsed = typedIdUsed;
    }

    @Generated
    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    @Generated
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public boolean isTypedIdUsed() {
        return this.typedIdUsed;
    }

    @Generated
    public ClientCredential() {
        this.credentials = null;
        this.clientName = null;
    }

    @Generated
    public ClientCredential(Credentials credentials, String clientName) {
        this.credentials = credentials;
        this.clientName = clientName;
    }

    @Generated
    public ClientCredential(Credentials credentials, String clientName, boolean typedIdUsed, UserProfile userProfile) {
        this.credentials = credentials;
        this.clientName = clientName;
        this.typedIdUsed = typedIdUsed;
        this.userProfile = userProfile;
    }
}

