/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.expiration;

import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class FixedTtlExpirationAfterWriteStrategy
implements ExpirationAfterWriteStrategy,
ComparableByContent<FixedTtlExpirationAfterWriteStrategy> {
    private final long ttlMillis;
    public static final SerializationHandle<FixedTtlExpirationAfterWriteStrategy> SERIALIZATION_HANDLE = new SerializationHandle<FixedTtlExpirationAfterWriteStrategy>(){

        @Override
        public <S> FixedTtlExpirationAfterWriteStrategy deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_8_10_0, Versions.v_8_10_0);
            long keepAfterRefillDurationMillis = adapter.readLong(input);
            return new FixedTtlExpirationAfterWriteStrategy(Duration.ofMillis(keepAfterRefillDurationMillis));
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, FixedTtlExpirationAfterWriteStrategy strategy, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_8_10_0.getNumber());
            adapter.writeLong(output, strategy.ttlMillis);
        }

        @Override
        public int getTypeId() {
            return 71;
        }

        @Override
        public Class<FixedTtlExpirationAfterWriteStrategy> getSerializedType() {
            return FixedTtlExpirationAfterWriteStrategy.class;
        }

        @Override
        public FixedTtlExpirationAfterWriteStrategy fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_8_10_0, Versions.v_8_10_0);
            long keepAfterRefillDurationMillis = this.readLongValue(snapshot, "ttlMillis");
            return new FixedTtlExpirationAfterWriteStrategy(Duration.ofMillis(keepAfterRefillDurationMillis));
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(FixedTtlExpirationAfterWriteStrategy strategy, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_8_10_0.getNumber());
            result.put("ttlMillis", strategy.ttlMillis);
            return result;
        }

        @Override
        public String getTypeName() {
            return "FixedTtlExpirationAfterWriteStrategy";
        }
    };

    public FixedTtlExpirationAfterWriteStrategy(Duration ttl) {
        long ttlMillis = ttl.toMillis();
        if (ttlMillis <= 0L) {
            throw new IllegalArgumentException("ttl should be positive");
        }
        this.ttlMillis = ttlMillis;
    }

    @Override
    public long calculateTimeToLiveMillis(RemoteBucketState state, long currentTimeNanos) {
        return this.ttlMillis;
    }

    @Override
    public SerializationHandle<ExpirationAfterWriteStrategy> getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(FixedTtlExpirationAfterWriteStrategy other) {
        return this.ttlMillis == other.ttlMillis;
    }
}

