/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.web.flow.services.DefaultRegisteredServiceUserInterfaceInfo;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.LocalizedName;
import org.opensaml.saml.saml2.metadata.LocalizedURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlMetadataUIInfo
extends DefaultRegisteredServiceUserInterfaceInfo {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlMetadataUIInfo.class);
    private static final long serialVersionUID = -1434801982864628179L;
    private transient UIInfo uiInfo;
    private String locale;

    public SamlMetadataUIInfo(WebBasedRegisteredService registeredService, String locale) {
        this(null, registeredService);
        this.locale = locale;
    }

    public SamlMetadataUIInfo(UIInfo uiInfo, WebBasedRegisteredService registeredService) {
        super(registeredService);
        this.uiInfo = uiInfo;
    }

    private static Collection<String> getStringValues(List<?> items) {
        ArrayList<String> list = new ArrayList<String>(items.size());
        items.forEach(d -> {
            if (d instanceof XSURI) {
                XSURI value = (XSURI)d;
                list.add(value.getURI());
            } else if (d instanceof XSString) {
                XSString value = (XSString)d;
                list.add(value.getValue());
            }
        });
        return list;
    }

    private static String getLocalizedValues(String locale, List<?> items) {
        Optional<String> foundLocale = SamlMetadataUIInfo.findLocale((String)StringUtils.defaultIfBlank((CharSequence)locale, (CharSequence)"en"), items);
        if (foundLocale.isPresent()) {
            return foundLocale.get();
        }
        if (!items.isEmpty()) {
            LocalizedName instance;
            Object item = items.getFirst();
            String value = "";
            if (item instanceof LocalizedName) {
                instance = (LocalizedName)item;
                value = instance.getValue();
            }
            if (item instanceof LocalizedURI) {
                instance = (LocalizedURI)item;
                value = instance.getURI();
            }
            if (item instanceof XSString) {
                instance = (XSString)item;
                value = instance.getValue();
            }
            LOGGER.trace("Loading first available locale [{}]", (Object)value);
            return value;
        }
        return null;
    }

    private static Optional<String> findLocale(String locale, List<?> items) {
        LOGGER.trace("Looking for locale [{}]", (Object)locale);
        Pattern p = Pattern.compile(locale, 2);
        return items.stream().filter(LocalizedName.class::isInstance).map(LocalizedName.class::cast).filter(item -> {
            String xmlLang = item.getXMLLang();
            return StringUtils.isNotBlank((CharSequence)xmlLang) && p.matcher(xmlLang).matches() && StringUtils.isNotBlank((CharSequence)item.getValue());
        }).map(XSString::getValue).findFirst();
    }

    public String getDescription(String locale) {
        if (this.uiInfo != null) {
            String description = SamlMetadataUIInfo.getLocalizedValues(locale, this.uiInfo.getDescriptions());
            return Optional.ofNullable(description).orElseGet(() -> super.getDescription());
        }
        return super.getDescription();
    }

    public String getDescription() {
        return this.getDescription(this.locale);
    }

    public String getDisplayName() {
        return this.getDisplayName(this.locale);
    }

    public String getDisplayName(String locale) {
        if (this.uiInfo != null) {
            String displayName = SamlMetadataUIInfo.getLocalizedValues(locale, this.uiInfo.getDisplayNames());
            return Optional.ofNullable(displayName).orElseGet(() -> super.getDisplayName());
        }
        return super.getDisplayName();
    }

    public Collection<String> getDescriptions() {
        if (this.uiInfo != null) {
            return SamlMetadataUIInfo.getStringValues(this.uiInfo.getDescriptions());
        }
        return super.getDescriptions();
    }

    public Collection<String> getDisplayNames() {
        if (this.uiInfo != null) {
            return SamlMetadataUIInfo.getStringValues(this.uiInfo.getDisplayNames());
        }
        return super.getDescriptions();
    }

    public Collection<String> getInformationURLs() {
        if (this.uiInfo != null) {
            return SamlMetadataUIInfo.getStringValues(this.uiInfo.getInformationURLs());
        }
        return super.getInformationURLs();
    }

    public String getInformationURL() {
        return this.getInformationURL(this.locale);
    }

    public String getInformationURL(String locale) {
        if (this.uiInfo != null) {
            String informationUrl = SamlMetadataUIInfo.getLocalizedValues(locale, this.uiInfo.getInformationURLs());
            return Optional.ofNullable(informationUrl).orElseGet(() -> super.getInformationURL());
        }
        return super.getInformationURL();
    }

    public String getPrivacyStatementURL() {
        return this.getPrivacyStatementURL(this.locale);
    }

    public String getPrivacyStatementURL(String locale) {
        if (this.uiInfo != null) {
            String privacyStatementURL = SamlMetadataUIInfo.getLocalizedValues(locale, this.uiInfo.getPrivacyStatementURLs());
            return Optional.ofNullable(privacyStatementURL).orElseGet(() -> super.getPrivacyStatementURL());
        }
        return super.getPrivacyStatementURL();
    }

    public Collection<String> getPrivacyStatementURLs() {
        if (this.uiInfo != null) {
            return SamlMetadataUIInfo.getStringValues(this.uiInfo.getPrivacyStatementURLs());
        }
        return super.getPrivacyStatementURLs();
    }

    public Collection<DefaultRegisteredServiceUserInterfaceInfo.Logo> getLogoUrls() {
        if (this.uiInfo != null) {
            return this.uiInfo.getLogos().stream().map(l -> new DefaultRegisteredServiceUserInterfaceInfo.Logo(l.getURI(), (long)l.getHeight().intValue(), (long)l.getWidth().intValue())).collect(Collectors.toList());
        }
        return new ArrayList<DefaultRegisteredServiceUserInterfaceInfo.Logo>();
    }

    @Generated
    public String toString() {
        return "SamlMetadataUIInfo(super=" + super.toString() + ", uiInfo=" + String.valueOf(this.uiInfo) + ", locale=" + this.locale + ")";
    }

    @Generated
    public void setUiInfo(UIInfo uiInfo) {
        this.uiInfo = uiInfo;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public UIInfo getUiInfo() {
        return this.uiInfo;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }
}

