/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.TupleKey;

@JsonPropertyOrder(value={"key", "timestamp"})
public class Tuple {
    public static final String JSON_PROPERTY_KEY = "key";
    @Nonnull
    private TupleKey key;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    @Nonnull
    private OffsetDateTime timestamp;

    public Tuple key(@Nonnull TupleKey key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @JsonProperty(value="key", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TupleKey getKey() {
        return this.key;
    }

    @JsonProperty(value="key", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(@Nonnull TupleKey key) {
        this.key = key;
    }

    public Tuple timestamp(@Nonnull OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(@Nonnull OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.key, tuple.key) && Objects.equals(this.timestamp, tuple.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tuple {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getKey() != null) {
            joiner.add(this.getKey().toUrlQueryString((String)prefix + JSON_PROPERTY_KEY + suffix));
        }
        if (this.getTimestamp() != null) {
            joiner.add(String.format(Locale.ROOT, "%stimestamp%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getTimestamp()))));
        }
        return joiner.toString();
    }
}

