/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.List;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.web.flow.resolver.CasWebflowAware;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

class WebflowExceptionTranslator {
    private static final List<Class> SUPPORTED_EXCEPTIONS = List.of(AuthenticationException.class, AbstractTicketException.class, CasWebflowAware.class);

    WebflowExceptionTranslator() {
    }

    public static Event from(Throwable exception, RequestContext requestContext) {
        EventFactorySupport eventFactorySupport = new EventFactorySupport();
        if (WebflowExceptionTranslator.isSupportedException(exception)) {
            return eventFactorySupport.event((Object)exception, "authenticationFailure");
        }
        if (WebflowExceptionTranslator.isSupportedException(exception.getCause())) {
            return eventFactorySupport.event((Object)exception.getCause(), "authenticationFailure");
        }
        return eventFactorySupport.event((Object)exception, "error");
    }

    private static boolean isSupportedException(Throwable exception) {
        return exception != null && SUPPORTED_EXCEPTIONS.stream().anyMatch(type -> type.isAssignableFrom(exception.getClass()));
    }
}

