/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.oidc;

import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.service.OIDCJWKSService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class WAOIDCJWKSGeneratorService
implements OidcJsonWebKeystoreGeneratorService {
    protected static final Logger LOG = LoggerFactory.getLogger(WAOIDCJWKSGeneratorService.class);
    protected final WARestClient waRestClient;
    protected final String jwksKeyId;
    protected final String jwksType;
    protected final int jwksKeySize;

    public WAOIDCJWKSGeneratorService(WARestClient waRestClient, String jwksKeyId, String jwksType, int jwksKeySize) {
        this.waRestClient = waRestClient;
        this.jwksKeyId = jwksKeyId;
        this.jwksType = jwksType;
        this.jwksKeySize = jwksKeySize;
    }

    public JsonWebKeySet store(JsonWebKeySet jsonWebKeySet) {
        OIDCJWKSService service = (OIDCJWKSService)this.waRestClient.getService(OIDCJWKSService.class);
        OIDCJWKSTO to = new OIDCJWKSTO();
        to.setJson(jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
        service.set(to);
        return jsonWebKeySet;
    }

    public Optional<Resource> find() {
        return Optional.of(this.generate());
    }

    public Resource generate() {
        OIDCJWKSService service = (OIDCJWKSService)this.waRestClient.getService(OIDCJWKSService.class);
        OIDCJWKSTO jwksTO = null;
        try {
            jwksTO = service.get();
        }
        catch (SyncopeClientException e) {
            if (e.getType() == ClientExceptionType.NotFound) {
                try (Response response = service.generate(this.jwksKeyId, this.jwksType, this.jwksKeySize);){
                    jwksTO = (OIDCJWKSTO)response.readEntity(OIDCJWKSTO.class);
                }
                catch (Exception ge) {
                    LOG.error("While generating new OIDC JWKS", (Throwable)ge);
                }
            }
            LOG.error("While reading OIDC JWKS", (Throwable)e);
        }
        if (jwksTO == null) {
            throw new IllegalStateException("Unable to determine OIDC JWKS resource");
        }
        return new ByteArrayResource(jwksTO.getJson().getBytes(StandardCharsets.UTF_8), "OIDC JWKS");
    }
}

