/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.support.channel.HeaderChannelRegistry;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class DefaultHeaderChannelRegistry
extends IntegrationObjectSupport
implements HeaderChannelRegistry,
ManageableLifecycle,
Runnable {
    private static final int DEFAULT_REAPER_DELAY = 60000;
    protected static final AtomicLong id = new AtomicLong();
    protected final Map<String, MessageChannelWrapper> channels = new ConcurrentHashMap<String, MessageChannelWrapper>();
    protected final String uuid = String.valueOf(UUID.randomUUID()) + ":";
    private boolean removeOnGet;
    private long reaperDelay;
    private volatile ScheduledFuture<?> reaperScheduledFuture;
    private volatile boolean running;
    private volatile boolean explicitlyStopped;
    private final Lock lock = new ReentrantLock();

    public DefaultHeaderChannelRegistry() {
        this(60000L);
    }

    public DefaultHeaderChannelRegistry(long reaperDelay) {
        this.setReaperDelay(reaperDelay);
    }

    public final void setReaperDelay(long reaperDelay) {
        Assert.isTrue((reaperDelay > 0L ? 1 : 0) != 0, (String)"'reaperDelay' must be > 0");
        this.reaperDelay = reaperDelay;
    }

    public final long getReaperDelay() {
        return this.reaperDelay;
    }

    public void setRemoveOnGet(boolean removeOnGet) {
        this.removeOnGet = removeOnGet;
    }

    @Override
    public final int size() {
        return this.channels.size();
    }

    @Override
    public void start() {
        this.lock.lock();
        try {
            if (!this.running) {
                this.reaperScheduledFuture = this.getTaskScheduler().schedule((Runnable)this, Instant.now().plusMillis(this.reaperDelay));
                this.running = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.running = false;
            if (this.reaperScheduledFuture != null) {
                this.reaperScheduledFuture.cancel(true);
                this.reaperScheduledFuture = null;
            }
            this.explicitlyStopped = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    @Nullable
    public Object channelToChannelName(@Nullable Object channel) {
        return this.channelToChannelName(channel, this.reaperDelay);
    }

    @Override
    @Nullable
    public Object channelToChannelName(@Nullable Object channel, long timeToLive) {
        if (!this.running && !this.explicitlyStopped) {
            this.start();
        }
        if (channel instanceof MessageChannel) {
            MessageChannel messageChannel = (MessageChannel)channel;
            String name = this.uuid + id.incrementAndGet();
            this.channels.put(name, new MessageChannelWrapper(messageChannel, System.currentTimeMillis() + timeToLive));
            this.logger.debug(() -> "Registered " + String.valueOf(channel) + " as " + name);
            return name;
        }
        return channel;
    }

    @Override
    @Nullable
    public MessageChannel channelNameToChannel(@Nullable String name) {
        MessageChannelWrapper messageChannelWrapper;
        if (name != null && (messageChannelWrapper = this.removeOnGet ? this.channels.remove(name) : this.channels.get(name)) != null) {
            MessageChannel channel = messageChannelWrapper.channel();
            this.logger.debug(() -> "Retrieved " + String.valueOf(channel) + " with " + name);
            return channel;
        }
        return null;
    }

    @Override
    public void runReaper() {
        this.lock.lock();
        try {
            if (this.reaperScheduledFuture != null) {
                this.reaperScheduledFuture.cancel(true);
                this.reaperScheduledFuture = null;
            }
            this.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            this.logger.trace(() -> "Reaper started; channels size=" + this.channels.size());
            Iterator<Map.Entry<String, MessageChannelWrapper>> iterator = this.channels.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry<String, MessageChannelWrapper> entry = iterator.next();
                if (entry.getValue().expireAt() >= now) continue;
                this.logger.debug(() -> "Expiring " + (String)entry.getKey() + " (" + String.valueOf(((MessageChannelWrapper)entry.getValue()).channel()) + ")");
                iterator.remove();
            }
            if (this.isRunning()) {
                this.reaperScheduledFuture = this.getTaskScheduler().schedule((Runnable)this, Instant.now().plusMillis(this.reaperDelay));
            }
            this.logger.trace(() -> "Reaper completed; channels size=" + this.channels.size());
        }
        finally {
            this.lock.unlock();
        }
    }

    protected record MessageChannelWrapper(MessageChannel channel, long expireAt) {
    }
}

