/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.ErrorResponse;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequest;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequestMoreData;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequestStopData;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponseEnd;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePart;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePause;

public class RemoteOperationInvocationHandler
implements InvocationHandler {
    private final RemoteConnectorInfoImpl connectorInfo;
    private final String connectorFacadeKey;
    private final Class<? extends APIOperation> operation;

    public RemoteOperationInvocationHandler(RemoteConnectorInfoImpl connectorInfo, String connectorFacadeKey, Class<? extends APIOperation> operation) {
        this.connectorInfo = connectorInfo;
        this.connectorFacadeKey = connectorFacadeKey;
        this.operation = operation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        List simpleMarshallArgs = CollectionUtil.newList((Object[])args);
        ObjectStreamHandler streamHandlerArg = RemoteOperationInvocationHandler.extractStreamHandler(method.getParameterTypes(), simpleMarshallArgs);
        RemoteFrameworkConnectionInfo connectionInfo = this.connectorInfo.getRemoteConnectionInfo();
        OperationRequest request = new OperationRequest(this.connectorInfo.getConnectorKey(), this.connectorFacadeKey, this.operation, method.getName(), simpleMarshallArgs);
        RemoteFrameworkConnection connection = null;
        try {
            Object response;
            connection = new RemoteFrameworkConnection(connectionInfo);
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(connectionInfo.getKey());
            connection.writeObject(request);
            if (streamHandlerArg != null) {
                RemoteOperationInvocationHandler.handleStreamResponse(connection, streamHandlerArg);
            }
            if ((response = connection.readObject()) instanceof OperationResponsePart) {
                OperationResponsePart part = (OperationResponsePart)response;
                if (part.getException() != null) {
                    throw part.getException();
                }
                Object object = part.getResult();
                return object;
            }
            if (response instanceof ErrorResponse) {
                ErrorResponse error = (ErrorResponse)response;
                if (error.getException() != null) {
                    throw error.getException();
                }
                throw new ConnectorException("Received an invalid Error response object, exception parameter missing");
            }
            throw new ConnectorException("Received unknown response object type: " + response.getClass().getCanonicalName());
        }
        finally {
            if (null != connection) {
                connection.close();
            }
        }
    }

    private static void handleStreamResponse(RemoteFrameworkConnection connection, ObjectStreamHandler streamHandler) throws ConnectorException {
        Object response;
        boolean handleMore = true;
        while (true) {
            if ((response = connection.readObject()) instanceof OperationResponsePart) {
                OperationResponsePart part = (OperationResponsePart)response;
                if (part.getException() != null) {
                    throw part.getException();
                }
                Object object = part.getResult();
                if (!handleMore) continue;
                handleMore = streamHandler.handle(object);
                continue;
            }
            if (!(response instanceof OperationResponsePause)) break;
            if (handleMore) {
                connection.writeObject(new OperationRequestMoreData());
                continue;
            }
            connection.writeObject(new OperationRequestStopData());
        }
        if (!(response instanceof OperationResponseEnd)) {
            if (response instanceof ErrorResponse) {
                ErrorResponse error = (ErrorResponse)response;
                if (error.getException() != null) {
                    throw ConnectorException.wrap((Throwable)error.getException());
                }
                throw new ConnectorException("Received an invalid Error response object, exception parameter missing");
            }
            throw new ConnectorException("Unexpected response: " + String.valueOf(response));
        }
    }

    private static ObjectStreamHandler extractStreamHandler(Class<?>[] paramTypes, List<Object> arguments) {
        ObjectStreamHandler rv = null;
        ArrayList<Object> filteredArguments = new ArrayList<Object>();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Object arg = arguments.get(i);
            if (StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) {
                ObjectStreamHandler handler = StreamHandlerUtil.adaptToObjectStreamHandler(paramType, arg);
                if (rv != null) {
                    throw new UnsupportedOperationException("Multiple stream handlers not supported");
                }
                rv = handler;
                continue;
            }
            filteredArguments.add(arg);
        }
        arguments.clear();
        arguments.addAll(filteredArguments);
        return rv;
    }
}

