/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.SecurityContextUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PopulateSpringSecurityContextAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PopulateSpringSecurityContextAction.class);
    private final ObjectProvider<SecurityContextRepository> securityContextRepository;

    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        SecurityContext context = this.buildAuthenticationContext(requestContext);
        this.securityContextRepository.ifAvailable(secContext -> secContext.saveContext(context, request, response));
        SecurityContextHolder.setContext((SecurityContext)context);
        return null;
    }

    protected SecurityContext buildAuthenticationContext(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
        return SecurityContextUtils.createSecurityContext((Principal)principal, (HttpServletRequest)request);
    }

    protected Principal resolvePrincipal(Principal principal, RequestContext requestContext) {
        ArrayList resolvers = new ArrayList(requestContext.getActiveFlow().getApplicationContext().getBeansOfType(MultifactorAuthenticationPrincipalResolver.class).values());
        AnnotationAwareOrderComparator.sort(resolvers);
        return resolvers.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElse(principal);
    }

    @Generated
    public PopulateSpringSecurityContextAction(ObjectProvider<SecurityContextRepository> securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }
}

