/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.column;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.wicketstuff.egrid.column.panel.ActionsPanel;
import org.wicketstuff.egrid.component.EditableDataTable;

public class EditableActionsColumn<T, S>
extends AbstractColumn<T, S> {
    private static final long serialVersionUID = 1L;

    public EditableActionsColumn(IModel<String> displayModel) {
        super(displayModel);
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        Item rowItem = (Item)item.findParent(Item.class);
        item.add(new Component[]{this.newActionsPanel(componentId, rowItem)});
    }

    protected ActionsPanel<T> newActionsPanel(String componentId, final Item<T> rowItem) {
        return new ActionsPanel<T>(componentId, rowItem){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEdit(AjaxRequestTarget target) {
                super.onEdit(target);
                rowItem.setMetaData(EditableDataTable.EDITING, (Serializable)Boolean.valueOf(true));
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, rowItem);
                target.add(new Component[]{rowItem});
                EditableActionsColumn.this.onEdit(target, rowItem.getModel());
            }

            @Override
            protected void onCancel(AjaxRequestTarget target) {
                rowItem.setMetaData(EditableDataTable.EDITING, (Serializable)Boolean.valueOf(false));
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, rowItem);
                target.add(new Component[]{rowItem});
                EditableActionsColumn.this.onCancel(target, rowItem.getModel());
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                EditableActionsColumn.this.onError(target, rowItem.getModel());
            }

            @Override
            protected void onSave(AjaxRequestTarget target) {
                rowItem.setMetaData(EditableDataTable.EDITING, (Serializable)Boolean.valueOf(false));
                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, rowItem);
                target.add(new Component[]{rowItem});
                EditableActionsColumn.this.onSave(target, rowItem.getModel());
            }

            @Override
            protected void onDelete(AjaxRequestTarget target) {
                EditableActionsColumn.this.onDelete(target, rowItem.getModel());
            }

            @Override
            protected boolean allowEdit(Item<T> rowItem2) {
                return EditableActionsColumn.this.allowEdit(rowItem2);
            }

            @Override
            protected boolean allowDelete(Item<T> rowItem2) {
                return EditableActionsColumn.this.allowDelete(rowItem2);
            }
        };
    }

    public void onEdit(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onCancel(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onSave(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onError(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected void onDelete(AjaxRequestTarget target, IModel<T> rowModel) {
    }

    protected boolean allowEdit(Item<T> rowItem) {
        return true;
    }

    protected boolean allowDelete(Item<T> rowItem) {
        return true;
    }
}

