/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AbstractAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AnySearchNode;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchViewSupport;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

abstract class AbstractJPAAnySearchDAO
extends AbstractAnySearchDAO {
    protected static final String SELECT_COLS_FROM_VIEW = "any_id,creationContext,creationDate,creator,lastChangeContext,lastChangeDate,lastModifier,status,changePwdDate,cipherAlgorithm,failedLogins,lastLoginDate,mustChangePassword,suspended,username";
    private static final Map<String, Boolean> IS_ORACLE = new ConcurrentHashMap<String, Boolean>();
    protected final EntityManagerFactory entityManagerFactory;
    protected final EntityManager entityManager;

    protected static int setParameter(List<Object> parameters, Object parameter) {
        parameters.add(parameter);
        return parameters.size();
    }

    protected static void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object object = parameters.get(i);
            if (object instanceof Boolean) {
                Boolean aBoolean = (Boolean)object;
                query.setParameter(i + 1, (Object)(aBoolean != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    protected static Supplier<SyncopeClientException> syncopeClientException(String message) {
        return () -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
            sce.getElements().add(message);
            return sce;
        };
    }

    protected AbstractJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, plainSchemaDAO, entityFactory, anyUtilsFactory, validator);
        this.entityManagerFactory = entityManagerFactory;
        this.entityManager = entityManager;
    }

    protected boolean isOracle() {
        return IS_ORACLE.computeIfAbsent(AuthContextUtils.getDomain(), k -> {
            OpenJPAEntityManagerFactorySPI emfspi = (OpenJPAEntityManagerFactorySPI)this.entityManagerFactory.unwrap(OpenJPAEntityManagerFactorySPI.class);
            return ((MappingRepository)emfspi.getConfiguration().getMetaDataRepositoryInstance()).getDBDictionary() instanceof OracleDictionary;
        });
    }

    protected SearchSupport.SearchView defaultSV(SearchSupport svs) {
        return svs.field();
    }

    protected String anyId(SearchSupport.SearchView sv) {
        return sv.alias() + ".any_id";
    }

    protected String anyId(SearchSupport svs) {
        return this.anyId(this.defaultSV(svs));
    }

    protected Optional<AnySearchNode> getQueryForCustomConds(SearchCond cond, List<Object> parameters, SearchSupport svs, boolean not) {
        return Optional.empty();
    }

    protected Optional<QueryInfo> getQuery(SearchCond cond, List<Object> parameters, SearchSupport svs) {
        boolean not = cond.getType() == SearchCond.Type.NOT_LEAF;
        Optional<Object> node = Optional.empty();
        HashSet plainSchemas = new HashSet();
        switch (cond.getType()) {
            case LEAF: 
            case NOT_LEAF: {
                if (node.isEmpty()) {
                    node = cond.asLeaf(AnyTypeCond.class).filter(leaf -> AnyTypeKind.ANY_OBJECT == svs.anyTypeKind).map(leaf -> this.getQuery((AnyTypeCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(AuxClassCond.class).map(leaf -> this.getQuery((AuxClassCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(RelationshipTypeCond.class).map(leaf -> this.getQuery((RelationshipTypeCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(RelationshipCond.class).map(leaf -> this.getQuery((RelationshipCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(MembershipCond.class).map(leaf -> this.getQuery((MembershipCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(MemberCond.class).map(leaf -> this.getQuery((MemberCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(RoleCond.class).filter(leaf -> AnyTypeKind.USER == svs.anyTypeKind).map(leaf -> this.getQuery((RoleCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(DynRealmCond.class).map(leaf -> this.getQuery((DynRealmCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(ResourceCond.class).map(leaf -> this.getQuery((ResourceCond)leaf, not, parameters, svs));
                }
                if (node.isEmpty()) {
                    node = cond.asLeaf(AnyCond.class).map(anyCond -> this.getQuery((AnyCond)anyCond, not, parameters, svs)).or(() -> cond.asLeaf(AttrCond.class).map(attrCond -> {
                        AbstractAnySearchDAO.CheckResult checked = this.check((AttrCond)attrCond);
                        AttrCondQuery query = this.getQuery((AttrCond)attrCond, not, (AbstractAnySearchDAO.CheckResult<AttrCond>)checked, parameters, svs);
                        if (query.addPlainSchemas().booleanValue()) {
                            plainSchemas.add(checked.schema().getKey());
                        }
                        return query.node();
                    }));
                }
                if (!node.isEmpty()) break;
                node = this.getQueryForCustomConds(cond, parameters, svs, not);
                break;
            }
            case AND: {
                AnySearchNode andNode = new AnySearchNode(AnySearchNode.Type.AND);
                this.getQuery(cond.getLeft(), parameters, svs).ifPresent(left -> {
                    andNode.add(left.node());
                    plainSchemas.addAll(left.plainSchemas());
                });
                this.getQuery(cond.getRight(), parameters, svs).ifPresent(right -> {
                    andNode.add(right.node());
                    plainSchemas.addAll(right.plainSchemas());
                });
                if (andNode.getChildren().isEmpty()) break;
                node = Optional.of(andNode);
                break;
            }
            case OR: {
                AnySearchNode orNode = new AnySearchNode(AnySearchNode.Type.OR);
                this.getQuery(cond.getLeft(), parameters, svs).ifPresent(left -> {
                    orNode.add(left.node());
                    plainSchemas.addAll(left.plainSchemas());
                });
                this.getQuery(cond.getRight(), parameters, svs).ifPresent(right -> {
                    orNode.add(right.node());
                    plainSchemas.addAll(right.plainSchemas());
                });
                if (orNode.getChildren().isEmpty()) break;
                node = Optional.of(orNode);
                break;
            }
        }
        return node.map(n -> new QueryInfo((AnySearchNode)n, plainSchemas));
    }

    protected AnySearchNode getQuery(AnyTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("type_id");
        if (not) {
            clause.append("<>");
        } else {
            clause.append('=');
        }
        clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getAnyTypeKey()));
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(AuxClassCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT any_id FROM ").append(svs.auxClass().name()).append(" WHERE anyTypeClass_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getAuxClass())).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(RelationshipTypeCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT any_id ").append("FROM ").append(svs.relationship().name()).append(" WHERE type=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(" UNION SELECT right_any_id AS any_id FROM ").append(svs.relationship().name()).append(" WHERE type=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRelationshipTypeKey())).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(RelationshipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set rightAnyObjects = this.check(cond);
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.relationship().name()).append(" WHERE ").append(rightAnyObjects.stream().map(key -> "right_any_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(MembershipCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        List groupKeys = this.check(cond);
        String subwhere = groupKeys.stream().map(key -> "group_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "));
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.membership().name()).append(" WHERE ").append(subwhere).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.dyngroupmembership().name()).append(" WHERE ").append(subwhere).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(RoleCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.role().name()).append(" WHERE ").append("role_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRole())).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrolemembership().name()).append(" WHERE ").append("role_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getRole())).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(DynRealmCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder("(");
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(SearchSupport.dynrealmmembership().name()).append(" WHERE ").append("dynRealm_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getDynRealm())).append("))");
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(ResourceCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT any_id FROM ").append(svs.resource().name()).append(" WHERE resource_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        if (svs.anyTypeKind == AnyTypeKind.USER || svs.anyTypeKind == AnyTypeKind.ANY_OBJECT) {
            clause.append(" UNION SELECT DISTINCT any_id FROM ").append(svs.groupResource().name()).append(" WHERE resource_id=?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getResource()));
        }
        clause.append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode getQuery(MemberCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        Set members = this.check(cond);
        StringBuilder clause = new StringBuilder();
        if (not) {
            clause.append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport(AnyTypeKind.USER).membership().name()).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(") ");
        if (not) {
            clause.append("AND ").append(this.anyId(svs)).append(" NOT IN (");
        } else {
            clause.append("OR ").append(this.anyId(svs)).append(" IN (");
        }
        clause.append("SELECT DISTINCT group_id AS any_id FROM ").append(new SearchSupport(AnyTypeKind.ANY_OBJECT).membership().name()).append(" WHERE ").append(members.stream().map(key -> "any_id=?" + AbstractJPAAnySearchDAO.setParameter(parameters, key)).collect(Collectors.joining(" OR "))).append(')');
        return new AnySearchNode.Leaf(this.defaultSV(svs), clause.toString());
    }

    protected AnySearchNode.Leaf fillAttrQuery(String column, SearchSupport.SearchView from, PlainAttrValue attrValue, PlainSchema schema, AttrCond cond, boolean not, List<Object> parameters) {
        boolean ignoreCase = AttrCond.Type.ILIKE == cond.getType() || AttrCond.Type.IEQ == cond.getType();
        Object left = column;
        if (ignoreCase && (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum)) {
            left = "LOWER(" + (String)left + ")";
        }
        StringBuilder clause = new StringBuilder((String)left);
        switch (cond.getType()) {
            case ILIKE: 
            case LIKE: {
                if (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum) {
                    if (not) {
                        clause.append(" NOT ");
                    }
                    clause.append(" LIKE ");
                    if (ignoreCase) {
                        clause.append("LOWER(?").append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getExpression())).append(')');
                    } else {
                        clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, cond.getExpression()));
                    }
                    if (!this.isOracle()) break;
                    clause.append(" ESCAPE '\\'");
                    break;
                }
                LOG.error("LIKE is only compatible with string or enum schemas");
                return new AnySearchNode.Leaf(from, "1=2");
            }
            default: {
                if (not) {
                    clause.append("<>");
                } else {
                    clause.append('=');
                }
                if (ignoreCase && (schema.getType() == AttrSchemaType.String || schema.getType() == AttrSchemaType.Enum)) {
                    clause.append("LOWER(?").append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue())).append(')');
                    break;
                }
                clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GE: {
                if (not) {
                    clause.append('<');
                } else {
                    clause.append(">=");
                }
                clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case GT: {
                if (not) {
                    clause.append("<=");
                } else {
                    clause.append('>');
                }
                clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LE: {
                if (not) {
                    clause.append('>');
                } else {
                    clause.append("<=");
                }
                clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
                break;
            }
            case LT: {
                if (not) {
                    clause.append(">=");
                } else {
                    clause.append('<');
                }
                clause.append('?').append(AbstractJPAAnySearchDAO.setParameter(parameters, attrValue.getValue()));
            }
        }
        return new AnySearchNode.Leaf(from, (String)(cond instanceof AnyCond ? clause.toString() : from.alias() + ".schema_id='" + schema.getKey() + "' AND " + String.valueOf(clause)));
    }

    protected AttrCondQuery getQuery(AttrCond cond, boolean not, AbstractAnySearchDAO.CheckResult<AttrCond> checked, List<Object> parameters, SearchSupport svs) {
        AnySearchNode.Leaf node;
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        SearchSupport.SearchView sv = checked.schema().isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr() : svs.asSearchViewSupport().attr();
        switch (cond.getType()) {
            case ISNOTNULL: {
                return new AttrCondQuery(true, new AnySearchNode.Leaf(sv, sv.alias() + ".schema_id='" + checked.schema().getKey() + "'"));
            }
            case ISNULL: {
                String clause = this.anyId(svs) + " NOT IN " + '(' + "SELECT DISTINCT any_id FROM " + sv.name() + " WHERE schema_id=" + "'" + checked.schema().getKey() + "'" + ')';
                return new AttrCondQuery(true, new AnySearchNode.Leaf(this.defaultSV(svs), clause));
            }
        }
        if (not && checked.schema().isMultivalue()) {
            AnySearchNode.Leaf notNode = this.fillAttrQuery(sv.alias() + "." + AbstractJPAAnySearchDAO.key((AttrSchemaType)checked.schema().getType()), sv, checked.value(), checked.schema(), cond, false, parameters);
            node = new AnySearchNode.Leaf(sv, this.anyId(svs) + " NOT IN (SELECT any_id FROM " + sv.name() + " WHERE " + notNode.getClause().replace(sv.alias() + ".", "") + ")");
        } else {
            node = this.fillAttrQuery(sv.alias() + "." + AbstractJPAAnySearchDAO.key((AttrSchemaType)checked.schema().getType()), sv, checked.value(), checked.schema(), cond, not, parameters);
        }
        return new AttrCondQuery(true, node);
    }

    protected AnySearchNode getQuery(AnyCond cond, boolean not, List<Object> parameters, SearchSupport svs) {
        if ("realm".equals(cond.getSchema()) && !SyncopeConstants.UUID_PATTERN.matcher(cond.getExpression()).matches()) {
            Realm realm = (Realm)this.realmSearchDAO.findByFullPath(cond.getExpression()).orElseThrow(() -> new IllegalArgumentException("Invalid Realm full path: " + cond.getExpression()));
            cond.setExpression(realm.getKey());
        }
        AbstractAnySearchDAO.CheckResult checked = this.check(cond, svs.anyTypeKind);
        return switch (((AnyCond)checked.cond()).getType()) {
            case AttrCond.Type.ISNULL -> new AnySearchNode.Leaf(this.defaultSV(svs), ((AnyCond)checked.cond()).getSchema() + (not ? " IS NOT NULL" : " IS NULL"));
            case AttrCond.Type.ISNOTNULL -> new AnySearchNode.Leaf(this.defaultSV(svs), ((AnyCond)checked.cond()).getSchema() + (not ? " IS NULL" : " IS NOT NULL"));
            default -> this.fillAttrQuery(((AnyCond)checked.cond()).getSchema(), this.defaultSV(svs), checked.value(), checked.schema(), checked.cond(), not, parameters);
        };
    }

    protected AnySearchNode.Leaf buildAdminRealmsFilter(Set<String> realmKeys, SearchSupport svs, List<Object> parameters) {
        if (realmKeys.isEmpty()) {
            return new AnySearchNode.Leaf(this.defaultSV(svs), StringUtils.substringAfter((String)this.anyId(svs), (int)46) + " IS NOT NULL");
        }
        String realmKeysArg = realmKeys.stream().map(realmKey -> "?" + AbstractJPAAnySearchDAO.setParameter(parameters, realmKey)).collect(Collectors.joining(","));
        return new AnySearchNode.Leaf(this.defaultSV(svs), "realm_id IN (" + realmKeysArg + ")");
    }

    protected AdminRealmsFilter getAdminRealmsFilter(Realm base, boolean recursive, Set<String> adminRealms, List<Object> parameters, SearchSupport svs) {
        HashSet<String> realmKeys = new HashSet<String>();
        HashSet<String> dynRealmKeys = new HashSet<String>();
        HashSet<String> groupOwners = new HashSet<String>();
        if (recursive) {
            adminRealms.forEach(realmPath -> RealmUtils.GroupOwnerRealm.of((String)realmPath).ifPresentOrElse(goRealm -> groupOwners.add(goRealm.groupKey()), () -> {
                if (realmPath.startsWith("/")) {
                    Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmPath).orElseThrow(() -> {
                        SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
                        noRealm.getElements().add("Invalid realm specified: " + realmPath);
                        return noRealm;
                    });
                    realmKeys.addAll(this.realmSearchDAO.findDescendants(realm.getFullPath(), base.getFullPath()));
                } else {
                    this.dynRealmDAO.findById(realmPath).ifPresentOrElse(dynRealm -> dynRealmKeys.add(dynRealm.getKey()), () -> LOG.warn("Ignoring invalid dynamic realm {}", realmPath));
                }
            }));
            if (!dynRealmKeys.isEmpty()) {
                realmKeys.clear();
            }
        } else if (adminRealms.stream().anyMatch(r -> r.startsWith(base.getFullPath()))) {
            realmKeys.add(base.getKey());
        }
        return new AdminRealmsFilter(this.buildAdminRealmsFilter(realmKeys, svs, parameters), dynRealmKeys, groupOwners);
    }

    protected void visitNode(AnySearchNode node, Map<SearchSupport.SearchView, Boolean> counters, Set<SearchSupport.SearchView> from, List<String> where, SearchSupport svs) {
        node.asLeaf().ifPresentOrElse(leaf -> {
            from.add(leaf.getFrom());
            if (counters.computeIfAbsent(leaf.getFrom(), view -> false).booleanValue() && !leaf.getClause().contains(" IN ")) {
                where.add(this.anyId(svs) + " IN (SELECT any_id FROM " + leaf.getFrom().name() + " WHERE " + leaf.getClause().replace(leaf.getFrom().alias() + ".", "") + ")");
            } else {
                counters.put(leaf.getFrom(), true);
                where.add(leaf.getClause());
            }
        }, () -> {
            ArrayList nodeWhere = new ArrayList();
            node.getChildren().forEach(child -> this.visitNode((AnySearchNode)child, counters, from, nodeWhere, svs));
            where.add(nodeWhere.stream().map(w -> "(" + w + ")").collect(Collectors.joining(" " + node.getType().name() + " ")));
        });
    }

    protected String buildFrom(Set<SearchSupport.SearchView> from, Set<String> plainSchemas, OrderBySupport obs) {
        Object fromString;
        if (from.size() == 1) {
            SearchSupport.SearchView sv = from.iterator().next();
            fromString = sv.name() + " " + sv.alias();
        } else {
            ArrayList<SearchSupport.SearchView> joins = new ArrayList<SearchSupport.SearchView>(from);
            StringBuilder join = new StringBuilder(((SearchSupport.SearchView)joins.getFirst()).name() + " " + ((SearchSupport.SearchView)joins.getFirst()).alias());
            for (int i = 1; i < joins.size(); ++i) {
                SearchSupport.SearchView sv = (SearchSupport.SearchView)joins.get(i);
                join.append(" LEFT JOIN ").append(sv.name()).append(" ").append(sv.alias()).append(" ON ").append(this.anyId((SearchSupport.SearchView)joins.getFirst())).append('=').append(this.anyId(sv));
            }
            fromString = join.toString();
        }
        return fromString;
    }

    protected String buildWhere(List<String> where, AnySearchNode root) {
        return where.stream().map(w -> "(" + w + ")").collect(Collectors.joining(" " + root.getType().name() + " "));
    }

    protected String buildCountQuery(QueryInfo queryInfo, AnySearchNode.Leaf filterNode, List<Object> parameters, SearchSupport svs) {
        AnySearchNode root;
        if (queryInfo.node().getType() == AnySearchNode.Type.AND) {
            root = queryInfo.node();
        } else {
            root = new AnySearchNode(AnySearchNode.Type.AND);
            root.add(queryInfo.node());
        }
        root.add(filterNode);
        HashSet<SearchSupport.SearchView> from = new HashSet<SearchSupport.SearchView>();
        ArrayList<String> where = new ArrayList<String>();
        HashMap<SearchSupport.SearchView, Boolean> counters = new HashMap<SearchSupport.SearchView, Boolean>();
        this.visitNode(root, counters, from, where, svs);
        StringBuilder queryString = new StringBuilder("SELECT COUNT(DISTINCT ").append(this.anyId(svs)).append(") ");
        queryString.append("FROM ").append(this.buildFrom(from, queryInfo.plainSchemas(), null));
        queryString.append(" WHERE ").append(this.buildWhere(where, root));
        LOG.debug("Query: {}, parameters: {}", (Object)queryString, parameters);
        return queryString.toString();
    }

    protected long doCount(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchViewSupport svs = new SearchViewSupport(kind);
        AdminRealmsFilter filter = this.getAdminRealmsFilter(base, recursive, adminRealms, parameters, svs);
        QueryInfo queryInfo = this.getQuery(AbstractJPAAnySearchDAO.buildEffectiveCond((SearchCond)cond, filter.dynRealmKeys(), filter.groupOwners(), (AnyTypeKind)kind), parameters, svs).orElse(null);
        if (queryInfo == null) {
            LOG.error("Invalid search condition: {}", (Object)cond);
            return 0L;
        }
        String queryString = this.buildCountQuery(queryInfo, filter.filter(), parameters, svs);
        Query countQuery = this.entityManager.createNativeQuery(queryString);
        AbstractJPAAnySearchDAO.fillWithParameters(countQuery, parameters);
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        boolean bl = obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        if (schema.isUniqueConstraint()) {
            obs.views.add(svs.asSearchViewSupport().uniqueAttr());
            item.select = svs.asSearchViewSupport().uniqueAttr().alias() + '.' + AbstractJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + " AS " + fieldName;
            item.where = svs.asSearchViewSupport().uniqueAttr().alias() + ".schema_id='" + fieldName + "'";
            item.orderBy = fieldName + " " + clause.getDirection().name();
        } else {
            obs.views.add(svs.asSearchViewSupport().attr());
            item.select = svs.asSearchViewSupport().attr().alias() + '.' + AbstractJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + " AS " + fieldName;
            item.where = svs.asSearchViewSupport().attr().alias() + ".schema_id='" + fieldName + "'";
            item.orderBy = fieldName + " " + clause.getDirection().name();
        }
    }

    protected void parseOrderByForField(SearchSupport svs, OrderBySupport.Item item, String fieldName, Sort.Order clause) {
        item.select = this.defaultSV(svs).alias() + "." + fieldName;
        item.where = "";
        item.orderBy = this.defaultSV(svs).alias() + "." + fieldName + " " + clause.getDirection().name();
    }

    protected void parseOrderByForCustom(SearchSupport svs, Sort.Order clause, OrderBySupport.Item item, OrderBySupport obs) {
    }

    protected OrderBySupport parseOrderBy(SearchSupport svs, List<Sort.Order> orderBy) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(svs.anyTypeKind);
        OrderBySupport obs = new OrderBySupport();
        HashSet orderByUniquePlainSchemas = new HashSet();
        HashSet orderByNonUniquePlainSchemas = new HashSet();
        orderBy.forEach(clause -> {
            OrderBySupport.Item item = new OrderBySupport.Item();
            this.parseOrderByForCustom(svs, (Sort.Order)clause, item, obs);
            if (item.isEmpty()) {
                anyUtils.getField(clause.getProperty()).ifPresentOrElse(field -> {
                    Object fieldName;
                    Object object = fieldName = "key".equals(clause.getProperty()) ? "id" : clause.getProperty();
                    if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)fieldName)) {
                        fieldName = (String)fieldName + "_id";
                    }
                    obs.views.add(this.defaultSV(svs));
                    this.parseOrderByForField(svs, item, (String)fieldName, (Sort.Order)clause);
                }, () -> this.plainSchemaDAO.findById(clause.getProperty()).ifPresent(schema -> {
                    if (schema.isUniqueConstraint()) {
                        orderByUniquePlainSchemas.add(schema.getKey());
                    } else {
                        orderByNonUniquePlainSchemas.add(schema.getKey());
                    }
                    if (orderByUniquePlainSchemas.size() > 1 || orderByNonUniquePlainSchemas.size() > 1) {
                        throw AbstractJPAAnySearchDAO.syncopeClientException("Order by more than one attribute is not allowed; remove one from " + String.valueOf(orderByUniquePlainSchemas.size() > 1 ? orderByUniquePlainSchemas : orderByNonUniquePlainSchemas)).get();
                    }
                    this.parseOrderByForPlainSchema(svs, obs, item, (Sort.Order)clause, (PlainSchema)schema, clause.getProperty());
                }));
            }
            if (item.isEmpty()) {
                LOG.warn("Cannot build any valid clause from {}", clause);
            } else {
                obs.items.add(item);
            }
        });
        return obs;
    }

    protected String buildSearchQuery(QueryInfo queryInfo, AnySearchNode.Leaf filterNode, List<Object> parameters, SearchSupport svs, List<Sort.Order> orderBy) {
        AnySearchNode root;
        if (queryInfo.node().getType() == AnySearchNode.Type.AND) {
            root = queryInfo.node();
        } else {
            root = new AnySearchNode(AnySearchNode.Type.AND);
            root.add(queryInfo.node());
        }
        root.add(filterNode);
        HashSet<SearchSupport.SearchView> from = new HashSet<SearchSupport.SearchView>();
        ArrayList<String> where = new ArrayList<String>();
        HashMap<SearchSupport.SearchView, Boolean> counters = new HashMap<SearchSupport.SearchView, Boolean>();
        this.visitNode(root, counters, from, where, svs);
        OrderBySupport obs = this.parseOrderBy(svs, orderBy);
        StringBuilder queryString = new StringBuilder("SELECT DISTINCT ").append(this.anyId(svs));
        obs.items.forEach(item -> queryString.append(',').append(item.select));
        from.addAll(obs.views);
        queryString.append(" FROM ").append(this.buildFrom(from, queryInfo.plainSchemas(), obs));
        queryString.append(" WHERE ").append(this.buildWhere(where, root));
        if (!obs.items.isEmpty()) {
            queryString.append(" ORDER BY ").append(obs.items.stream().map(item -> item.orderBy).collect(Collectors.joining(",")));
        }
        LOG.debug("Query: {}, parameters: {}", (Object)queryString, parameters);
        return queryString.toString();
    }

    protected <T extends Any> List<T> doSearch(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, Pageable pageable, AnyTypeKind kind) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SearchViewSupport svs = new SearchViewSupport(kind);
        AdminRealmsFilter filter = this.getAdminRealmsFilter(base, recursive, adminRealms, parameters, svs);
        QueryInfo queryInfo = this.getQuery(AbstractJPAAnySearchDAO.buildEffectiveCond((SearchCond)cond, filter.dynRealmKeys(), filter.groupOwners(), (AnyTypeKind)kind), parameters, svs).orElse(null);
        if (queryInfo == null) {
            LOG.error("Invalid search condition: {}", (Object)cond);
            return List.of();
        }
        String queryString = this.buildSearchQuery(queryInfo, filter.filter(), parameters, svs, pageable.getSort().toList());
        Query query = this.entityManager.createNativeQuery(queryString);
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        AbstractJPAAnySearchDAO.fillWithParameters(query, parameters);
        return this.buildResult(query.getResultList(), kind);
    }

    protected record AttrCondQuery(Boolean addPlainSchemas, AnySearchNode node) {
    }

    protected record AdminRealmsFilter(AnySearchNode.Leaf filter, Set<String> dynRealmKeys, Set<String> groupOwners) {
    }

    protected record QueryInfo(AnySearchNode node, Set<String> plainSchemas) {
    }
}

