/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.LogsPanel;
import org.apache.syncope.client.console.rest.LoggerConf;
import org.apache.syncope.client.console.rest.LoggerConfOp;
import org.apache.syncope.client.console.rest.LoggerConfRestClient;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;

public class Logs
extends BasePage {
    private static final long serialVersionUID = -1100228004207271271L;
    @SpringBean
    private ServiceOps serviceOps;
    @SpringBean
    private DomainOps domainOps;
    @SpringBean
    private LoggingSystem loggingSystem;

    public Logs(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", "dashboardBr", Dashboard.class)});
        WebMarkupContainer content = new WebMarkupContainer("content");
        this.body.add(new Component[]{content.setOutputMarkupId(true)});
        content.add(new Component[]{new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList())});
    }

    private List<ITab> buildTabList() {
        List sraInstances;
        List waInstances;
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        final List domains = this.domainOps.list();
        final List coreInstances = this.serviceOps.list(NetworkService.Type.CORE);
        tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)NetworkService.Type.CORE.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new LogsPanel(panelId, new LoggerConfRestClient(coreInstances, domains), Logs.this.getPageReference());
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)NetworkService.Type.CONSOLE.name()))){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new LogsPanel(panelId, new LoggerConfOp(){
                    private static final long serialVersionUID = 24740659553491L;

                    @Override
                    public List<LoggerConf> list() {
                        List configurations = Logs.this.loggingSystem.getLoggerConfigurations();
                        if (configurations == null) {
                            return List.of();
                        }
                        return configurations.stream().map(conf -> {
                            LoggerConf loggerConf = new LoggerConf();
                            loggerConf.setKey(conf.getName());
                            loggerConf.setLevel(conf.getEffectiveLevel());
                            return loggerConf;
                        }).sorted(Comparator.comparing(LoggerConf::getKey)).collect(Collectors.toList());
                    }

                    @Override
                    public void setLevel(String key, LogLevel level) {
                        Logs.this.loggingSystem.setLogLevel(key, level);
                    }
                }, Logs.this.getPageReference());
            }
        });
        final List euInstances = this.serviceOps.list(NetworkService.Type.ENDUSER);
        if (!euInstances.isEmpty()) {
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)NetworkService.Type.ENDUSER.name()))){
                private static final long serialVersionUID = -6815067322125799251L;

                public Panel getPanel(String panelId) {
                    return new LogsPanel(panelId, new LoggerConfRestClient(euInstances, domains), Logs.this.getPageReference());
                }
            });
        }
        if (!(waInstances = this.serviceOps.list(NetworkService.Type.WA)).isEmpty()) {
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)NetworkService.Type.WA.name()))){
                private static final long serialVersionUID = -6815067322125799251L;

                public Panel getPanel(String panelId) {
                    return new LogsPanel(panelId, new LoggerConfRestClient(waInstances, domains), Logs.this.getPageReference());
                }
            });
        }
        if (!(sraInstances = this.serviceOps.list(NetworkService.Type.SRA)).isEmpty()) {
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)NetworkService.Type.SRA.name()))){
                private static final long serialVersionUID = -6815067322125799251L;

                public Panel getPanel(String panelId) {
                    return new LogsPanel(panelId, new LoggerConfRestClient(sraInstances, domains), Logs.this.getPageReference());
                }
            });
        }
        return tabs;
    }
}

