/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AuditConfTO;
import org.apache.syncope.common.lib.to.AuditEventTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AuditConf;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ImplementationLookup;
import org.apache.syncope.core.provisioning.api.data.AuditDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class AuditLogic
extends AbstractTransactionalLogic<AuditConfTO> {
    protected static final List<OpEvent> EVENTS = new ArrayList<OpEvent>();
    protected final AuditConfDAO auditConfDAO;
    protected final AuditEventDAO auditEventDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final EntityFactory entityFactory;
    protected final ImplementationLookup implementationLookup;
    protected final AuditDataBinder binder;
    protected final AuditManager auditManager;

    protected static void addForOutcomes(Set<OpEvent> events, OpEvent.CategoryType type, String category, String subcategory, String op) {
        events.add(new OpEvent(type, category, subcategory, op, OpEvent.Outcome.SUCCESS));
        events.add(new OpEvent(type, category, subcategory, op, OpEvent.Outcome.FAILURE));
    }

    public AuditLogic(AuditConfDAO auditConfDAO, AuditEventDAO auditEventDAO, ExternalResourceDAO resourceDAO, EntityFactory entityFactory, ImplementationLookup implementationLookup, AuditDataBinder binder, AuditManager auditManager) {
        this.auditConfDAO = auditConfDAO;
        this.auditEventDAO = auditEventDAO;
        this.resourceDAO = resourceDAO;
        this.entityFactory = entityFactory;
        this.implementationLookup = implementationLookup;
        this.binder = binder;
        this.auditManager = auditManager;
    }

    @PreAuthorize(value="hasRole('AUDIT_LIST')")
    @Transactional(readOnly=true)
    public List<AuditConfTO> confs() {
        return this.auditConfDAO.findAll().stream().map(arg_0 -> ((AuditDataBinder)this.binder).getAuditConfTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('AUDIT_READ')")
    @Transactional(readOnly=true)
    public AuditConfTO getConf(String key) {
        return this.auditConfDAO.findById(key).map(arg_0 -> ((AuditDataBinder)this.binder).getAuditConfTO(arg_0)).orElseThrow(() -> new NotFoundException("AuditConf " + key));
    }

    @PreAuthorize(value="hasRole('AUDIT_SET')")
    public void setConf(AuditConfTO auditTO) {
        AuditConf audit = this.auditConfDAO.findById(auditTO.getKey()).orElse(null);
        if (audit == null) {
            audit = (AuditConf)this.entityFactory.newEntity(AuditConf.class);
            audit.setKey(auditTO.getKey());
        }
        audit.setActive(auditTO.isActive());
        this.auditConfDAO.save((Entity)audit);
    }

    @PreAuthorize(value="hasRole('AUDIT_DELETE')")
    public void deleteConf(String key) {
        AuditConf audit = (AuditConf)this.auditConfDAO.findById(key).orElseThrow(() -> new NotFoundException("AuditConf " + key));
        this.auditConfDAO.delete((Entity)audit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('AUDIT_LIST') or hasRole('NOTIFICATION_LIST')")
    public List<OpEvent> events() {
        List<OpEvent> list = EVENTS;
        synchronized (list) {
            if (!EVENTS.isEmpty()) {
                return EVENTS;
            }
        }
        HashSet<OpEvent> events = new HashSet<OpEvent>();
        AuditLogic.addForOutcomes(events, OpEvent.CategoryType.LOGIC, "AUTHENTICATION", null, "login");
        this.implementationLookup.getClassNames("TASKJOB_DELEGATE").forEach(clazz -> AuditLogic.addForOutcomes(events, OpEvent.CategoryType.TASK, StringUtils.substringAfterLast((String)clazz, (int)46), null, null));
        AuditLogic.addForOutcomes(events, OpEvent.CategoryType.WA, null, null, null);
        AuditLogic.addForOutcomes(events, OpEvent.CategoryType.CUSTOM, null, null, null);
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)this.getClass().getPackage().getName())) + "/**/*.class";
            for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader;
                Class<?> clazz2;
                if (!resource.isReadable() || !AbstractLogic.class.isAssignableFrom(clazz2 = Class.forName((metadataReader = metadataReaderFactory.getMetadataReader(resource)).getClassMetadata().getClassName()))) continue;
                for (Method method : clazz2.getDeclaredMethods()) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    AuditLogic.addForOutcomes(events, OpEvent.CategoryType.LOGIC, clazz2.getSimpleName(), null, method.getName());
                }
            }
            for (Resource resource : AnyTypeKind.values()) {
                this.resourceDAO.findAll().forEach(arg_0 -> AuditLogic.lambda$events$3(events, (AnyTypeKind)resource, arg_0));
            }
        }
        catch (Exception e) {
            LOG.error("Failure retrieving op events", (Throwable)e);
        }
        EVENTS.addAll(events);
        return EVENTS;
    }

    @PreAuthorize(value="hasRole('AUDIT_SEARCH')")
    @Transactional(readOnly=true)
    public Page<AuditEventTO> search(String entityKey, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome result, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        long count = this.auditEventDAO.count(entityKey, type, category, subcategory, op, result, before, after);
        List matching = this.auditEventDAO.search(entityKey, type, category, subcategory, op, result, before, after, pageable);
        return new SyncopePage(matching, pageable, count);
    }

    @PreAuthorize(value="isAuthenticated()")
    public void create(AuditEventTO eventTO) {
        boolean authorized;
        boolean bl = authorized = AuthContextUtils.getAuthorizations().containsKey("AUDIT_SET") || AuthContextUtils.getAuthorizations().containsKey("ANONYMOUS") && OpEvent.CategoryType.WA == eventTO.getOpEvent().getType();
        if (!authorized) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add("Not allowed to create Audit entries");
            throw sce;
        }
        this.auditManager.audit(AuthContextUtils.getDomain(), eventTO.getWho(), eventTO.getOpEvent().getType(), eventTO.getOpEvent().getCategory(), eventTO.getOpEvent().getSubcategory(), eventTO.getOpEvent().getOp(), eventTO.getOpEvent().getOutcome(), (Object)eventTO.getBefore(), (Object)eventTO.getOutput(), new Object[]{eventTO.getInputs()});
    }

    @Override
    protected AuditConfTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof AuditConfTO)) continue;
                AuditConfTO auditConfTO = (AuditConfTO)object;
                key = auditConfTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAuditConfTO((AuditConf)this.auditConfDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }

    private static /* synthetic */ void lambda$events$3(Set events, AnyTypeKind anyTypeKind, ExternalResource resource) {
        String op;
        for (ResourceOperation resourceOperation : ResourceOperation.values()) {
            AuditLogic.addForOutcomes(events, OpEvent.CategoryType.PROPAGATION, anyTypeKind.name(), resource.getKey(), resourceOperation.name().toLowerCase());
        }
        for (ResourceOperation resourceOperation : UnmatchingRule.values()) {
            op = UnmatchingRule.toOp((UnmatchingRule)resourceOperation);
            AuditLogic.addForOutcomes(events, OpEvent.CategoryType.PULL, anyTypeKind.name(), resource.getKey(), op);
            AuditLogic.addForOutcomes(events, OpEvent.CategoryType.PUSH, anyTypeKind.name(), resource.getKey(), op);
        }
        for (ResourceOperation resourceOperation : MatchingRule.values()) {
            op = MatchingRule.toOp((MatchingRule)resourceOperation);
            AuditLogic.addForOutcomes(events, OpEvent.CategoryType.PULL, anyTypeKind.name(), resource.getKey(), op);
            AuditLogic.addForOutcomes(events, OpEvent.CategoryType.PUSH, anyTypeKind.name(), resource.getKey(), op);
        }
        AuditLogic.addForOutcomes(events, OpEvent.CategoryType.PULL, anyTypeKind.name(), resource.getKey(), ResourceOperation.DELETE.name().toLowerCase());
    }
}

